package cn.gtmap.realestate.common.core.domain.building;

import cn.gtmap.realestate.common.core.annotations.RequiredFk;
import cn.gtmap.realestate.common.core.annotations.SaveBdcdyhZt;
import cn.gtmap.realestate.common.core.annotations.Zd;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Id;
import javax.persistence.Table;
import java.util.Date;

/**
 * @author <a href="mailto:wangzijie@gtmap.cn">wangzijie</a>
 * @version 1.0  2018-10-27
 * @description
 */
@Table(name = "fw_ljz")
@ApiModel(value = "FwLjzDO", description = "逻辑幢基本信息实体")
public class FwLjzDO {
    @Id
    /**
     * 主键
     */
    @ApiModelProperty(value = "主键")
    private String fwDcbIndex;
    /**
     * 项目信息主键
     */
    @ApiModelProperty(value = "项目信息主键")
    private String fwXmxxIndex;
    /**
     * 要素代码
     */
    @ApiModelProperty(value = "要素代码")
    private String ysdm;
    /**
     * 隶属宗地
     */
    @ApiModelProperty(value = "隶属宗地")
    @RequiredFk
    private String lszd;
    /**
     * 自然幢号
     */
    @ApiModelProperty(value = "自然幢号")
    private String zrzh;
    /**
     * 不动产单元号
     */
    @ApiModelProperty(value = "不动产单元号")
    @SaveBdcdyhZt
    private String bdcdyh;
    /**
     * 逻辑幢号
     */
    @ApiModelProperty(value = "逻辑幢号")
    private String ljzh;
    /**
     * 不动产单元类型
     */
    @Zd(tableClass = SZdBdcdyFwlxDO.class)
    @ApiModelProperty(value = "不动产单元类型")
    private String bdcdyfwlx;
    /**
     * 项目名称
     */
    @ApiModelProperty(value = "项目名称")
    private String xmmc;
    /**
     * 门牌号
     */
    @ApiModelProperty(value = "门牌号")
    private String mph;
    /**
     * 房屋名称
     */
    @ApiModelProperty(value = "房屋名称")
    private String fwmc;
    /**
     * 幢号
     */
    @ApiModelProperty(value = "幢号")
    private String dh;
    /**
     * 坐落地址
     */
    @ApiModelProperty(value = "坐落地址")
    @SaveBdcdyhZt("zl")
    private String zldz;
    /**
     * 房屋结构
     */
    @Zd(tableClass = SZdFwjgDO.class)
    @ApiModelProperty(value = "房屋结构")
    private String fwjg;
    /**
     * 房屋结构2
     */
    @Zd(tableClass = SZdFwjgDO.class)
    @ApiModelProperty(value = "房屋结构2")
    private String fwjg2;
    /**
     * 房屋结构3
     */
    @Zd(tableClass = SZdFwjgDO.class)
    @ApiModelProperty(value = "房屋结构3")
    private String fwjg3;
    /**
     * 房屋层数
     */
    @ApiModelProperty(value = "房屋层数")
    private Integer fwcs;
    /**
     * 总套数
     */
    @ApiModelProperty(value = "总套数")
    private Integer zts;
    /**
     * 房屋用途
     */
    @Zd(tableClass = SZdFwytDO.class)
    @ApiModelProperty(value = "房屋用途")
    @SaveBdcdyhZt("yt")
    private String fwyt;
    /**
     * 房屋用途2
     */
    @Zd(tableClass = SZdFwytDO.class)
    @ApiModelProperty(value = "房屋用途2")
    private String fwyt2;
    /**
     * 房屋用途3
     */
    @Zd(tableClass = SZdFwytDO.class)
    @ApiModelProperty(value = "房屋用途3")
    private String fwyt3;
    /**
     * 竣工日期
     */
    @ApiModelProperty(value = "竣工日期", example = "2018-10-01 12:18:21")
    private Date jgrq;
    /**
     * 预测建筑面积
     */
    @ApiModelProperty(value = "预测建筑面积")
    private Double ycjzmj;
    /**
     * 预测地下面积
     */
    @ApiModelProperty(value = "预测地下面积")
    private Double ycdxmj;
    /**
     * 预测其他面积
     */
    @ApiModelProperty(value = "预测其他面积")
    private Double ycqtmj;
    /**
     * 实测建筑面积
     */
    @ApiModelProperty(value = "实测建筑面积")
    private Double scjzmj;
    /**
     * 实测地下面积
     */
    @ApiModelProperty(value = "实测地下面积")
    private Double scdxmj;
    /**
     * 实测其他面积
     */
    @ApiModelProperty(value = "实测其他面积")
    private Double scqtmj;
    /**
     * 不动产状态
     */
    @ApiModelProperty(value = "不动产状态")
    @SaveBdcdyhZt("bdcdyzt")
    private String bdczt;
    /**
     * 建筑物状态
     */
    @Zd(tableClass = SZdJzwztDO.class)
    @ApiModelProperty(value = "建筑物状态")
    private String jzwzt;
    /**
     * 变更日期
     */
    @ApiModelProperty(value = "变更日期", example = "2018-10-01 12:18:21")
    private Date gxrq;
    /**
     * 状态日期
     */
    @ApiModelProperty(value = "状态日期", example = "2018-10-01 12:18:21")
    private Date ztrq;
    /**
     * 房屋状态
     */
    @ApiModelProperty(value = "房屋状态")
    private String fwzt;
    /**
     * 备注
     */
    @ApiModelProperty(value = "备注")
    private String bz;
    /**
     * 幢占地面积
     */
    @ApiModelProperty(value = "幢占地面积")
    private String zzdmj;

    /**
     * 地上层数
     */
    @ApiModelProperty(value = "地上层数")
    private Integer dscs;
    /**
     * 地下层数
     */
    @ApiModelProperty(value = "地下层数")
    private Integer dxcs;
    /**
     * 幢用地面积
     */
    @ApiModelProperty(value = "幢用地面积")
    private Double zydmj;

    /**
     * 东
     */
    @ApiModelProperty(value = "东")
    private String d;
    /**
     * 南
     */
    @ApiModelProperty(value = "南")
    private String n;
    /**
     * 西
     */
    @ApiModelProperty(value = "西")
    private String x;
    /**
     * 北
     */
    @ApiModelProperty(value = "北")
    private String b;
    /**
     * 产别
     */
    @ApiModelProperty(value = "产别")
    private String cb;

    @ApiModelProperty(value = "调查者")
    private String dcz;

    @ApiModelProperty(value = "调查时间", example = "2018-10-01 12:18:21")
    private Date dcsj;

    @ApiModelProperty(value = "调查意见")
    private String dcyj;

    @ApiModelProperty(value = "产权来源")
    private String cqly;

    @ApiModelProperty(value = "附加说明")
    private String fjsm;

    @Zd(tableClass = SZdGyfsDO.class)
    @ApiModelProperty(value = "共有情况")
    private String gyqk;

    @ApiModelProperty(value = "受理编号")
    private String slbh;

    @ApiModelProperty(value = "预售许可证号")
    private String ysxkzh;

    @ApiModelProperty(value = "规划许可证号")
    private String ghxkzh;

    public String getDcz() {
        return dcz;
    }

    public void setDcz(String dcz) {
        this.dcz = dcz;
    }

    public Date getDcsj() {
        return dcsj;
    }

    public void setDcsj(Date dcsj) {
        this.dcsj = dcsj;
    }

    public String getDcyj() {
        return dcyj;
    }

    public void setDcyj(String dcyj) {
        this.dcyj = dcyj;
    }

    public String getCqly() {
        return cqly;
    }

    public void setCqly(String cqly) {
        this.cqly = cqly;
    }

    public String getFjsm() {
        return fjsm;
    }

    public void setFjsm(String fjsm) {
        this.fjsm = fjsm;
    }

    public String getGyqk() {
        return gyqk;
    }

    public void setGyqk(String gyqk) {
        this.gyqk = gyqk;
    }

    public String getCb() {
        return cb;
    }

    public void setCb(String cb) {
        this.cb = cb;
    }

    public Integer getDscs() {
        return dscs;
    }

    public void setDscs(Integer dscs) {
        this.dscs = dscs;
    }

    public Integer getDxcs() {
        return dxcs;
    }

    public void setDxcs(Integer dxcs) {
        this.dxcs = dxcs;
    }

    public Double getZydmj() {
        return zydmj;
    }

    public void setZydmj(Double zydmj) {
        this.zydmj = zydmj;
    }

    public String getD() {
        return d;
    }

    public void setD(String d) {
        this.d = d;
    }

    public String getN() {
        return n;
    }

    public void setN(String n) {
        this.n = n;
    }

    public String getX() {
        return x;
    }

    public void setX(String x) {
        this.x = x;
    }

    public String getB() {
        return b;
    }

    public void setB(String b) {
        this.b = b;
    }

    public String getZzdmj() {
        return zzdmj;
    }

    public void setZzdmj(String zzdmj) {
        this.zzdmj = zzdmj;
    }

    public String getFwDcbIndex() {
        return fwDcbIndex;
    }

    public void setFwDcbIndex(String fwDcbIndex) {
        this.fwDcbIndex = fwDcbIndex;
    }

    public String getFwXmxxIndex() {
        return fwXmxxIndex;
    }

    public void setFwXmxxIndex(String fwXmxxIndex) {
        this.fwXmxxIndex = fwXmxxIndex;
    }

    public String getYsdm() {
        return ysdm;
    }

    public void setYsdm(String ysdm) {
        this.ysdm = ysdm;
    }

    public String getLszd() {
        return lszd;
    }

    public void setLszd(String lszd) {
        this.lszd = lszd;
    }

    public String getZrzh() {
        return zrzh;
    }

    public void setZrzh(String zrzh) {
        this.zrzh = zrzh;
    }

    public String getBdcdyh() {
        return bdcdyh;
    }

    public void setBdcdyh(String bdcdyh) {
        this.bdcdyh = bdcdyh;
    }

    public String getLjzh() {
        return ljzh;
    }

    public void setLjzh(String ljzh) {
        this.ljzh = ljzh;
    }

    public String getBdcdyfwlx() {
        return bdcdyfwlx;
    }

    public void setBdcdyfwlx(String bdcdyfwlx) {
        this.bdcdyfwlx = bdcdyfwlx;
    }

    public String getXmmc() {
        return xmmc;
    }

    public void setXmmc(String xmmc) {
        this.xmmc = xmmc;
    }

    public String getMph() {
        return mph;
    }

    public void setMph(String mph) {
        this.mph = mph;
    }

    public String getFwmc() {
        return fwmc;
    }

    public void setFwmc(String fwmc) {
        this.fwmc = fwmc;
    }

    public String getDh() {
        return dh;
    }

    public void setDh(String dh) {
        this.dh = dh;
    }

    public String getZldz() {
        return zldz;
    }

    public void setZldz(String zldz) {
        this.zldz = zldz;
    }

    public String getFwjg() {
        return fwjg;
    }

    public void setFwjg(String fwjg) {
        this.fwjg = fwjg;
    }

    public String getFwjg2() {
        return fwjg2;
    }

    public void setFwjg2(String fwjg2) {
        this.fwjg2 = fwjg2;
    }

    public String getFwjg3() {
        return fwjg3;
    }

    public void setFwjg3(String fwjg3) {
        this.fwjg3 = fwjg3;
    }

    public Integer getFwcs() {
        return fwcs;
    }

    public void setFwcs(Integer fwcs) {
        this.fwcs = fwcs;
    }

    public Integer getZts() {
        return zts;
    }

    public void setZts(Integer zts) {
        this.zts = zts;
    }

    public String getFwyt() {
        return fwyt;
    }

    public void setFwyt(String fwyt) {
        this.fwyt = fwyt;
    }

    public String getFwyt2() {
        return fwyt2;
    }

    public void setFwyt2(String fwyt2) {
        this.fwyt2 = fwyt2;
    }

    public String getFwyt3() {
        return fwyt3;
    }

    public void setFwyt3(String fwyt3) {
        this.fwyt3 = fwyt3;
    }

    public Date getJgrq() {
        return jgrq;
    }

    public void setJgrq(Date jgrq) {
        this.jgrq = jgrq;
    }

    public Double getYcjzmj() {
        return ycjzmj;
    }

    public void setYcjzmj(Double ycjzmj) {
        this.ycjzmj = ycjzmj;
    }

    public Double getYcdxmj() {
        return ycdxmj;
    }

    public void setYcdxmj(Double ycdxmj) {
        this.ycdxmj = ycdxmj;
    }

    public Double getYcqtmj() {
        return ycqtmj;
    }

    public void setYcqtmj(Double ycqtmj) {
        this.ycqtmj = ycqtmj;
    }

    public Double getScjzmj() {
        return scjzmj;
    }

    public void setScjzmj(Double scjzmj) {
        this.scjzmj = scjzmj;
    }

    public Double getScdxmj() {
        return scdxmj;
    }

    public void setScdxmj(Double scdxmj) {
        this.scdxmj = scdxmj;
    }

    public Double getScqtmj() {
        return scqtmj;
    }

    public void setScqtmj(Double scqtmj) {
        this.scqtmj = scqtmj;
    }

    public String getBdczt() {
        return bdczt;
    }

    public void setBdczt(String bdczt) {
        this.bdczt = bdczt;
    }

    public String getJzwzt() {
        return jzwzt;
    }

    public void setJzwzt(String jzwzt) {
        this.jzwzt = jzwzt;
    }

    public Date getGxrq() {
        return gxrq;
    }

    public void setGxrq(Date gxrq) {
        this.gxrq = gxrq;
    }

    public Date getZtrq() {
        return ztrq;
    }

    public void setZtrq(Date ztrq) {
        this.ztrq = ztrq;
    }

    public String getFwzt() {
        return fwzt;
    }

    public void setFwzt(String fwzt) {
        this.fwzt = fwzt;
    }

    public String getBz() {
        return bz;
    }

    public void setBz(String bz) {
        this.bz = bz;
    }

    public String getSlbh() {
        return slbh;
    }

    public void setSlbh(String slbh) {
        this.slbh = slbh;
    }

    public String getYsxkzh() {
        return ysxkzh;
    }

    public void setYsxkzh(String ysxkzh) {
        this.ysxkzh = ysxkzh;
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("FwLjzDO{");
        sb.append("fwDcbIndex='").append(fwDcbIndex).append('\'');
        sb.append(", fwXmxxIndex='").append(fwXmxxIndex).append('\'');
        sb.append(", ysdm='").append(ysdm).append('\'');
        sb.append(", lszd='").append(lszd).append('\'');
        sb.append(", zrzh='").append(zrzh).append('\'');
        sb.append(", bdcdyh='").append(bdcdyh).append('\'');
        sb.append(", ljzh='").append(ljzh).append('\'');
        sb.append(", bdcdyfwlx='").append(bdcdyfwlx).append('\'');
        sb.append(", xmmc='").append(xmmc).append('\'');
        sb.append(", mph='").append(mph).append('\'');
        sb.append(", fwmc='").append(fwmc).append('\'');
        sb.append(", dh='").append(dh).append('\'');
        sb.append(", zldz='").append(zldz).append('\'');
        sb.append(", fwjg='").append(fwjg).append('\'');
        sb.append(", fwjg2='").append(fwjg2).append('\'');
        sb.append(", fwjg3='").append(fwjg3).append('\'');
        sb.append(", fwcs=").append(fwcs);
        sb.append(", zts=").append(zts);
        sb.append(", fwyt='").append(fwyt).append('\'');
        sb.append(", fwyt2='").append(fwyt2).append('\'');
        sb.append(", fwyt3='").append(fwyt3).append('\'');
        sb.append(", jgrq=").append(jgrq);
        sb.append(", ycjzmj=").append(ycjzmj);
        sb.append(", ycdxmj=").append(ycdxmj);
        sb.append(", ycqtmj=").append(ycqtmj);
        sb.append(", scjzmj=").append(scjzmj);
        sb.append(", scdxmj=").append(scdxmj);
        sb.append(", scqtmj=").append(scqtmj);
        sb.append(", bdczt='").append(bdczt).append('\'');
        sb.append(", jzwzt='").append(jzwzt).append('\'');
        sb.append(", gxrq=").append(gxrq);
        sb.append(", ztrq=").append(ztrq);
        sb.append(", fwzt='").append(fwzt).append('\'');
        sb.append(", bz='").append(bz).append('\'');
        sb.append(", zzdmj='").append(zzdmj).append('\'');
        sb.append(", dscs=").append(dscs);
        sb.append(", dxcs=").append(dxcs);
        sb.append(", zydmj=").append(zydmj);
        sb.append(", d='").append(d).append('\'');
        sb.append(", n='").append(n).append('\'');
        sb.append(", x='").append(x).append('\'');
        sb.append(", b='").append(b).append('\'');
        sb.append(", cb='").append(cb).append('\'');
        sb.append(", dcz='").append(dcz).append('\'');
        sb.append(", dcsj=").append(dcsj);
        sb.append(", dcyj='").append(dcyj).append('\'');
        sb.append(", cqly='").append(cqly).append('\'');
        sb.append(", fjsm='").append(fjsm).append('\'');
        sb.append(", gyqk='").append(gyqk).append('\'');
        sb.append(", slbh='").append(slbh).append('\'');
        sb.append(", ysxkzh='").append(ysxkzh).append('\'');
        sb.append(", ghxkzh='").append(ghxkzh).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public String getGhxkzh() {
        return ghxkzh;
    }

    public void setGhxkzh(String ghxkzh) {
        this.ghxkzh = ghxkzh;
    }
}
