package cn.gtmap.realestate.common.core.domain.accept;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * @author <a href="mailto:zhangguangguang@gtmap.cn">zhangguangguang</a>
 * @version 1.0, 2019/1/3
 * @description 不动产受理收费项目配置
 */
@Table(name = "BDC_SL_SFXM_PZ")
@ApiModel(value = "BdcSlSfxmPzDO", description = "不动产受理收费项目配置")
public class BdcSlSfxmPzDO implements Serializable {
    private static final long serialVersionUID = 2354264112275704925L;
    @Id
    @ApiModelProperty(value = "收费项目配置ID")
    private String sfxmpzid;

    @ApiModelProperty(value = "登记小类")
    private String djxl;

    @ApiModelProperty(value = "收费项目代码")
    private String sfxmdm;

    @ApiModelProperty(value = "序号")
    private Integer xh;

    @ApiModelProperty(value = "数量")
    private Integer sl;

    @ApiModelProperty(value = "金额单位")
    private String jedw;

    @ApiModelProperty(value = "收费项目标准")
    private String sfxmbz;

    @ApiModelProperty(value = "权利人类别")
    private String qlrlb;

    @ApiModelProperty(value = "应收金额")
    private Double ysje;

    @ApiModelProperty(value = "收费项目名称")
    private String sfxmmc;

    @ApiModelProperty(value = "计算方法")
    private String jsff;

    public String getSfxmpzid() {
        return sfxmpzid;
    }

    public void setSfxmpzid(String sfxmpzid) {
        this.sfxmpzid = sfxmpzid;
    }

    public String getDjxl() {
        return djxl;
    }

    public void setDjxl(String djxl) {
        this.djxl = djxl;
    }

    public String getSfxmdm() {
        return sfxmdm;
    }

    public void setSfxmdm(String sfxmdm) {
        this.sfxmdm = sfxmdm;
    }

    public Integer getXh() {
        return xh;
    }

    public void setXh(Integer xh) {
        this.xh = xh;
    }

    public Integer getSl() {
        return sl;
    }

    public void setSl(Integer sl) {
        this.sl = sl;
    }

    public String getJedw() {
        return jedw;
    }

    public void setJedw(String jedw) {
        this.jedw = jedw;
    }

    public String getSfxmbz() {
        return sfxmbz;
    }

    public void setSfxmbz(String sfxmbz) {
        this.sfxmbz = sfxmbz;
    }

    public String getQlrlb() {
        return qlrlb;
    }

    public void setQlrlb(String qlrlb) {
        this.qlrlb = qlrlb;
    }

    public Double getYsje() {
        return ysje;
    }

    public void setYsje(Double ysje) {
        this.ysje = ysje;
    }

    public String getSfxmmc() {
        return sfxmmc;
    }

    public void setSfxmmc(String sfxmmc) {
        this.sfxmmc = sfxmmc;
    }

    public String getJsff() {
        return jsff;
    }

    public void setJsff(String jsff) {
        this.jsff = jsff;
    }

    @Override
    public String toString() {
        return "BdcSlSfxmPzDO{" +
                "sfxmpzid='" + sfxmpzid + '\'' +
                ", djxl='" + djxl + '\'' +
                ", sfxmdm='" + sfxmdm + '\'' +
                ", xh=" + xh +
                ", sl=" + sl +
                ", jedw='" + jedw + '\'' +
                ", sfxmbz='" + sfxmbz + '\'' +
                ", qlrlb='" + qlrlb + '\'' +
                ", ysje=" + ysje +
                ", sfxmmc='" + sfxmmc + '\'' +
                ", jsff='" + jsff + '\'' +
                '}';
    }
}
