package cn.gtmap.realestate.common.core.domain.accept;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.Date;

/**
 * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
 * @version 1.0, 2018/11/5
 * @description 不动产受理基本信息
 */
@Table(name = "BDC_SL_JBXX")
@ApiModel(value = "BdcSlJbxxDO", description = "不动产受理基本信息")
public class BdcSlJbxxDO implements Serializable {
    private static final long serialVersionUID = 4514269513303262817L;
    @Id
    @ApiModelProperty(value = "基本信息ID")
    private String jbxxid;
    @ApiModelProperty(value = "受理编号")
    private String slbh;
    @ApiModelProperty(value = "工作流实例ID")
    private String gzlslid;
    @ApiModelProperty(value = "工作流定义ID")
    private String gzldyid;
    @ApiModelProperty(value = "区县代码")
    private String qxdm;
    @ApiModelProperty(value = "登记机构")
    private String djjg;
    @ApiModelProperty(value = "受理时间",example = "2018-10-01 12:18:48")
    private Date slsj;
    @ApiModelProperty(value = "受理人ID")
    private String slrid;
    @ApiModelProperty(value = "受理人")
    private String slr;
    @ApiModelProperty(value = "申请人姓名")
    private String sqrxm;
    @ApiModelProperty(value = "申请人电话")
    private String sqrdh;
    @ApiModelProperty(value = "是否邮寄证书")
    private Integer sfyjzs;
    @ApiModelProperty(value = "是否申报材料快递")
    private Integer sfsbclkd;
    @ApiModelProperty(value = "快递地址")
    private String kddz;
    @ApiModelProperty(value = "承诺期限")
    private Integer cnqx;
    @ApiModelProperty(value = "项目来源")
    private Integer xmly;
    @ApiModelProperty(value = "所属乡镇")
    private String ssxz;
    @ApiModelProperty(value = "登记原因")
    private String djyy;
    @ApiModelProperty(value = "备注")
    private String bz;
    @ApiModelProperty(value = "坐落")
    private String zl;
    @ApiModelProperty(value = "流程名称")
    private String lcmc;
    @ApiModelProperty(value = "申请证书版式")
    private String sqzsbs;
    @ApiModelProperty(value = "案件状态(非登记流程)")
    private Integer ajzt;
    @ApiModelProperty(value = "业务受理状态,当前为一窗流程时对应的登记流程案件状态")
    private Integer ywslzt;


    public String getJbxxid() {
        return jbxxid;
    }

    public void setJbxxid(String jbxxid) {
        this.jbxxid = jbxxid;
    }

    public String getSlbh() {
        return slbh;
    }

    public void setSlbh(String slbh) {
        this.slbh = slbh;
    }

    public String getGzlslid() {
        return gzlslid;
    }

    public void setGzlslid(String gzlslid) {
        this.gzlslid = gzlslid;
    }

    public String getGzldyid() {
        return gzldyid;
    }

    public void setGzldyid(String gzldyid) {
        this.gzldyid = gzldyid;
    }

    public String getQxdm() {
        return qxdm;
    }

    public void setQxdm(String qxdm) {
        this.qxdm = qxdm;
    }

    public String getDjjg() {
        return djjg;
    }

    public void setDjjg(String djjg) {
        this.djjg = djjg;
    }

    public Date getSlsj() {
        return slsj;
    }

    public void setSlsj(Date slsj) {
        this.slsj = slsj;
    }

    public String getSlrid() {
        return slrid;
    }

    public void setSlrid(String slrid) {
        this.slrid = slrid;
    }

    public String getSlr() {
        return slr;
    }

    public void setSlr(String slr) {
        this.slr = slr;
    }

    public String getSqrxm() {
        return sqrxm;
    }

    public void setSqrxm(String sqrxm) {
        this.sqrxm = sqrxm;
    }

    public String getSqrdh() {
        return sqrdh;
    }

    public void setSqrdh(String sqrdh) {
        this.sqrdh = sqrdh;
    }

    public Integer getSfyjzs() {
        return sfyjzs;
    }

    public void setSfyjzs(Integer sfyjzs) {
        this.sfyjzs = sfyjzs;
    }

    public Integer getSfsbclkd() {
        return sfsbclkd;
    }

    public void setSfsbclkd(Integer sfsbclkd) {
        this.sfsbclkd = sfsbclkd;
    }

    public String getKddz() {
        return kddz;
    }

    public void setKddz(String kddz) {
        this.kddz = kddz;
    }

    public Integer getCnqx() {
        return cnqx;
    }

    public void setCnqx(Integer cnqx) {
        this.cnqx = cnqx;
    }

    public Integer getXmly() {
        return xmly;
    }

    public void setXmly(Integer xmly) {
        this.xmly = xmly;
    }

    public String getSsxz() {
        return ssxz;
    }

    public void setSsxz(String ssxz) {
        this.ssxz = ssxz;
    }

    public String getDjyy() {
        return djyy;
    }

    public void setDjyy(String djyy) {
        this.djyy = djyy;
    }

    public String getBz() {
        return bz;
    }

    public void setBz(String bz) {
        this.bz = bz;
    }

    public String getZl() {
        return zl;
    }

    public void setZl(String zl) {
        this.zl = zl;
    }

    public String getLcmc() {
        return lcmc;
    }

    public void setLcmc(String lcmc) {
        this.lcmc = lcmc;
    }

    public String getSqzsbs() {
        return sqzsbs;
    }

    public void setSqzsbs(String sqzsbs) {
        this.sqzsbs = sqzsbs;
    }

    public Integer getAjzt() {
        return ajzt;
    }

    public void setAjzt(Integer ajzt) {
        this.ajzt = ajzt;
    }

    public Integer getYwslzt() {
        return ywslzt;
    }

    public void setYwslzt(Integer ywslzt) {
        this.ywslzt = ywslzt;
    }

    @Override
    public String toString() {
        return "BdcSlJbxxDO{" +
                "jbxxid='" + jbxxid + '\'' +
                ", slbh='" + slbh + '\'' +
                ", gzlslid='" + gzlslid + '\'' +
                ", gzldyid='" + gzldyid + '\'' +
                ", qxdm='" + qxdm + '\'' +
                ", djjg='" + djjg + '\'' +
                ", slsj=" + slsj +
                ", slrid='" + slrid + '\'' +
                ", slr='" + slr + '\'' +
                ", sqrxm='" + sqrxm + '\'' +
                ", sqrdh='" + sqrdh + '\'' +
                ", sfyjzs=" + sfyjzs +
                ", sfsbclkd=" + sfsbclkd +
                ", kddz='" + kddz + '\'' +
                ", cnqx=" + cnqx +
                ", xmly=" + xmly +
                ", ssxz='" + ssxz + '\'' +
                ", djyy='" + djyy + '\'' +
                ", bz='" + bz + '\'' +
                ", zl='" + zl + '\'' +
                ", lcmc='" + lcmc + '\'' +
                ", sqzsbs='" + sqzsbs + '\'' +
                ", ajzt=" + ajzt +
                ", ywslzt=" + ywslzt +
                '}';
    }
}
