package cn.gtmap.realestate.common.core.domain.accept;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Id;
import javax.persistence.Table;

/**
 * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
 * @version 1.0, 2019/6/11
 * @description 不动产受理核税信息
 */
@Table(name = "BDC_SL_HSXX")
@ApiModel(value = "BdcSlHsxxDO", description = "不动产受理核税信息")
public class BdcSlHsxxDO {

    @Id
    @ApiModelProperty(value = "核税信息ID")
    private String hsxxid;

    @ApiModelProperty(value = "项目ID")
    private String xmid;

    @ApiModelProperty(value = "核定计税价格")
    private Double hdjsjg;

    @ApiModelProperty(value = "完税状态")
    private Integer wszt;

    @ApiModelProperty(value = "应纳税额合计")
    private Double ynsehj;

    @ApiModelProperty(value = "减免税额合计")
    private Double jmsehj;

    @ApiModelProperty(value = "实际应征合计")
    private Double sjyzhj;

    @ApiModelProperty(value = "申请人类别")
    private String sqrlb;

    @ApiModelProperty(value = "税务机关代码")
    private String swjgdm;

    @ApiModelProperty(value = "纳税人识别号")
    private String nsrsbh;

    @ApiModelProperty(value = "税票号码")
    private String sphm;

    @ApiModelProperty(value = "发票号码")
    private String fphm;

    @ApiModelProperty(value = "发票代码")
    private String fpdm;

    @ApiModelProperty(value = "银行缴库入库状态")
    private Integer yhjkrkzt;

    @ApiModelProperty(value = "已推送税务状态，0：否，1：是")
    private Integer ytsswzt;

    @ApiModelProperty(value = "交易凭证号")
    private String jypzh;

    public String getHsxxid() {
        return hsxxid;
    }

    public void setHsxxid(String hsxxid) {
        this.hsxxid = hsxxid;
    }

    public String getXmid() {
        return xmid;
    }

    public void setXmid(String xmid) {
        this.xmid = xmid;
    }

    public Double getHdjsjg() {
        return hdjsjg;
    }

    public void setHdjsjg(Double hdjsjg) {
        this.hdjsjg = hdjsjg;
    }

    public Integer getWszt() {
        return wszt;
    }

    public void setWszt(Integer wszt) {
        this.wszt = wszt;
    }

    public Double getYnsehj() {
        return ynsehj;
    }

    public void setYnsehj(Double ynsehj) {
        this.ynsehj = ynsehj;
    }

    public Double getJmsehj() {
        return jmsehj;
    }

    public void setJmsehj(Double jmsehj) {
        this.jmsehj = jmsehj;
    }

    public Double getSjyzhj() {
        return sjyzhj;
    }

    public void setSjyzhj(Double sjyzhj) {
        this.sjyzhj = sjyzhj;
    }

    public String getSqrlb() {
        return sqrlb;
    }

    public void setSqrlb(String sqrlb) {
        this.sqrlb = sqrlb;
    }

    public String getSwjgdm() {
        return swjgdm;
    }

    public void setSwjgdm(String swjgdm) {
        this.swjgdm = swjgdm;
    }

    public String getNsrsbh() {
        return nsrsbh;
    }

    public void setNsrsbh(String nsrsbh) {
        this.nsrsbh = nsrsbh;
    }

    public String getSphm() {
        return sphm;
    }

    public void setSphm(String sphm) {
        this.sphm = sphm;
    }

    public String getFphm() {
        return fphm;
    }

    public void setFphm(String fphm) {
        this.fphm = fphm;
    }

    public String getFpdm() {
        return fpdm;
    }

    public void setFpdm(String fpdm) {
        this.fpdm = fpdm;
    }

    public Integer getYhjkrkzt() {
        return yhjkrkzt;
    }

    public void setYhjkrkzt(Integer yhjkrkzt) {
        this.yhjkrkzt = yhjkrkzt;
    }

    public Integer getYtsswzt() {
        return ytsswzt;
    }

    public void setYtsswzt(Integer ytsswzt) {
        this.ytsswzt = ytsswzt;
    }

    public String getJypzh() {
        return jypzh;
    }

    public void setJypzh(String jypzh) {
        this.jypzh = jypzh;
    }

    @Override
    public String toString() {
        return "BdcSlHsxxDO{" +
                "hsxxid='" + hsxxid + '\'' +
                ", xmid='" + xmid + '\'' +
                ", hdjsjg=" + hdjsjg +
                ", wszt=" + wszt +
                ", ynsehj=" + ynsehj +
                ", jmsehj=" + jmsehj +
                ", sjyzhj=" + sjyzhj +
                ", sqrlb='" + sqrlb + '\'' +
                ", swjgdm='" + swjgdm + '\'' +
                ", nsrsbh='" + nsrsbh + '\'' +
                ", sphm='" + sphm + '\'' +
                ", fphm='" + fphm + '\'' +
                ", fpdm='" + fpdm + '\'' +
                ", yhjkrkzt=" + yhjkrkzt +
                ", ytsswzt=" + ytsswzt +
                ", jypzh='" + jypzh + '\'' +
                '}';
    }
}
