package cn.gtmap.realestate.common.core.domain;

import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Id;
import javax.persistence.Table;
import java.util.Date;

/**
 * 交接单
 *
 * @author <a href="mailto:lixin1@gtmap.cn">lixin</a>
 * @version 1.0, 2019/08/23
 */
@Table(name = "BDC_JJD")
public class BdcJjdDO {
    /**
     * 交接单 ID
     */
    @Id
    @ApiModelProperty(value = "交接单ID")
    private String jjdid;

    /**
     * 交接单号
     */
    @ApiModelProperty(value = "交接单号")
    private String jjdh;

    /**
     * 交接单类型
     */
    @ApiModelProperty(value = "交接单类型")
    private Integer jjdlx;

    /**
     * 交接单状态
     */
    @ApiModelProperty(value = "交接单状态")
    private Integer jjdzt;

    /**
     * 转发人ID
     */
    @ApiModelProperty(value = "转发人ID")
    private String zfrid;

    /**
     * 转发人
     */
    @ApiModelProperty(value = "转发人")
    private String zfr;

    /**
     * 转发时间
     */
    @ApiModelProperty(value = "转发时间")
    private Date zfsj;

    /**
     * 转发科室
     */
    @ApiModelProperty(value = "转发科室")
    private String zfks;

    /**
     * 接收人ID
     */
    @ApiModelProperty(value = "接收人ID")
    private String jsrid;

    /**
     * 接收人
     */
    @ApiModelProperty(value = "接收人")
    private String jsr;

    /**
     * 接收时间
     */
    @ApiModelProperty(value = "接收时间")
    private Date jssj;

    /**
     * 接收科室
     */
    @ApiModelProperty(value = "接收科室")
    private String jsks;

    /**
     * 档案号
     */
    @ApiModelProperty(value = "档案号")
    private String dah;

    /**
     * 状态（是否转发给全部，是：1，否：0）
     */
    @ApiModelProperty(value = "状态")
    private Integer zt;

    /**
     * 归档状态
     */
    @ApiModelProperty(value = "归档状态")
    private Integer gdzt;

    public String getJjdid() {
        return jjdid;
    }

    public void setJjdid(String jjdid) {
        this.jjdid = jjdid;
    }

    public String getJjdh() {
        return jjdh;
    }

    public void setJjdh(String jjdh) {
        this.jjdh = jjdh;
    }

    public Integer getJjdlx() {
        return jjdlx;
    }

    public void setJjdlx(Integer jjdlx) {
        this.jjdlx = jjdlx;
    }

    public Integer getJjdzt() {
        return jjdzt;
    }

    public void setJjdzt(Integer jjdzt) {
        this.jjdzt = jjdzt;
    }

    public String getZfrid() {
        return zfrid;
    }

    public void setZfrid(String zfrid) {
        this.zfrid = zfrid;
    }

    public String getZfr() {
        return zfr;
    }

    public void setZfr(String zfr) {
        this.zfr = zfr;
    }

    public Date getZfsj() {
        return zfsj;
    }

    public void setZfsj(Date zfsj) {
        this.zfsj = zfsj;
    }

    public String getZfks() {
        return zfks;
    }

    public void setZfks(String zfks) {
        this.zfks = zfks;
    }

    public String getJsrid() {
        return jsrid;
    }

    public void setJsrid(String jsrid) {
        this.jsrid = jsrid;
    }

    public String getJsr() {
        return jsr;
    }

    public void setJsr(String jsr) {
        this.jsr = jsr;
    }

    public Date getJssj() {
        return jssj;
    }

    public void setJssj(Date jssj) {
        this.jssj = jssj;
    }

    public String getJsks() {
        return jsks;
    }

    public void setJsks(String jsks) {
        this.jsks = jsks;
    }

    public Integer getGdzt() {
        return gdzt;
    }

    public void setGdzt(Integer gdzt) {
        this.gdzt = gdzt;
    }

    public String getDah() {
        return dah;
    }

    public void setDah(String dah) {
        this.dah = dah;
    }

    public Integer getZt() {
        return zt;
    }

    public void setZt(Integer zt) {
        this.zt = zt;
    }

    @Override
    public String toString() {
        return "BdcJjdDO{" +
                "jjdid='" + jjdid + '\'' +
                ", jjdh='" + jjdh + '\'' +
                ", jjdlx=" + jjdlx +
                ", jjdzt=" + jjdzt +
                ", zt=" + zt +
                ", zfrid='" + zfrid + '\'' +
                ", zfr='" + zfr + '\'' +
                ", zfsj=" + zfsj +
                ", zfks='" + zfks + '\'' +
                ", jsrid='" + jsrid + '\'' +
                ", jsr='" + jsr + '\'' +
                ", jssj=" + jssj +
                ", jsks='" + jsks + '\'' +
                ", gdzt=" + gdzt +
                ", dah=" + dah +
                '}';
    }
}
