package cn.gtmap.realestate.common.core.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Id;
import javax.persistence.Table;
import java.util.Date;
 /**
  * @author <a href="mailto:songjiawei@gtmap.cn">songjiawei</a>
  * @description 建筑物区分所有权业主共有部分登记信息_共有部分
  */
@Table(
        name = "BDC_FDCQ3_GYXX"
)
@ApiModel(value = "BdcFdcq3GyxxDO", description = "不动产建筑物区分所有权业主共有部分登记信息_共有部分信息")
public class BdcFdcq3GyxxDO {
    @Id
    @ApiModelProperty(value = "共用信息id")
    private String gyxxid;
     @ApiModelProperty(value = "权利id")
    private String qlid;
     @ApiModelProperty(value = "受理编号")
    private String slbh;
     @ApiModelProperty(value = "地籍号")
     private String djh;
     @ApiModelProperty(value = "建（构）筑物编号")
    private String jgzwbh;
     @ApiModelProperty(value = "建（构）筑物名称")
    private String jgzwmc;
     @ApiModelProperty(value = "建（构）筑物面积")
    private Double jgzwmj;
     @ApiModelProperty(value = "分摊土地面积(m2)")
    private Double fttdmj;
     @ApiModelProperty(value = "登记机构")
    private String djjg;
     @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
     @ApiModelProperty(value = "登记时间",example = "2018-10-01 12:18:48")
     private Date djsj;
     @ApiModelProperty(value = "登簿人")
    private String dbr;
     @ApiModelProperty(value = "附记")
    private String fj;
     @ApiModelProperty(value = "建筑数量")
    private Integer jgzwsl;
     @ApiModelProperty(value = "土地使用份额")
    private String tdsyfe;
     @ApiModelProperty(value = "项目ID")
    private String xmid;

     public String getDjh() {
         return djh;
     }

     public void setDjh(String djh) {
         this.djh = djh;
     }
    public String getGyxxid() {
        return gyxxid;
    }

    public void setGyxxid(String gyxxid) {
        this.gyxxid = gyxxid;
    }

    public String getQlid() {
        return qlid;
    }

    public void setQlid(String qlid) {
        this.qlid = qlid;
    }

    public String getSlbh() {
        return slbh;
    }

    public void setSlbh(String slbh) {
        this.slbh = slbh;
    }

    public String getJgzwbh() {
        return jgzwbh;
    }

    public void setJgzwbh(String jgzwbh) {
        this.jgzwbh = jgzwbh;
    }

    public String getJgzwmc() {
        return jgzwmc;
    }

    public void setJgzwmc(String jgzwmc) {
        this.jgzwmc = jgzwmc;
    }

    public Double getJgzwmj() {
        return jgzwmj;
    }

    public void setJgzwmj(Double jgzwmj) {
        this.jgzwmj = jgzwmj;
    }

    public Double getFttdmj() {
        return fttdmj;
    }

    public void setFttdmj(Double fttdmj) {
        this.fttdmj = fttdmj;
    }

    public String getDjjg() {
        return djjg;
    }

    public void setDjjg(String djjg) {
        this.djjg = djjg;
    }

    public Date getDjsj() {
        return djsj;
    }

    public void setDjsj(Date djsj) {
        this.djsj = djsj;
    }

    public String getDbr() {
        return dbr;
    }

    public void setDbr(String dbr) {
        this.dbr = dbr;
    }

    public String getFj() {
        return fj;
    }

    public void setFj(String fj) {
        this.fj = fj;
    }

     public Integer getJgzwsl() {
         return jgzwsl;
     }

     public void setJgzwsl(Integer jgzwsl) {
         this.jgzwsl = jgzwsl;
     }

     public String getTdsyfe() {
        return tdsyfe;
    }

    public void setTdsyfe(String tdsyfe) {
        this.tdsyfe = tdsyfe;
    }

    public String getXmid() {
        return xmid;
    }

    public void setXmid(String xmid) {
        this.xmid = xmid;
    }

     @Override
     public String toString() {
         return "BdcFdcq3GyxxDO{" +
                 "gyxxid='" + gyxxid + '\'' +
                 ", qlid='" + qlid + '\'' +
                 ", slbh='" + slbh + '\'' +
                 ", djh='" + djh + '\'' +
                 ", jgzwbh='" + jgzwbh + '\'' +
                 ", jgzwmc='" + jgzwmc + '\'' +
                 ", jgzwmj=" + jgzwmj +
                 ", fttdmj=" + fttdmj +
                 ", djjg='" + djjg + '\'' +
                 ", djsj=" + djsj +
                 ", dbr='" + dbr + '\'' +
                 ", fj='" + fj + '\'' +
                 ", jgzwsl=" + jgzwsl +
                 ", tdsyfe='" + tdsyfe + '\'' +
                 ", xmid='" + xmid + '\'' +
                 '}';
     }
 }
