package cn.gtmap.realestate.common.core.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Id;
import javax.persistence.Table;
import java.util.Date;

/**
 * @author <a href ="mailto:songhaowen@gtmap.cn">songhaowen</a>
 * @version 1.3, 2018/10/31
 * @description 宗海基本信息
 */
@Table(
        name = "BDC_BDCDJB_ZHJBXX"
)
@ApiModel(value = "BdcBdcdjbZhjbxxDO", description = "登记簿宗海基本信息")
public class BdcBdcdjbZhjbxxDO {
    @Id
    /**宗海代码*/
    @ApiModelProperty(value = "宗海代码")
    private String zhdm;
    /**不动产单元号*/
    @ApiModelProperty(value = "不动产单元号")
    private String bdcdyh;
    /** 宗海特征码*/
    @ApiModelProperty(value = "宗海特征码")
    private String zhtzm;
    /** 项目名称*/
    @ApiModelProperty(value = "项目名称")
    private String xmmc;
    /** 项目性质*/
    @ApiModelProperty(value = "项目性质")
    private Integer xmxz;
    /** 用海总面积*/
    @ApiModelProperty(value = "用海总面积")
    private Double yhzmj;
    /** 宗海面积*/
    @ApiModelProperty(value = "宗海面积")
    private Double zhmj;
    /** 等别*/
    @ApiModelProperty(value = "等别")
    private Integer db;
    /** 占海岸线*/
    @ApiModelProperty(value = "占海岸线")
    private Double zhax;
    /** 用海类型A*/
    @ApiModelProperty(value = "用海类型A")
    private Integer yhlxa;
    /** 用海类型B*/
    @ApiModelProperty(value = "用海类型B")
    private Integer yhlxb;
    /** 用海位置说明*/
    @ApiModelProperty(value = "用海位置说明")
    private String yhwzsm;
    /** 海岛名称*/
    @ApiModelProperty(value = "海岛名称")
    private String hdmc;
    /** 海岛代码*/
    @ApiModelProperty(value = "海岛代码")
    private String hddm;
    /** 用岛范围*/
    @ApiModelProperty(value = "海岛范围")
    private String ydfw;
    /** 用岛面积*/
    @ApiModelProperty(value = "用岛面积")
    private Double ydmj;
    /** 海岛位置*/
    @ApiModelProperty(value = "海岛位置")
    private String hdwz;
    /** 海岛用途*/
    @ApiModelProperty(value = "海岛用途")
    private Integer hdyt;
    /** 登记时间*/
    @ApiModelProperty(value = "登记时间",example = "2018-10-01 12:18:48")
    private Date djsj;
    /** 登簿人*/
    @ApiModelProperty(value = "登簿人")
    private String dbr;
    /** 附记*/
    @ApiModelProperty(value = "附记")
    private String fj;
    /** 不动产类型*/
    @ApiModelProperty(value = "不动产类型")
    private Integer bdclx;
    /**
     * 权利性质
     */
    @ApiModelProperty(value = "权利性质")
    private Integer qlxz;
    /**
     * 构筑物类型
     */
    @ApiModelProperty(value = "构筑物类型")
    private Integer gzwlx;
    /**
     * 使用金标准依据
     */
    @ApiModelProperty(value = "使用金标准依据")
    private String syjbzyj;
    /**
     * 使用金总额
     */
    @ApiModelProperty(value = "使用金总额")
    private Double syjze;

    /**
     * 使用金缴纳情况
     */
    @ApiModelProperty(value = "使用金缴纳情况")
    private String syjjnqk;
    /**
     * 起始日期
     */
    @ApiModelProperty(value = "起始日期",example = "2018-10-01 12:18:21")
    private Date qsrq;

    /**
     * 终止日期
     */
    @ApiModelProperty(value = "终止日期",example = "2018-10-01 12:18:21")
    private Date zzrq;

    public String getZhdm() {
        return zhdm;
    }

    public void setZhdm(String zhdm) {
        this.zhdm = zhdm;
    }

    public String getBdcdyh() {
        return bdcdyh;
    }

    public void setBdcdyh(String bdcdyh) {
        this.bdcdyh = bdcdyh;
    }

    public String getZhtzm() {
        return zhtzm;
    }

    public void setZhtzm(String zhtzm) {
        this.zhtzm = zhtzm;
    }

    public String getXmmc() {
        return xmmc;
    }

    public void setXmmc(String xmmc) {
        this.xmmc = xmmc;
    }

    public Integer getXmxz() {
        return xmxz;
    }

    public void setXmxz(Integer xmxz) {
        this.xmxz = xmxz;
    }

    public Double getYhzmj() {
        return yhzmj;
    }

    public void setYhzmj(Double yhzmj) {
        this.yhzmj = yhzmj;
    }

    public Double getZhmj() {
        return zhmj;
    }

    public void setZhmj(Double zhmj) {
        this.zhmj = zhmj;
    }

    public Integer getDb() {
        return db;
    }

    public void setDb(Integer db) {
        this.db = db;
    }

    public Double getZhax() {
        return zhax;
    }

    public void setZhax(Double zhax) {
        this.zhax = zhax;
    }

    public Integer getYhlxa() {
        return yhlxa;
    }

    public void setYhlxa(Integer yhlxa) {
        this.yhlxa = yhlxa;
    }

    public Integer getYhlxb() {
        return yhlxb;
    }

    public void setYhlxb(Integer yhlxb) {
        this.yhlxb = yhlxb;
    }

    public String getYhwzsm() {
        return yhwzsm;
    }

    public void setYhwzsm(String yhwzsm) {
        this.yhwzsm = yhwzsm;
    }

    public String getHdmc() {
        return hdmc;
    }

    public void setHdmc(String hdmc) {
        this.hdmc = hdmc;
    }

    public String getHddm() {
        return hddm;
    }

    public void setHddm(String hddm) {
        this.hddm = hddm;
    }

    public String getYdfw() {
        return ydfw;
    }

    public void setYdfw(String ydfw) {
        this.ydfw = ydfw;
    }

    public Double getYdmj() {
        return ydmj;
    }

    public void setYdmj(Double ydmj) {
        this.ydmj = ydmj;
    }

    public String getHdwz() {
        return hdwz;
    }

    public void setHdwz(String hdwz) {
        this.hdwz = hdwz;
    }

    public Integer getHdyt() {
        return hdyt;
    }

    public void setHdyt(Integer hdyt) {
        this.hdyt = hdyt;
    }

    public Date getDjsj() {
        return djsj;
    }

    public void setDjsj(Date djsj) {
        this.djsj = djsj;
    }

    public String getDbr() {
        return dbr;
    }

    public void setDbr(String dbr) {
        this.dbr = dbr;
    }

    public String getFj() {
        return fj;
    }

    public void setFj(String fj) {
        this.fj = fj;
    }

    public Integer getBdclx() {
        return bdclx;
    }

    public void setBdclx(Integer bdclx) {
        this.bdclx = bdclx;
    }

    public Integer getQlxz() {
        return qlxz;
    }

    public void setQlxz(Integer qlxz) {
        this.qlxz = qlxz;
    }

    public Integer getGzwlx() {
        return gzwlx;
    }

    public void setGzwlx(Integer gzwlx) {
        this.gzwlx = gzwlx;
    }

    public String getSyjbzyj() {
        return syjbzyj;
    }

    public void setSyjbzyj(String syjbzyj) {
        this.syjbzyj = syjbzyj;
    }

    public Double getSyjze() {
        return syjze;
    }

    public void setSyjze(Double syjze) {
        this.syjze = syjze;
    }

    public String getSyjjnqk() {
        return syjjnqk;
    }

    public void setSyjjnqk(String syjjnqk) {
        this.syjjnqk = syjjnqk;
    }

    public Date getQsrq() {
        return qsrq;
    }

    public void setQsrq(Date qsrq) {
        this.qsrq = qsrq;
    }

    public Date getZzrq() {
        return zzrq;
    }

    public void setZzrq(Date zzrq) {
        this.zzrq = zzrq;
    }

    @Override
    public String toString() {
        return "BdcBdcdjbZhjbxxDO{" +
                "zhdm='" + zhdm + '\'' +
                ", bdcdyh='" + bdcdyh + '\'' +
                ", zhtzm='" + zhtzm + '\'' +
                ", xmmc='" + xmmc + '\'' +
                ", xmxz=" + xmxz +
                ", yhzmj=" + yhzmj +
                ", zhmj=" + zhmj +
                ", db=" + db +
                ", zhax=" + zhax +
                ", yhlxa=" + yhlxa +
                ", yhlxb=" + yhlxb +
                ", yhwzsm='" + yhwzsm + '\'' +
                ", hdmc='" + hdmc + '\'' +
                ", hddm='" + hddm + '\'' +
                ", ydfw='" + ydfw + '\'' +
                ", ydmj=" + ydmj +
                ", hdwz='" + hdwz + '\'' +
                ", hdyt=" + hdyt +
                ", djsj=" + djsj +
                ", dbr='" + dbr + '\'' +
                ", fj='" + fj + '\'' +
                ", bdclx=" + bdclx +
                ", qlxz=" + qlxz +
                ", gzwlx=" + gzwlx +
                ", syjbzyj='" + syjbzyj + '\'' +
                ", syjze=" + syjze +
                ", syjjnqk='" + syjjnqk + '\'' +
                ", qsrq=" + qsrq +
                ", zzrq=" + zzrq +
                '}';
    }
}
