package cn.gtmap.realestate.common.config.mq.Config;

import cn.gtmap.realestate.common.config.mq.enums.RabbitMqEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @author <a href="mailto:wangzijie@gtmap.cn">wangzijie</a>
 * @version 1.0.2019/07/17
 * @description 定义队列（exchange）默认为持久化队列
 */
@Configuration
@AutoConfigureAfter(MQConfig.class)
public class MQQueueConfig {
    private static final Logger logger = LoggerFactory.getLogger(MQQueueConfig.class);

    @Autowired
    RabbitAdmin rabbitAdmin;


    @Bean
    Queue queueSynBdczt(){
        Queue queue = new Queue(RabbitMqEnum.QueueName.BDCDYZTQUEUE.getCode());
        rabbitAdmin.declareQueue(queue);
        logger.debug("不动产单元状态队列实例化完成");
        return queue;
    }

    @Bean
    Queue queueSynBdcsdzt(){
        Queue queue = new Queue(RabbitMqEnum.QueueName.BDCDYSDZTQUEUE.getCode());
        rabbitAdmin.declareQueue(queue);
        logger.debug("不动产单元锁定状态队列实例化完成");
        return queue;
    }

    @Bean
    Queue queueSynBdcxx(){
        Queue queue = new Queue(RabbitMqEnum.QueueName.BDCDYXXQUEUE.getCode());
        rabbitAdmin.declareQueue(queue);
        logger.debug("不动产单元信息队列实例化完成");
        return queue;
    }

    @Bean
    Queue queuePpSynBdczt(){
        Queue queue = new Queue(RabbitMqEnum.QueueName.SYNCBDCDYZTQUEUE.getCode());
        rabbitAdmin.declareQueue(queue);
        logger.debug("匹配不动产单元同步状态队列实例化完成");
        return queue;
    }
}
