package cn.gtmap.realestate.common.config.logaop;

import cn.gtmap.gtc.sso.domain.dto.UserDto;
import cn.gtmap.gtc.starter.gscas.audit.ZipkinAuditEventRepository;
import cn.gtmap.realestate.common.core.annotations.LogNote;
import cn.gtmap.realestate.common.core.enums.LogKeyEnum;
import cn.gtmap.realestate.common.util.CommonConstantUtils;
import cn.gtmap.realestate.common.util.UserManagerUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.audit.AuditEvent;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

/**
 * @author <a href="mailto:yaoyi@gtmap.cn">yaoyi</a>
 * @version 1.0, 2019/9/25.
 * @description 自定义日志收集切面，对使用@LogNote注解的方法进行日志采集。value:功能描述，action:大云事件
 */
@Component
@Aspect
public class LogNoteAspect {

    private static final Logger LOGGER = LoggerFactory.getLogger(LogNoteAspect.class);

    @Autowired
    private ZipkinAuditEventRepository zipkinAuditEventRepository;

    @Autowired
    private UserManagerUtils userManagerUtils;

    @Pointcut(value = "@annotation(logNote)")
    public void pointCut(LogNote logNote){
    }

    @Before(value = "pointCut(logNote)")
    public void doBeforeLog(JoinPoint point, LogNote logNote){
        // 包装AuditEvent需要的动作数据
        Map<String, Object> data = new HashMap<String, Object>(3);
        data.put(LogKeyEnum.VIEW_TYPE_NAME.getKey(), logNote.value());
        //获取当前方法中的参数名和参数值
        final Object[] args = point.getArgs();
        final String[] argsName = ((MethodSignature)point.getSignature()).getParameterNames();
        data.put("ARGS", JSON.toJSONString(point.getArgs()));
        String logType = StringUtils.isEmpty(logNote.action())? "OTHER" : logNote.action();

        String userName = userManagerUtils.getCurrentUserName();
        UserDto userDto = userManagerUtils.getUserByName(userName);
        if (userDto != null) {
            data.put(CommonConstantUtils.ALIAS, userDto.getAlias());
        }

        try{
            zipkinAuditEventRepository.add(new AuditEvent(userName,logType,data));
        }catch(Exception e){
            LOGGER.error(e.getMessage());
        }
    }

}
