package cn.gtmap.realestate.common.config.interceptor;

import cn.gtmap.gtc.feign.common.util.ObjectMapperUtils;
import cn.gtmap.gtc.msg.domain.dto.AnonymousContentDto;
import cn.gtmap.gtc.msg.domain.dto.ProduceMsgDto;
import cn.gtmap.gtc.msg.domain.enums.ConsumerType;
import cn.gtmap.gtc.msg.domain.enums.MsgReadFlag;
import cn.gtmap.gtc.msg.domain.enums.OperationType;
import cn.gtmap.gtc.msg.domain.enums.ProducerType;
import cn.gtmap.gtc.msg.rabbitmq.produce.MessageProducer;
import cn.gtmap.realestate.common.core.domain.BdcMsgConfig;
import cn.gtmap.realestate.common.core.domain.BdcMsgLog;
import cn.gtmap.realestate.common.core.domain.BdcMsgMain;
import cn.gtmap.realestate.common.core.service.feign.init.BdcRunSqlFeignService;
import cn.gtmap.realestate.common.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.realestate.common.core.support.mybatis.mapper.Example;
import cn.gtmap.realestate.common.util.UUIDGenerator;
import com.alibaba.fastjson.JSON;
import jodd.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Import;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.ModelAndView;

import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Component
@Import({EntityMapper.class, MessageProducer.class, BdcRunSqlFeignService.class})
public class SendMsgInterceptor implements HandlerInterceptor {

    @Value("${security.oauth2.client.client-id}")
    private String clientId;

    @Autowired
    private EntityMapper entityMapper;
    @Autowired
    private MessageProducer messageProducer;
    @Autowired
    private BdcRunSqlFeignService bdcRunSqlFeignService;

    private static final Logger logger = LoggerFactory.getLogger(SendMsgInterceptor.class);

    public static List<String> urlList;

    public static List<String> getUrlList() {
        return urlList;
    }

    // 在构造方法执行后执行
    @PostConstruct
    public void init() {
        initMap();
    }

    public void initMap() {
        Example example = new Example(BdcMsgMain.class);
        List<BdcMsgMain> configList = entityMapper.selectByExample(example);
        List<String> list = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(configList)) {
            for (BdcMsgMain main : configList) {
                list.add(main.getUrl());
            }
        }
        urlList = list;
    }

    @Override
    public boolean preHandle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o) throws Exception {
        return true;
    }

    @Override
    public void postHandle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o, ModelAndView modelAndView) throws Exception {

    }

    @Override
    public void afterCompletion(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o, Exception e) throws Exception {
        sendMsg(httpServletRequest, httpServletResponse);
    }

    /**
     * @param request
     * @author <a href="mailto:wangzijie@gtmap.cn">wangzijie</a>
     * @description 短信异步发送，根据cute 确定是功能之前发送 还是之后发送(0是在功能前发送，1是之后)
     */
    @Async
    public void sendMsg(HttpServletRequest request, HttpServletResponse response) {
        //判断当前请求的url是否需要呗拦截，需要在做操作
        PathMatcher matcher = new AntPathMatcher();
        List<String> phoneList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(urlList)) {
            for (String url : urlList) {
                if (matcher.match(url, request.getRequestURI())) {
                    logger.info("当前url被拦截，拦截为：" + url + "被拦截url为："+ request.getRequestURI());
                    if (response.getStatus() == 200) {
                        Example msgMainExample = new Example(BdcMsgMain.class);
                        msgMainExample.createCriteria().andEqualTo("url", url);
                        List<BdcMsgMain> msgMainList = entityMapper.selectByExample(msgMainExample);
                        if (CollectionUtils.isNotEmpty(msgMainList)) {
                            msgMainList.forEach(main -> {
                                // 1.获取MsgType（大云需要）
                                String msgType = getMsgType(main);
                                //2.获取数据
                                if (StringUtils.isNotBlank(main.getParamWhere()) && StringUtils.isNotBlank(main.getParamSql())) {
                                    NativeWebRequest webRequest = new ServletWebRequest(request);
                                    Map<String, String> map = (Map<String, String>) webRequest.getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE, RequestAttributes.SCOPE_REQUEST);
                                    String parmWhereSql = "";
                                    if (StringUtil.isNotBlank(MapUtils.getString(map, main.getParamWhere()))) {
                                        parmWhereSql = main.getParamSql().replace("@{" + main.getParamWhere() + "}", "'" + map.get(main.getParamWhere()) + "'");
                                    } else {
                                        parmWhereSql = main.getParamSql().replace("@{" + main.getParamWhere() + "}", "'" + request.getParameter(main.getParamWhere()) + "'");
                                    }
                                    logger.info("发送短信功能sql执行：" + parmWhereSql);
                                    List<HashMap> parmMapList = bdcRunSqlFeignService.runSql(parmWhereSql);
                                    if (CollectionUtils.isNotEmpty(parmMapList)) {
                                        parmMapList.forEach(hashMap -> {
                                            String phone = MapUtils.getString(hashMap, "dh");
                                            //3.判断参数 如果都全，发送，不全不发送
                                            if (StringUtils.isNotBlank(phone) && StringUtils.isNotBlank(msgType) && hashMap != null) {
                                                if (checkPhone(phone)) {
                                                    if (!phoneList.contains(phone)) {
                                                        smsMsg(hashMap, phone, msgType);
                                                        saveMsgLog(JSON.toJSONString(hashMap), String.valueOf(response.getStatus()), phone, "0", "发送成功");
                                                        phoneList.add(phone);
                                                    }
                                                } else {
                                                    saveMsgLog(JSON.toJSONString(hashMap), String.valueOf(response.getStatus()), phone, "1", "电话号格式不正确");
                                                }
                                            } else {
                                                saveMsgLog(JSON.toJSONString(hashMap), String.valueOf(response.getStatus()), phone, "1", "参数缺失");
                                            }
                                        });
                                    }
                                }
                            });
                        }
                    }
                }
            }
        }
    }

    /**
     * 记录日志
     *
     * @param parma     替换的参数
     * @param status    需要发送短信方法的状态值
     * @param phone     电话号
     * @param issuccess 是否发送成功
     * @param errorMsg  失败信息
     */
    private void saveMsgLog(String parma, String status, String phone, String issuccess, String errorMsg) {
        BdcMsgLog log = new BdcMsgLog();
        log.setLogid(UUIDGenerator.generate16());
        log.setIssucc(issuccess);
        log.setParam(parma);
        log.setPhone(phone);
        log.setReturncode(status);
        log.setSendtime(new Date());
        log.setException(errorMsg);
        entityMapper.insertSelective(log);
    }

    /**
     * 验证电话号码是否扶额和规范
     *
     * @param phone
     * @return
     */
    private boolean checkPhone(String phone) {
        String regex = "^((13[0-9])|(14[5,7,9])|(15([0-3]|[5-9]))|(166)|(17[0,1,3,5,6,7,8])|(18[0-9])|(19[8|9]))\\d{8}$";
        if (StringUtils.isNotBlank(phone)) {
            if (phone.length() != 11) {
                return false;
            } else {
                Pattern p = Pattern.compile(regex);
                Matcher m = p.matcher(phone);
                return m.matches();
            }
        }
        return false;
    }

    /**
     * 获取MsgType（大云需要）
     *
     * @param main
     * @return
     */
    private String getMsgType(BdcMsgMain main) {
        if (main != null && StringUtils.isNotBlank(main.getConfigid())) {
            BdcMsgConfig msgConfig = entityMapper.selectByPrimaryKey(BdcMsgConfig.class, main.getConfigid());
            if (msgConfig != null && StringUtils.isNotBlank(msgConfig.getMsgtype())) {
                return msgConfig.getMsgtype();
            }
        }
        return null;
    }


    /**
     * 短信发送（大云接口）
     *
     * @param data
     * @param phone
     * @param msgType
     */
    public void smsMsg(Map<String, String> data, String phone, String msgType) {
        ProduceMsgDto msgDto = new ProduceMsgDto();
        try {
            msgDto.setClientId(clientId).setMsgCode(System.currentTimeMillis() + "")
                    .setMsgType(msgType).setMsgTypeName("短信发送")
                    .setProducer(clientId).setProducerType(ProducerType.SYSTEM.getName())
                    .setRead(MsgReadFlag.UNREAD.getValue()).setOptions(OperationType.SMS.getName());
            msgDto.setConsumer(phone).setConsumerType(ConsumerType.ANONYMOUS.getName());
            AnonymousContentDto contentDto = new AnonymousContentDto();
            contentDto.setMobile(phone).setContent(ObjectMapperUtils.toJson(data));
            msgDto.setMsgContent(ObjectMapperUtils.toJson(contentDto));
            messageProducer.send(msgDto);
        } catch (Exception e) {
            logger.error("smsMsg", e);
        }
    }
}
