package cn.gtmap.realestate.common.util.redisson;

import org.apache.commons.collections.CollectionUtils;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author <a href="mailto:zhuyong@gtmap.cn">zhuyong</a>
 * @version 1.0, 2018/12/4
 * @description Redisson配置类
 */
@Configuration
public class RedissonConfig {

    @Resource
    private RedisProperties redisProperties;

    @Bean
    public RedissonClient getRedissonClient(){
        Config config = new Config();

        // 集群配置
        if (redisProperties.getCluster() != null && CollectionUtils.isNotEmpty(redisProperties.getCluster().getNodes())){
            List<String> nodeList = redisProperties.getCluster().getNodes();
            String[] arr = new String[nodeList.size()];
            for(int i = 0 ;i < nodeList.size();i++){
                arr[i] = "redis://"+nodeList.get(i);
            }
            config.useClusterServers().addNodeAddress(arr);
        } else {
            // 单机Redis
            config.useSingleServer().setAddress("redis://" + redisProperties.getHost() + ":" + redisProperties.getPort());
        }
        return Redisson.create(config);
    }
}
