package cn.gtmap.realestate.common.util;

import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.xfire.client.Client;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.encoding.XMLType;
import java.net.URL;
import java.rmi.RemoteException;

/**
 * @author <a href="mailto:lisongtao@gtmap.cn>lisongtao</a>"
 * @version 1.0, 2019/08/13
 * @description webservice调用工具类
 */
@Component
public class WebServiceUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebServiceUtils.class);

    /**
     *  调用webservice
     * @param url
     * @param uri
     * @param methodName
     * @param paramNameArray
     * @param paramValArray
     * @return
     */
    public static String callWebService(String url, String uri, String methodName, String[] paramNameArray, Object[] paramValArray) {
        String result = "";
        if (StringUtils.isNoneBlank(url)) {
            try {
                Service service = new Service();
                Call call = (Call) service.createCall();
                call.setTargetEndpointAddress(url);
                call.setOperationName(new javax.xml.namespace.QName(uri, methodName));
                call.setUseSOAPAction(true);
                call.setSOAPActionURI(uri + methodName);
                call.setProperty(Call.CONNECTION_TIMEOUT_PROPERTY, Integer.valueOf(20000));
                call.setTimeout(Integer.valueOf(20000));
                for (int i=0;i<paramNameArray.length;i++) {
                    QName qName=XMLType.XSD_STRING;
                    if(i<paramValArray.length){
                        if(paramValArray[i] instanceof Integer){
                            qName=XMLType.XSD_INTEGER;
                        }
                    }
                    call.addParameter(new QName(uri, paramNameArray[i]), qName, ParameterMode.IN);
                }
                // 设置返回类型
                call.setReturnType(XMLType.XSD_STRING);
                result = (String) call.invoke(paramValArray);
            } catch (RemoteException e) {
                LOGGER.error("RemoteException",e);
            } catch (ServiceException e) {
                LOGGER.error("ServiceException",e);
            }
        }
        return result;
    }

    /**
     * xfire调用webservice
     *
     * @param url
     * @param method
     * @param param
     */
    public static String callWebService(String url, String  method,Object[] param) {
        String result="";
        Object[] results = null;
        Client client = null;
        try {
            client = new Client(new URL(url));
            results = client.invoke(method, param);
        } catch (Exception e) {
            LOGGER.error("调用报错：[{}]",method,e);
        }finally {
            if(client!=null){
                client.close();
            }
        }
        if(results!=null){
            result=results[0].toString();
        }
        return result;
    }

}
