package cn.gtmap.realestate.common.util;

import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

/**
 * @author <a href="mailto:zhuyong@gtmap.cn">zhuyong</a>
 * @version 1.0, 2019/3/12
 * @description Token操作
 */
@Component
public class TokenUtils {
    /**
     * Token键定义
     */
    private static final String REDIS_RULE_TOKEN = "REDIS_RULE_TOKEN";

    /**
     * Token请求地址
     */
    private static final String TOKEN_URL = "http://account/account/oauth/token?grant_type=client_credentials" +
            "&client_id=accountUIClientID&client_secret=accountUIClientSecret";

    /**
     * 发起 REST请求
     */
    @Autowired
    private RestTemplate restTemplate;
    /**
     * Redis String类型操作
     */
    @Autowired
    private StringRedisTemplate stringRedisTemplate;


    /**
     * @author <a href="mailto:zhuyong@gtmap.cn">zhuyong</a>
     * @return {String}  token
     * @description 获取权限访问Token
     */
    public String getAccessToken(){
        // 先从Redis缓存获取
        String token = stringRedisTemplate.opsForValue().get(REDIS_RULE_TOKEN);

        // 缓存没有再单独获取
        if(StringUtils.isBlank(token)){
            String accessTokenStr =  restTemplate.postForObject(TOKEN_URL, "", String.class);
            token =  JSONObject.parseObject(accessTokenStr).getString("access_token");

            // 缓存到Redis
            stringRedisTemplate.opsForValue().set(REDIS_RULE_TOKEN, token);
        }
        return token;
    }
}
