package cn.gtmap.realestate.common.util;

import com.swetake.util.Qrcode;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletResponse;
import java.awt.*;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.URLDecoder;

/**
 * @author <a href="mailto:gaolining@gtmap.cn">gaolining</a>
 * @version 2019/4/10,1.0
 * @description 生成二维码内容
 */
@Component
public class QRcodeUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(QRcodeUtils.class);

    /**
     * @param content  内容
     * @param imgPath  图片路径
     * @param response
     * @author <a href="mailto:zhangwentao@gtmap.cn">zhangwentao</a>
     * @description 获取二维码图片
     */
    public static void encoderQRCode(String content, String imgPath, HttpServletResponse response) {
        try {
            Qrcode qrcodeHandler = new Qrcode();
            qrcodeHandler.setQrcodeErrorCorrect('M');
            qrcodeHandler.setQrcodeEncodeMode('B');

            String s = URLDecoder.decode(content, "utf-8");
            byte[] contentBytes = s.getBytes("utf-8");
            int picSize = 0;
            if (contentBytes.length < 256) {
                qrcodeHandler.setQrcodeVersion(8);
                picSize = 148;
            }


            BufferedImage bufImg = new BufferedImage(picSize, picSize, BufferedImage.TYPE_INT_RGB);
            Graphics2D gs = bufImg.createGraphics();

            gs.setBackground(Color.WHITE);
            gs.clearRect(0, 0, picSize, picSize);

            // 设定图像颜色> BLACK
            gs.setColor(Color.BLACK);

            // 设置偏移量 不设置可能导致解析出错
            int pixoff = 2;
            // 输出内容> 二维码
            if (contentBytes.length > 0) {
                boolean[][] codeOut = qrcodeHandler.calQrcode(contentBytes);
                for (int i = 0; i < codeOut.length; i++) {
                    for (int j = 0; j < codeOut.length; j++) {
                        if (codeOut[j][i]) {
                            gs.fillRect(j * 3 + pixoff, i * 3 + pixoff, 3, 3);
                        }
                    }
                }
            } else {
                LOGGER.info("QRCode content bytes length = "
                        + contentBytes.length + " not in [ 0,120 ]. ");
            }

            gs.dispose();
            bufImg.flush();

            // 生成二维码QRCode图片
            if (StringUtils.isNotBlank(imgPath)) {
                //生成下载图片
                File imgFile = new File(imgPath);
                ImageIO.write(bufImg, "jpg", imgFile);
            } else {
                //生成IO流
                ImageIO.write(bufImg, "jpg", response.getOutputStream());
            }
        } catch (Exception e) {
            LOGGER.error("二维码获取异常！", e);
        }

    }
}
