package cn.gtmap.realestate.common.util;

import java.util.HashMap;
import java.util.Map;

/**
 * @author <a href="mailto:hanyi@gtmap.cn">hanyi</a>
 * @version 1.0  2018/10/31
 * @description 通用常量
 */
public class CommonConstantUtils {
    /**
     * 权属类型代码，单元号第14位
     */
    public static final String QSLXDM_A = "A";
    public static final String QSLXDM_BSXWY = "BSXWY";
    public static final String QSLXDM_C = "C";
    public static final String QSLXDM_D = "D";
    public static final String QSLXDM_E = "E";
    public static final String QSLXDM_F = "F";
    public static final String QSLXDM_G = "G";
    public static final String QSLXDM_H = "H";
    public static final String QSLXDM_J = "J";
    public static final String QSLXDM_L = "L";
    public static final String QSLXDM_N = "N";
    public static final String QSLXDM_W = "W";
    //生成编号时的前缀特征码
    public static final String BHTZM_FW = "F";

    public static final String BHTZM_TD = "T";

    public static final String BHTZM_HY = "H";

    public static final String BHTZM_LQ = "L";

    public static final String DZWTZM_TD = "W";

    /**
     * 水电气业务类型
     */
    public static final String SDQYWLX_S = "1";
    public static final String SDQYWLX_D = "2";
    public static final String SDQYWLX_Q = "3";

    /**
     * 水电气材料名称缩写
     */
    public static final String CLMC_SHUI1 = "(水电)";
    public static final String CLMC_SHUI2 = "(水)";
    public static final String CLMC_DIAN = "(电)";
    public static final String CLMC_QI = "(燃气)";
    /**
     * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
     * @description 文件中心clientId
     */
    public static final String WJZX_CLIENTID = "clientId";
    /**
     * 文件中心clientId-电子证照路径
     */
    public static final String WJZX_CLIENTID_ECERTIFICATE = "eCertificateId";

    /**
     * 文件中心clientId-打印
     */
    public static final String WJZX_CLIENTID_PRINT = "printId";

    /**
     * 水电气业务类型
     * 1-未申请
     * 2-已申请
     * 3-办理成功
     * 4-办理失败
     * 5-其他
     */
    public static final Integer WSQ = 1;
    public static final Integer YSQ = 2;
    public static final Integer BLCG = 3;
    public static final Integer BLSB = 4;
    public static final Integer QT = 5;

    /**
     * @author <a href="mailto:liyinqiao@gtmap.cn">liyinqiao</a>
     * @description 虚拟宗地宗海顺序号
     */
    public static final String ZDZHSXH_XN = "000000";

    /**
     * 宗地后缀
     */
    public static final String SUFFIX_ZD_BDCDYH = "W00000000";
    /**
     * 批量后缀
     */
    public static final String SUFFIX_PL = "等";

    /**
     * 用于标识权利其他状况是要追加在原权利其他状况值后的
     */
    public static final String ADD_QLQTZK = "add_qlqtzk";

    /**
     * 用于标识附记是要追加在原附记值后的
     */
    public static final String ADD_FJ = "add_fj";
    /**
     * 查询子系统代码
     */
    public static final String INQUIRY_DM = "inquiry";

    /**
     * register子系统代码
     */
    public static final String REGISTER_DM = "register";

    /**
     * 楼盘表子系统代码
     */
    public static final String BUILDING_DM = "building";

    /**
     * 规则子系统代码
     */
    public static final String RULE_DM = "rule";

    /**
     * 受理子系统代码
     */
    public static final String ACCEPT_DM = "accept-app1";

    /**
     * event：查询
     */
    public static final String LOG_EVENT_QUERY = "QUERY";

    /**
     * event：打印日志
     */
    public static final String LOG_EVENT_PRINTLOG = "PRINTLOG";

    /**
     * event：手动登簿
     */
    public static final String LOG_EVENT_SDDBLOG = "SDDB";
    /**
     * event：权籍不动产单元状态更新
     */
    public static final String LOG_EVENT_QJBDCDYZT = "QJBDCDYZT";

    /**
     * event：打印
     */
    public static final String LOG_EVENT_PRINT = "PRINT";

    /**
     * event：导出
     */
    public static final String LOG_EVENT_EXPORT = "EXPORT";

    /**
     * event：上传
     */
    public static final String LOG_EVENT_UPLOAD = "UPLOAD";

    /**
     * event：下载
     */
    public static final String LOG_EVENT_DOWNLOAD = "DOWNLOAD";

    /**
     * event：删除
     */
    public static final String LOG_EVENT_DELETE = "DELETE";

    /**
     * event：新建
     */
    public static final String LOG_EVENT_CREATE = "CREATE";

    /**
     * event
     */
    public static final String LOG_EVENT = "event";

    /**
     * 综合查询日志类型
     */
    public static final String LOG_EVENT_ZHCX = "ZHCXLOG";

    /**
     * 标记为查询条件参数
     */
    public static final String PARAM_SUB = "param_";

    /**
     * 标记为查询台账参数
     */
    public static final String VIEW_SUB = "view_";

    /**
     * Controller Name
     */
    public static final String CONTROLLER_CLASS_NAME = "mvc.controller.class";

    /**
     * Method Name
     */
    public static final String CONTROLLER_METHOD_NAME = "mvc.controller.method";

    /**
     * 用户名
     */
    public static final String PRINCIPAL = "principal";

    /**
     * 证明编号
     */
    public static final String ZMBH = "zmbh";

    /**
     * 受理编号
     */
    public static final String SLBH = "slbh";

    /**
     * 权利人
     */
    public static final String QLR = "qlr";

    /**
     * 权利人名称
     */
    public static final String QLRMC = "qlrmc";

    /**
     * 义务人
     */
    public static final String YWR = "ywr";

    /**
     * 坐落
     */
    public static final String ZL = "zl";

    /**
     * 不动产单元号
     */
    public static final String BDCDYH = "bdcdyh";

    /**
     * 大云平台真实姓名
     */
    public static final String ALIAS = "alias";

    /**
     * 组织机构
     */
    public static final String ORGANIZATION = "organization";

    /**
     * 查询条件
     */
    public static final String CXTJ = "cxtj";

    /**
     * 查询结果
     */
    public static final String CXJG = "cxjg";

    /**
     * 查询结果
     */
    public static final String IPADDRESS = "ipaddress";

    /**
     * 打印日志模板路径
     */
    public static final String MODELURS = "modelUrl";
    /**
     * 打印日志数据源地址
     */
    public static final String DATAURL = "dataUrl";
    /**
     * 打印日志数据源xml
     */
    public static final String PRINTTYPE = "printType";

    /**
     * 打印类型
     */
    public static final String XMLSTR = "xmlStr";


    /**
     * 响应结果
     */
    public static final String RESPONSE = "response";

    /**
     * 请求参数
     */
    public static final String REQUEST = "request";

    public static final String DETAILS = "details";

    //响应成功状态码
    public static final String RESPONSE_SUCCESS = "200";

    // 完税状态-已完税
    public static final String WSZT_YWS = "1";

    /**
     * 大云平台流程操作内容
     */
    public static final String PROCESSDEFINITIONNAME = "processDefinitionName";
    public static final String PROCESSINSTANCEID = "processInstanceId";
    public static final String TASKID = "taskId";
    public static final String ACTIVITYNAME = "activityName";
    public static final String DELETEREASON = "reason";
    public static final String ZFOPNION = "opinion";

    /**
     * 操作IP
     */
    public static final String DETAILS_REMOTEADDRESS = "remoteAddress";

    /**
     * 操作IP
     */
    public static final String IP = "ip";

    /**
     * 操作IP
     */
    public static final String REMOTEADDR = "remoteAddr";

    /**
     * 客户端ip
     */
    public static final String CLIENT_IP = "clientIp";

    /**
     * 真实姓名
     */
    public static final String REALNAME = "realName";

    /**
     * 日志查询-模糊查询
     */
    public static final String TYPE_LIKE = "like";

    /**
     * 日志查询-精确查询
     */
    public static final String TYPE_EQUAL = "equal";

    /**
     * 查询结果中部分数据 保存的key
     */
    public static final String RESPONSE_PARAM_KEY = "response_key";

    /**
     * 台账类型
     */
    public static final String VIEW_TYPE = "viewType";


    /**
     * 所属资源
     */
    public static final String SOURCE_MEUN = "sourceMeun";

    /**
     * 台账名称
     */
    public static final String VIEW_TYPE_NAME = "viewTypeName";

    /**
     * 台账名称全量
     */
    public static final String ACTION = "action";

    /**
     * 导出内容
     */
    public static final String DCNR = "DCNR";

    /**
     * 台账地址
     */
    public static final String VIEW_ADDRESS = "viewAddress";

    /**
     * 拼接查询条件得分隔符
     */
    public static final String separate = "， ";

    /**
     * 文件名称
     */
    public static final String FILE_NAME = "fileName";

    /**
     * 文件路径
     */
    public static final String FILE_PATH = "filePath";

    /**
     * fr3 打印模板名称
     */
    public static final String FR3_TEMPLAT = "templatName";

    /**
     * 需要保存到日志中的查询参数
     */
    public static final String PARAM_LIST = "paramList";

    /**
     * gzlslid
     */
    public static final String GZLSLID = "gzlslid";
    /**
     * 终止
     */
    public static final Integer QSZT_END = 3;
    /**
     * 历史
     */
    public static final Integer QSZT_HISTORY = 2;
    /**
     * 临时
     */
    public static final Integer QSZT_TEMPORY = 0;
    /**
     * 现势
     */
    public static final Integer QSZT_VALID = 1;

    /**
     * 权籍登记状态——已登记
     */
    public static final Integer QJDJ_VALID = 1;

    /**
     * 权籍登记状态——已注销
     */
    public static final Integer QJDJ_HISTORY = 2;

    /**
     * 权利人类别：权利人
     */
    public static final String QLRLB_QLR = "1";
    /**
     * 权利人类别：义务人
     */
    public static final String QLRLB_YWR = "2";
    /**
     * 权利人类别：权利人
     */
    public static final Integer QLRLB_QLR_DM = 1;
    /**
     * 权利人类别：义务人
     */
    public static final Integer QLRLB_YWR_DM = 2;
    /**
     * 证书版式 单一版
     */
    public static final Integer ZSBS_DYB_DM = 0;
    /**
     * 是否 否
     */
    public static final Integer SF_F_DM = 0;
    /**
     * 是否 是
     */
    public static final Integer SF_S_DM = 1;

    /**
     * 收费状态 未缴费
     */
    public static final Integer SFZT_WJF = 1;

    /**
     * 收费状态 已缴费
     */
    public static final Integer SFZT_YJF = 2;

    /**
     * 收费状态 部分缴费
     */
    public static final Integer SFZT_BFJF = 3;

    /**
     * 收费状态 已核验
     */
    public static final Integer SFZT_YHY = 7;

    /**
     * 项目来源 存量过渡数据
     */
    public static final Integer XMLY_CLGD_DM = 2;


    /**
     * 项目来源 其他
     */
    public static final Integer XMLY_QT_DM = 3;

    /**
     * 案件状态 在办
     */
    public static final Integer AJZR_ZB_DM = 1;
    /**
     * 案件状态 已办
     */
    public static final Integer AJZR_YB_DM = 2;

    /**
     * 案件状态 用户撤回
     */
    public static final Integer AJZR_YHCH_DM = 5;
    /**
     * 登记类型 首次登记
     */
    public static final Integer DJLX_SCDJ_DM = 100;
    /**
     * 登记类型 首次登记
     */
    public static final Integer DJLX_ZYDJ_DM = 200;
    /**
     * 登记类型 变更登记
     */
    public static final Integer DJLX_BGDJ_DM = 300;
    /**
     * 登记类型 注销登记
     */
    public static final Integer DJLX_ZXDJ_DM = 400;
    /**
     * 登记类型 更正登记
     */
    public static final Integer DJLX_GZDJ_DM = 500;
    /**
     * 登记类型 异议登记
     */
    public static final Integer DJLX_YYDJ_DM = 600;
    /**
     * 登记类型 预告登记
     */
    public static final Integer DJLX_YGDJ_DM = 700;
    /**
     * 登记类型 查封登记
     */
    public static final Integer DJLX_CFDJ_DM = 800;
    /**
     * 登记类型 其他登记
     */
    public static final Integer DJLX_QTDJ_DM = 900;
    /**
     * 不动产类型特征码
     */
    public static final String BDCLX_TZM_W = "W";
    public static final String BDCLX_TZM_F = "F";
    public static final String BDCLX_TZM_L = "L";
    public static final String BDCLX_TZM_Q = "Q";
    /**
     * 不动产单元号的长度
     */
    public static final Integer BDCDYH_LENGTH = 28;

    /**
     * 房屋类型（多幢）
     */
    public static final Integer FWLX_DUOZH = 1;

    /**
     * 不动产房屋类型（独幢房屋）
     */
    public static final Integer BDCDYFWLX_DUZH = 2;
    /**
     * 不动产房屋类型（户室）
     */
    public static final Integer BDCDYFWLX_HS = 4;
    /**
     * 证书
     */
    public static final Integer ZSLX_ZS = 1;
    public static final String DYLX_ZS = "zs";
    /**
     * 证明
     */
    public static final Integer ZSLX_ZM = 2;
    public static final String DYLX_ZM = "zm";
    /**
     * 证明单
     */
    public static final Integer ZSLX_ZMD = 3;
    public static final String DYLX_SCZMD = "sczmd";

    /**
     * 证书样式-首次证明单
     */
    public static final String ZS_MODAL_SCZMD = "sczmd";
    /**
     * 中文证书
     */
    public static final String ZSLX_ZS_CN = "不动产权证书";
    /**
     * 中文证明
     */
    public static final String ZSLX_ZM_CN = "不动产权证明书";
    /**
     * 中文首次证明单
     */
    public static final String ZSLX_SCZMD_CN = "首次证明单";
    /**
     * 打印配置 参数
     */
    public static final String PRINT_CONFIG_CS = "CS";
    /**
     * 打印配置 detail id
     */
    public static final String DY_ZB_ID = "DYZBID";
    /**
     * 打印数据源
     */
    public static final String DY_SJY = "DYSJY";
    /**
     * 打印字表数据源
     */
    public static final String DY_ZB_SJY = "DYZBSJY";
    /**
     * 打印类型
     */
    public static final String BDC_DYLX = "dylx";
    /**
     * 配置sql xmid参数
     */
    public static final String SQL_CS_XMID = "#{xmid}";
    /**
     * 发证记录打印类型-列表批量打印
     */
    public static final String FZJL_DYLX_LIST = "fzjlList";
    /**
     * 发证记录类型——按项目打印
     */
    public static final String FZJL_DYLX_XM = "fzjl";
    // 发证记录类型——按流程合并打印
    public static final String FZJL_DYLX_HB = "fzjlHb";

    /**
     * 中文字符 ；
     */
    public static final String ZF_ZW_FH = "；";
    /**
     * 英文分号
     */
    public static final String ZF_YW_FH = ";";

    /**
     * 英文逗号
     */
    public static final String ZF_YW_DH = ",";
    /**
     * 估值符号
     */
    public static final String ZF_GZH = "^";

    /**
     * 英文斜杠
     */
    public static final String ZF_YW_XG = "/";
    /**
     * 中文字符 ：
     */
    public static final String ZF_ZW_MH = "：";
    /**
     * 换行符
     */
    public static final String ZF_HH_CHAR = "\n";

    /**
     * 英文点
     */
    public static final String ZF_YW_JH = ".";

    /**
     * 权证号截取依据字符
     */
    public static final String DI = "第";
    public static final String HAO = "号";
    /**
     * 空格，注意是空格，不是空字符串
     */
    public static final String ZF_KG_CHAR = " ";
    /**
     * 归档信息xml地址
     */
    public static final String XML_PATH_GDXX = "/bdcGd/bdcGdxx.xml";
    /**
     * 归档名称配置xml地址
     */
    public static final String XML_PATH_GDMC = "/bdcGd/bdcGdmc.xml";
    /**
     * 收费信息xml配置地址
     */
    public static final String XML_PATH_SFXX = "/bdcSfxx/bdcSfxx.xml";
    /**
     * 登记信息是否归多条
     */
    public static final String GD_DJXXGDT = "DJXXGDT";
    /**
     * 原文是否归多条
     */
    public static final String GD_YWGDT = "YWGDT";


    /**
     * 查封类型 查封
     */
    public static final Integer CFLX_CF = 1;
    /**
     * 查封类型 轮候查封
     */
    public static final Integer CFLX_LHCF = 2;
    /**
     * 查封类型 预查封
     */
    public static final Integer CFLX_YCF = 3;
    /**
     * 查封类型 轮候预查封
     */
    public static final Integer CFLX_LHYCF = 4;
    /**
     * 查封类型 续封
     */
    public static final Integer CFLX_XF = 5;

    /**
     * 查封权利类型
     */
    public static final Integer QLLX_CF = 98;
    /**
     * 查封权利类型
     */
    public static final Integer QLLX_YY = 97;

    /**
     * 预告登记种类 预售商品房买卖预告登记
     */
    public static final Integer YGDJZL_YSSPFYG = 1;
    /**
     * 其它不动产买卖预告登记
     */
    public static final Integer YGDJZL_QTYG = 2;
    /**
     * 预售商品房抵押权预告登记
     */
    public static final Integer YGDJZL_YSSPFDYYG = 3;
    /**
     * 其它不动产抵押权预告登记
     */
    public static final Integer YGDJZL_QTDYYG = 4;


    /*同步权籍不动产单元状态标识：现势*/
    public static final Integer BDCDYZT_XS = 1;
    /*同步权籍不动产单元状态标识：历史*/
    public static final Integer BDCDYZT_LS = -1;

    /*同步权籍不动产单元登记状态：已登记*/
    public static final Integer BDCDYDJZT_YDJ = 1;
    /*同步权籍不动产单元登记状态：已注销*/
    public static final Integer BDCDYDJZT_YZX = 2;
    /*同步权籍不动产单元登记状态：未登记*/
    public static final Integer BDCDYDJZT_WDJ = 0;

    public static final Integer[] CFLX_YCF_ARR = {3, 4};

    /*预告登记种类：预告*/
    public static final Integer[] YG_YGDJZL_ARR = {1, 2};
    /*预告登记种类：预抵押*/
    public static final Integer[] YG_YGDJZL_YDY_ARR = {3, 4};

    /*预告登记：预抵押*/
    public static final String YGDJ_YDY = "ydya";

    /*抵押不动产类型：在建建筑物*/
    public static final Integer DYBDCLX_ZJJZW = 4;

    /*抵押不动产类型：林权*/
    public static final Integer DYBDCLX_LQ = 3;

    /*抵押不动产类型：纯土地*/
    public static final Integer DYBDCLX_CTD = 1;

    /*抵押不动产类型：房地一体*/
    public static final Integer DYBDCLX_FDYT = 2;

    /*土地用途：工业类*/
    public static final String TDYT_GYL = "06";

    /*抵土地用途：住宅类*/
    public static final String TDYT_ZZL = "07";

    /*2为房屋*/
    public static final Integer FWBDCLX = 2;

    /**
     * 不动产单元锁定状态——锁定
     */
    public static final Integer SDZT_SD = 1;

    /**
     * 不动产单元锁定状态——解锁
     */
    public static final Integer SDZT_JS = 0;


    public static final String[] ZH_TZM = {"G", "H"};

    /**
     * 宗地特征码E
     */
    public static final String ZDTZM_E = "E";

    /**
     * 宗地特征码G
     */
    public static final String ZDTZM_G = "G";

    /**
     * 宗地特征码H
     */
    public static final String ZDTZM_H = "H";

    /**
     * 宗地特征码L
     */
    public static final String ZDTZM_L = "L";

    /**
     * 权籍表GZW_DCB
     */
    public static final String LX_GZW = "GZW";

    /**
     * 权籍表FW_YCHS
     */
    public static final String LX_YCHS = "YCHS";


    /*生成证书的权利类型 仅限于判定类型,不能用于判定是否生成证 */
    public static final Integer[] BDC_ZS_QLLX = {1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 23, 24, 25, 26, 27, 28, 94};

    /*生成证明的权利类型  仅限于判定类型,不能用于判定是否生成证*/
    public static final Integer[] BDC_ZM_QLLX = {19, 20, 21, 22, 93, 95, 96, 97, 98, 99};

    /**
     * 使用情况
     */
    /**
     * 未使用
     */
    public static final Integer SYQK_WSY = 0;
    /**
     * 已打证
     */
    public static final Integer SYQK_YDZ = 1;
    /**
     * 作废
     */
    public static final Integer SYQK_ZF = 2;
    /**
     * 已使用
     */
    public static final Integer SYQK_YSY = 3;
    /**
     * 遗失
     */
    public static final Integer SYQK_YS = 4;
    /**
     * 销毁
     */
    public static final Integer SYQK_XH = 5;
    /**
     * 已领用
     */
    public static final Integer SYQK_YLY = 6;
    /**
     * 其他
     */
    public static final Integer SYQK_QT = 99;
    /**
     * 左右括号
     */
    public static final String BDCQ_BH_LEFT_BRACKET = "(";
    public static final String BDCQ_BH_RIGHT_BRACKET = ")";
    /**
     * 中文括号
     */
    public static final String BDCQ_BH_LEFT_BRACKET_CN = "（";
    public static final String BDCQ_BH_RIGHT_BRACKET_CN = "）";
    /**
     * 意见类型 默认意见
     */
    public static final Integer YJLX_MRYJ = 0;
    /**
     * 意见类型 可选意见
     */
    public static final Integer YJLX_KXYJ = 1;
    /**
     * 不动产权证号注销标识
     */
    public static final String BDCQZH_ZX = "（销）";

    /**
     * Redis分布式锁名称定义
     */

    /**
     * 不动产权证号锁名称
     */
    public static final String REDISSON_LOCK_BDCQZH = "REDISSON_LOCK_BDCQZH";
    /**
     * 不动产印制号锁名称
     */
    public static final String REDISSON_LOCK_BDCYZH = "REDISSON_LOCK_BDCYZH";

    /**
     * 不动产移交单编号锁名称
     */
    public static final String REDISSON_LOCK_BDCYJDBH = "REDISSON_LOCK_BDCYJDBH";

    /**
     * 查询申请书受理编号REDIS KEY
     */
    public static final String REDIS_LOCK_CXSQS_SLBH = "REDIS_LOCK_CXSQS_SLBH";

    /**
     * 不动产项目编号锁名称
     */
    public static final String REDISSON_LOCK_BDCXMBH = "REDISSON_LOCK_BDCXMBH";

    /**
     * 不动产虚拟不动产单元锁名称
     */
    public static final String REDISSON_LOCK_XNBDCDYH = "REDISSON_LOCK_XNBDCDYH";
    /**
     * 发票号锁名称
     */
    public static final String REDISSON_LOCK_FPH = "REDISSON_LOCK_FPH";

    /**
     * 抵押统计月报打印：key前缀
     */
    public static final String REDIS_DYATJ_MONTH_PRINT = "REDIS_DYATJ_MONTH_PRINT_";

    /**
     * 抵押统计日报打印：key前缀
     */
    public static final String REDIS_DYATJ_DAY_PRINT = "REDIS_DYATJ_DAY_PRINT_";

    /**
     * 不动产证书证明批量打印：key前缀
     */
    public static final String REDIS_BATCH_ZSZM_PRINT = "REDIS_BATCH_ZSZM_PRINT_";

    /**
     * 不动产查询：不动产单元号保存Redis key前缀
     */
    public static final String REDIS_INQUIRY_BDCDYH = "REDIS_INQUIRY_BDCDYH_";
    /**
     * 南通其他证明数据缓存Redis key
     */
    public static final String REDIS_INQUIRY_NT_QTZM = "REDIS_INQUIRY_NT_QTZM_";
    /**
     * 抵押证明：不动产单元号保存Redis key前缀
     */
    public static final String REDIS_INQUIRY_DYZM = "REDIS_INQUIRY_DYZM_";

    /**
     * 不动产住房查询：权利人证件号保存Redis key前缀
     */
    public static final String REDIS_INQUIRY_ZFXX = "REDIS_INQUIRY_ZFXX_";
    /**
     * 标准版综合查询：房产证明参数信息保存Redis key前缀
     */
    public static final String REDIS_INQUIRY_BZB_FCZM = "REDIS_INQUIRY_BZB_FCZM_";

    /**
     * 规则保存表达式内容KEY
     */
    public static final String REDIS_RULE_EXPRESSION = "REDIS_RULE_EXPRESSION";

    /**
     * 特殊业务配KEY
     */
    public static final String REDIS_TSYW_PZ= "REDIS_TSYW_PZ";
    /**
     * 收费项目xml 配置
     */
    public static final String REDIS_INQUIRY_BDC_SFXX_XML = "REDIS_INQUIRY_BDC_SFXX_XML";
    /**
     * 项目YML配置内容KEY
     */
    public static final String REDIS_INIT_YML = "REDIS_INIT_YML";


    /**
     * 同步权籍标识：登簿还是退回
     */
    public static final String TBQJ_DB = "DB";
    public static final String TBQJ_TH = "TH";


    /**
     * 权利类型：预告
     */
    public static final Integer QLLX_YG_DM = 96;
    /**
     * 权利类型：地役权
     */
    public static final Integer QLLX_DYIQ_DM = 19;
    /**
     * 权利类型：房屋租赁
     */
    public static final Integer QLLX_FWZL_DM = 93;
    /**
     * 权利类型：抵押
     */
    public static final Integer QLLX_DYAQ_DM = 95;
    public static final Integer QLLX_FDCQ_DM = 4;
    public static final Integer QLLX_HY_DM = 15;
    public static final Integer QLLX_GZW_DM = 16;
    // 集体建设用地使用权/房屋所有权
    public static final Integer QLLX_JTJSSYQ_FWSYQ_DM = 8;
    public static final Integer QLLX_JTJSSYQ_DM = 7;
    // 国有建设用地使用权
    public static final Integer QLLX_GYJSYDSYQ_DM = 3;
    /**
     * 实体属性或对应方法名称常量定义
     */
    public static final String BDCLX = "bdclx";
    /**
     * 审核节点
     */
    public static final String BDC_SHJD_CS = "初审";
    public static final String BDC_SHJD_FS = "复审";
    public static final String BDC_SHJD_HD = "核定";
    /**
     * 审核节点ID
     */
    public static final String BDC_SHJDID_CS = "cs";
    public static final String BDC_SHJDID_FS = "fs";
    public static final String BDC_SHJDID_HD = "hd";

    /**
     * 审核节点配置
     */
    public static final String BDC_SHJD_PZ = "sign";
    /**
     * 字典表名：单位信息
     */
    public static final String TABLE_S_DM_DWXX = "s_dm_dwxx";
    /**
     * 字典表名：行政信息
     */
    public static final String TABLE_S_DM_XZXX = "s_dm_xzxx";
    /**
     * 字段名称:行政代码
     */
    public static final String COLUMN_XZDM = "XZDM";
    /**
     * 字段名称：行政名称
     */
    public static final String COLUMN_XZMC = "XZMC";
    /**
     * 字段名称：单位代码
     */
    public static final String COLUMN_DWDM = "DWDM";
    /**
     * 字段名称：单位名称
     */
    public static final String COLUMN_DWMC = "DWMC";

    /**
     * 印制号领取方式：按部门
     */
    public static final String YZH_LQFS_BM = "0";
    /**
     * 印制号领取方式：按人员
     */
    public static final String YZH_LQFS_RY = "1";
    /**
     * 印制号领取方式：只根据默认的区县代码
     */
    public static final String YZH_LQFS_QXDM = "2";
    /**
     * 不动产单元类型特征码,在单元号的位置
     */
    public static final int BDCLX_TZM_INDEX = 20;

    /**
     * 共有方式——单独所有
     */
    public static final Integer GYFS_DDSY = 0;
    /**
     * 共有方式——共同共有
     */
    public static final Integer GYFS_GTGY = 1;
    /**
     * 共有方式——按份共有
     */
    public static final Integer GYFS_AFGY = 2;
    /**
     * 共有方式——其它共有
     */
    public static final Integer GYFS_QTGY = 3;

    /**
     * 共有人标识--产权人
     */
    public static final String GYRBJ_CQR = "0";
    /**
     * 共有方式——共有人
     */
    public static final String GYRBJ_GYR = "1";

    /**
     * 默认意见数据类型——SQL
     */
    public static final Integer MRYJ_SJLX_SQL = 1;
    /**
     * 表单名称
     */
    public static final String FORM_NAME_SH = "审核信息";
    /**
     * 提示信息验证类型：confirm
     */
    public static final Integer YZLX_CONFIRM = 1;
    /**
     * 提示信息验证类型：alert
     */
    public static final Integer YZLX_ALERT = 3;
    /**
     * 限制权利 95:抵押 96：预告 97：异议 98：查封 19：地役
     */
    public static final Integer[] BDC_QLLX_XZQL = {95, 96, 97, 98, 19};
    /**
     * 房产权利
     */
    public static final Integer[] QLLX_FDCQ = {4, 6, 8};

    /**
     * 出土地权利
     */
    public static final Integer[] QLLX_CTD = {1,2,3};
    /**
     * 权利类型
     */
    public static final String BDC_QLLX = "qllx";
    /**
     * 单元号权利类型
     */
    public static final String BDC_DYHQLLX = "dyhqllx";
    /**
     * 字典项代码
     */
    public static final String ZD_DM = "DM";

    /**
     * 收费标准--工本费
     */
    public static final String SFXM_BZ_GBF = "工本费/10元";

    /**
     * 收费标准--登记费代码
     */
    public static final String SFXM_BZ_DJF_DM = "1";

    /**
     * 收费标准--登记费--非住宅--550--名称
     */
    public static final String SFXM_BZ_DJFMC_FZZ = "登记费(非住宅)/550元";

    /**
     * 收费标准--登记费--住宅--80--名称
     */
    public static final String SFXM_BZ_DJFMC_ZZ = "登记费(住宅)/80元";

    /**
     * 收费标准--登记费--住宅--80--金额标准
     */
    public static final Double SFXM_BZ_DJF_ZZ_JE = 80.00;

    /**
     * 收费标准--登记费--非住宅--550--金额标准
     */
    public static final Double SFXM_BZ_DJF_FZZ_JE = 550.00;

    /**
     * 收费项目名称-登记费--住宅--80--名称
     */
    public static final String SFXMMC_DJF_ZZ = "不动产登记费（住宅）";

    /**
     * 收费项目名称--登记费--非住宅--550--名称
     */
    public static final String SFXMMC_DJF_FZZ = "不动产登记费（非住宅）";

    // 一窗水电气打印类型
    public static final String YCSDQDYLX = "ycsdqsqb";

    // 涉税申请单个人
    public static final String YCSSSQDGRDYLX = "ycslgrsqd";
    // 涉税申请单单位
    public static final String YCSSSQDDWDYLX = "ycsldwsqd";

    //所有的收费单打印类型
    public static final String[] SFD_ALL_DYLX = {"sfd", "dysfd", "sfdpl", "dysfdpl", "ycslsfd", "jnpz", "jnpzpl","dyjnpz","dyjnpzpl"};

    //需要获取收费单二维码打印类型
    public static final String[] SFDEWM_DYLX = {"ycsftzd", "ycsfjnpz"};

    //打印内容需要从受理库获取的打印类型

    public static final String[] Sl_ALL_DYLX = {"sfd", "dysfd", "sfdpl", "dysfdpl", "sjd", "sjdpl", "czsjd", "czsjdpl",
            "ycslsfd", "djgzs", "djgzspl", "qjdcsjd", "cqsjd", "dyasjd", "noczsjd", "qtsjd", "ycsftzd", "ycsjd",
            "ycspb" , "jnpz", "dyjnpz", "jnpzpl", "dyjnpzpl", "ycsfjnpz"};

    //受理页面打印需要获取登记库的打印类型

    public static final String[] Sl_DJ_DYLX = {"sqs", "cfjds", "sqspl", "bdcdyList", "grsqs", "dwsqs", "dyasqs", "grsqspl", "dwsqspl", "dyasqspl",
            "gyxx", "grxwbl", "dwxwbl", "dyaxwbl", "grxwblpl", "dwxwblpl", "dyaxwblpl","rzdb","yszm"};


    /**
     *  申请书打印类型
     **/
    public static final String[] SL_SQS_DYLX = {"grsqs","dwsqs","dyasqs","grsqspl","dwsqspl","dyasqspl","grsqs-zh","grsqs-cq","dwsqs-cq","grsqs-zh","grsqs-cqzx","dwsqs-cqzx","dwsqs-spfscdj","ycsqd",
            "grsqs-zhpl","grsqs-cqpl","dwsqs-cqpl","grsqs-zhpl","grsqs-cqzxpl","dwsqs-cqzxpl","dwsqs-spfscdjpl","ycsqdpl"};

    /**
     *  询问笔录打印类型
     **/
    public static final String[] SL_XWBL_DYLX = {"grxwbl","dwxwbl","dyaxwbl","grxwblpl","dwxwblpl","dyaxwblpl"};

    /**
     *  查封决定书打印类型
     **/
    public static final String[] SL_JDS_DYLX = {"cfjds","xfjds","lhcfjds","jfjds","ycfjds","cdghjds"};

    /** 共有信息和单元附页*/
    public static final String[] DJ_OTHER_DYLX = {"gyxx", "bdcdyList"};

    /**
     * 打印内容需要从受理库获取的打印类型*/
    public static final String[] SL_ALL_DYLX = {"sfd", "dysfd", "sfdpl", "dysfdpl", "sjd", "sjdpl", "czsjd", "czsjdpl", "ycslsfd", "djgzs", "djgzspl","qjdcsjd","cqsjd","dyasjd","noczsjd","qtsjd","ycsl","ythqrd"};

    /**
     * 打印需要参数需要将值替换为登记库字典数据的打印类型
     **/
    public static final String[] SL_ZD_DYLX = {"ycslgrsqd", "ycsldwsqd"};

    /**
     * 打印种类分为pdf和fr3打印
     **/
    public static  final String BDC_DYZL_PDF = "pdf";

    public static final String BDC_DYZL_FR3 = "fr3";
    /**
     * 证件种类——身份证
     */
    public static final Integer ZJZL_SFZ = 1;
    /**
     * 证件种类——营业执照
     */
    public static final Integer ZJZL_YYZZ = 7;
    /**
     * 不动产异议期限
     */
    public static final Integer BDC_YY_QX = 15;
    /**
     * 规则验证类型 转发
     */
    public static final String GZYZ_LX_ZF = "zf";
    /**
     * 规则验证模板 转发
     */
    public static final String GZYZ_MB_ZF = "processKey_LCZF";
    /**
     * 规则验证类型 退回
     */
    public static final String GZYZ_LX_TH = "th";

    /**
     * 规则验证类型 退回
     */
    public static final String GZYZ_MB_TH = "processKey_LCTH";
    /**
     * 规则验证类型 删除
     */
    public static final String GZYZ_LX_SC = "sc";

    /**
     * 规则验证类型 删除
     */
    public static final String GZYZ_MB_SC = "processKey_LCSC";
    /**
     * 节点名称
     */
    public static final String JD_SL = "受理";

    public static final String JD_SZ = "缮证";
    /**
     * 宗地图地址
     */
    public static final String ZDT_URL = "/rest/v1.0/zs/print/zdt/{bdcdyh}";

    /**
     * 户室图地址
     */
    public static final String HST_URL = "/rest/v1.0/zs/print/hst/{bdcdyh}";
    /**
     * 档案信息图片地址
     */
    public static final String DAXX_IMAGE_PRINT_URL = "/rest/v1.0/print/hefei/image/{userName}/{archid}/{currentpage}";
    /**
     * 房产证明
     */
    public static final String REDIS_INQUIRY_NT_FCZM = "REDIS_INQUIRY_NT_FCZM";
    /**
     * 房产档案
     */
    public static final String REDIS_INQUIRY_FCDA = "REDIS_INQUIRY_FCDA_";
    /**
     * 标准版 综合查询房产证明
     */
    public static final String REDIS_INQUIRY_BZB_QSZM = "REDIS_INQUIRY_BZB_QSZM_";

    /**
     * 权利其他状况附记 权利其他状况
     */
    public static final String XT_QLQTZK_FJ_MODE_QLQTZK = "2";
    /**
     * 权利其他状况附记 附记
     */
    public static final String XT_QLQTZK_FJ_MODE_FJ = "3";

    /**
     * lclx  流程类型  普通
     */
    public static final Integer LCLX_PT = 1;
    /**
     * lclx  流程类型  组合
     */
    public static final Integer LCLX_ZH = 2;
    /**
     * lclx  流程类型  批量
     */
    public static final Integer LCLX_PL = 3;
    /**
     * lclx  流程类型  批量组合
     */
    public static final Integer LCLX_PLZH = 4;

    public static final String PORTAL_UI = "portal-ui";

    public static final String CONFIG_UI = "config-ui";

    public static final String HLLX = "忽略不动产单元验证";

    public static final String HLNR = "HLNR";

    public static final String LWLX = "例外不动产单元验证";

    public static final String LWNR = "LWNR";

    /**
     * 规则验证-忽略-创建
     */
    public static final String GZYZ_HL = "YZHL";

    /**
     * 规则验证-忽略-转发
     */
    public static final String GZYZ_HL_ZF = "YZHL_ZF";
    /**
     * 规则验证-例外
     */
    public static final String GZYZ_LW = "YZLW";
    /**
     * 规则强制验证内容导出的文件名称
     */
    public static final String GZ_QZYZ_FILE_NAME = "BdcGzQzyzFile";
    /**
     * 流程选择不动产单元时候对应的组合规则验证标识后缀
     */
    public static final String LC_ZHGZBS_XZBDCDY = "_XZBDCDY";
    /**
     * 流程转发时候对应的组合规则验证标识后缀
     */
    public static final String LC_ZHGZBS_LCZF = "_LCZF";

    /**
     * 匹配单元号时候对应的组合规则验证标识后缀
     */
    public static final String LC_ZHGZBS_PPDYH = "YZPPDYH";


    /**
     * 匹配土地证时候对应的组合规则验证标识后缀
     */
    public static final String LC_ZHGZBS_PPTDZ = "YZPPTDZ";
    /**
     * 流程强制验证对应的组合规则验证标识后缀
     */
    public static final CharSequence LC_ZHGZBS_QZYZ = "_QZYZ";
    /**
     * 不动产规则数据流入参默认值
     */
    public static final String BDC_GZ_SJL_RC_MRZ = "***###";
    /**
     * 必填项验证sql,默认条件
     */
    public static final String VALID_SQL_CONDITION_DEFAULT = "default";

    /**
     * 抵押物清单打印类型
     */
    public static final String DYWQD_DYLX = "dyawqd";


    /**
     * 权利人类型：个人
     */
    public static final Integer QLRLX_GR = 1;
    /**
     * 权利人类型：企业
     */
    public static final Integer QLRLX_QY = 2;
    /**
     * 权利人类型：事业单位
     */
    public static final Integer QLRLX_SYDW = 3;
    /**
     * 权利人类型：国家机关
     */
    public static final Integer QLRLX_GJJG = 4;
    /**
     * 权利人类型：其他
     */
    public static final Integer QLRLX_QT = 99;

    /**
     * 项目表审批来源  一窗受理
     */
    public static final Integer SPLY_YCSL = 1;

    /**
     * 项目表审批来源  互联网+
     */
    public static final Integer SPLY_WWSQ = 3;

    /**
     * 项目表审批来源  一窗受理 +互联网+
     */
    public static final Integer SPLY_WWSQ_YCSL= 5;

    /**
     * 南通区县代码
     */
    public static final String QXDM_NT = "320600";
    /**
     * 自助打证机印制号使用明细原因
     */
    public static final String YZH_SYYY = "证书印制号获取！";

    /**
     * 登记小类字典码
     */
    public static final String DJXL_ZD = "djxl";
    /**
     * 登记类型字典码
     */
    public static final String DJLX_ZD = "djlx";
    /**
     * 登记类型字典码
     */
    public static final String AJZT_ZD = "ajzt";
    /**
     * 登簿验证组合标识
     */
    public static final String processKey_DBYZ = "processKey_DBYZ";

    /**
     * 流水号生成自增时间范围：年
     */
    public static final String ZZSJFW_YEAR = "YEAR";

    /**
     * 流水号生成自增时间范围：月
     */
    public static final String ZZSJFW_MONTH = "MONTH";

    /**
     * 流水号生成自增时间范围：日
     */
    public static final String ZZSJFW_DAY = "DAY";

    /**
     * qlxx数据来源  原项目
     */
    public static final String QLSJLY_YXM = "2";

    /**
     * PDF、WORD模板子表ID前缀
     */
    public static final String PDF_WORD_SUBTABLE_PRE = "TABLE_";

    /**
     * PDF、WORD模板整体模式子表ID前缀
     */
    public static final String PDF_WORD_SUBTABLE_ZT1_PRE = "TABLE_ZT_";
    public static final String PDF_WORD_SUBTABLE_ZT2_PRE = "TABLE_zt_";

    /**
     * PDF、WORD导出checkbox字段默认前缀
     */
    public static final String PDF_WORD_CHECKBOX_UPPER_PRE = "CHECKBOX#";
    public static final String PDF_WORD_CHECKBOX_LOWER_PRE = "checkbox#";

    /**
     * PDF、WORD导出复选框图片名称
     */
    public static final String PDF_WORD_CHECKBOX_PICTURE_Y = "CheckboxY.png";
    public static final String PDF_WORD_CHECKBOX_PICTURE_N = "CheckboxN.png";

    /**
     * 自助打证 缮证节点名称
     */
    public static final String ZZDZ_SZ = "缮证";

    /**
     * 查询缴费缴税信息查询标志 查询收费
     */
    public static final String SFSSXX_CXBZ_SF = "1";
    /**
     * 查询缴费缴税信息查询标志 查询收税
     */
    public static final String SFSSXX_CXBZ_SS = "2";

    /**
     * 查询缴费缴税信息查询标志 查询收费和收税
     */
    public static final String SFSSXX_CXBZ_SF_SS = "3";

    /*
     * html版本
     * */

    public static final String SYSTEM_VERSION_NT = "nantong";

    /*
     * 版本:合肥
     * */

    public static final String SYSTEM_VERSION_HF = "hefei";

    /*
     * 版本:标准版
     * */

    public static final String SYSTEM_VERSION_STD = "standard";

    /**
     * 房屋套次-第零套
     */
    public static final String FWTC_ZERO = "0";

    /**
     * 房屋套次-第一套
     */
    public static final String FWTC_ONE = "1";

    /**
     * 房屋套次-其他套
     */
    public static final String FWTC_QT = "9";

    /**
     * 缴款方式-线上缴费
     */
    public static final String JKFS_XSJF = "2";

    /**
     * 特殊业务配置-配置类型(流程多选)
     */
    public static final Integer TSYWPZ_PZLX_LC = 2;


    /**
     * 特殊业务配置-配置类型(数据库字典项多选)
     */
    public static final Integer TSYWPZ_PZLX_SJZDDX = 3;

    /**
     * 特殊业务配置-配置类型(数据库字典项单选)
     */
    public static final Integer TSYWPZ_PZLX_SJZD = 4;

    /**
     * 特殊业务配置-配置类型(自定义字典项多选)
     */
    public static final Integer TSYWPZ_PZLX_ZDYZDDX = 5;

    /**
     * 特殊业务配置-配置类型(自定义字典项单选)
     */
    public static final Integer TSYWPZ_PZLX_ZDYZD = 6;

    /**
     * 特殊业务配置-配置类型(数组字符串)
     */
    public static final Integer TSYWPZ_PZLX_ARR = 8;


    /**
     * 节点自定义字典
     */
    public static final Map<String, String> JDZDMAP = new HashMap<>();

    // 静态代码块
    static {
        initAllConstantVariable();
    }

    private static void initAllConstantVariable() {
        JDZDMAP.put("sl", "受理");
        JDZDMAP.put("dbzz", "登簿制证");
        JDZDMAP.put("db", "登簿");
        JDZDMAP.put("sh", "审核");
        JDZDMAP.put("sz", "缮证");
        JDZDMAP.put("cs", "初审");
        JDZDMAP.put("hd", "核定");
        JDZDMAP.put("fs", "复审");
        JDZDMAP.put("fz", "发证");
        JDZDMAP.put("fh", "复核");
    }

    /**************************************电子证照相关常量****************************************/
    public static final String STATUS_SUCCESS = "0";
    public static final String GYFS = "gyfs";
    public static final String QLLX = "qllx";
    public static final String ZSID = "zsid";

    /**
     * 不动产数据(非存量过渡数据)产权证号标识
     */
    public static final String BDC_BDCQZH_BS = "不动产";

    /**
     * 是否注销原权利 1 注销
     */
    public static final Integer ZXYQL_ZX = 1;

    /**
     * 税务更新类型-先删除后插入（重新生成）
     */
    public static final String SW_GXLX_CXSC = "1";


    /**
     *  税务更新类型-根据纳税人识别号更新税务信息
     */
    public static final String SW_GXLX_UPDATE = "2";

    /**
     * 税务更新类型-有值更新无值插入
     */
    public static final String SW_GXLX_INSERT_UPDATE = "3";




    /**
     * 土地的BDCLX
     */
    public static final String BDCLX_TD_DM ="1";

    /**
     * 信息补录参数中文
     */
    public static final String XXBL_PARAMCH = "paramCha";
    /**
     * 信息补录日志参数：记录操作后的信息
     */
    public static final String XXBL_AFTER = "after";
    /**
     * 信息补录日志参数：记录操作前的信息, 用于日志回溯
     */
    public static final String XXBL_BEFORE = "before";
    /**
     * 信息补录日志参数：记录操作的改变
     */
    public static final String XXBL_CHANGE = "change";

    /**
     * 信息补录日志参数：记录操作信息
     */
    public static final String XXBL = "XXBL";

    /**
     * 婚姻状况：已婚
     */
    public static final String HYZK_YH_MC = "已婚";
}
