package cn.gtmap.realestate.common.core.service.rest.register;

import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * *
 *
 * @author <a href="mailto:zhangwentao@gtmap.cn>zhangwentao</a>"
 * @version 1.0, 2018/12/27
 * @description 审核登簿工作流rest服务接口
 */
public interface RegisterWorkflowRestService {
    /**
     * @param processInsId    工作流实例id
     * @param currentUserName 当前账户
     * @author <a href ="mailto:songhaowen@gtmap.cn">songhaowen</a>
     * @description 登簿时更新当前项目（现势）和原项目（历史）的登簿信息以及权属状态
     */
    @RequestMapping(value = "/realestate-register/rest/v1.0/dbxx/dbxxAndQszt", method = RequestMethod.POST)
    void updateBdcDbxxAndQsztSyncQj(@RequestParam(value = "processInsId") String processInsId, @RequestParam(value = "currentUserName") String currentUserName);

    /**
     * @param processInsId 工作流实例ID
     * @author <a href="mailto:zhangwentao@gtmap.cn">zhangwentao</a>
     * @description 登簿退回登簿信息和权属状态
     */
    @RequestMapping(value = "/realestate-register/rest/v1.0/dbxx/dbxxAndQszt", method = RequestMethod.DELETE)
    void revertBdcDbxxAndQsztSyncQj(@RequestParam(value = "processInsId") String processInsId);

    /**
     * @param gzlslid 工作流实例ID
     * @param syncQj  是否同步权籍
     * @author <a href="mailto:zhangwentao@gtmap.cn">zhangwentao</a>
     * @description 退回登簿信息和权属状态，调用端可控制是否更新权籍信息
     */
    @RequestMapping(value = "/realestate-register/rest/v1.0/dbxx/dbxxAndQszt/{gzlslid}", method = RequestMethod.PUT)
    void revertBdcDbxxAndQsztSyncQj(@PathVariable(value = "gzlslid") String gzlslid, @RequestParam(value = "syncQj") boolean syncQj);

    /**
     * @param processInsId    工作流实例ID
     * @param currentUserName 当前用户名
     * @author <a href="mailto:shaoliyao@gtmap.cn">shaoliyao</a>
     * @description 登簿时更新部分解封解压的规则例外审核状态
     */
    @RequestMapping(value = "/realestate-register/rest/v1.0/dbxx/updateBdcGzlwShzt", method = RequestMethod.POST)
    void updateBdcGzlwShzt(@RequestParam(value = "processInsId") String processInsId, @RequestParam(value = "currentUserName") String currentUserName);


    /**
     * @param processInsId 工作流实例ID
     * @param qszt         权属状态
     * @author <a href="mailto:zhangwentao@gtmap.cn">zhangwentao</a>
     * @description 更新原注销权利的登簿信息和权属状态
     */
    @RequestMapping(value = "/realestate-register/rest/v1.0/workflow/dbxx/yzxql", method = RequestMethod.PUT)
    void updateYzxqlDbxxAndQszt(@RequestParam(value = "processInsId") String processInsId, @RequestParam(value = "qszt") Integer qszt);
    /**
     * @author  <a href="mailto:zhuyong@gtmap.cn">zhuyong</a>
     * @param   processInsId 工作流实例ID
     * @description  更新案件状态为2已完成状态
     */
    @RequestMapping(value = "/realestate-register/rest/v1.0/workflow/dbxx/ajzt", method = RequestMethod.PUT)
    void changeAjzt(@RequestParam(value = "processInsId") String processInsId);

    /**
     * @author <a href="mailto:bianwen@gtmap.cn">bianwen</a>
     * @param processInsId 工作流实例ID
     * @description 同步权籍不动产单元状态(不包含锁定)
     */
    @RequestMapping(value = "/realestate-register/rest/v1.0/dbxx/qjzt", method = RequestMethod.PUT)
    void synQjBdcdyzt(@RequestParam("processInsId") String processInsId);

    /**
     * @author <a href="mailto:bianwen@gtmap.cn">bianwen</a>
     * @param processInsId
     * @return
     * @description 同步权籍基本信息
     */
    @RequestMapping(value = "/realestate-register/rest/v1.0/dbxx/qjjbxx", method = RequestMethod.PUT)
    void synQjJbxx(@RequestParam("processInsId") String processInsId);

    /**
     * @param processInsId
     * @return void
     * @author <a href ="mailto:songhaowen@gtmap.cn">songhaowen</a>
     * @description 合并 同步权籍基本信息和不动产单元状态（不包含锁定）服务
     */
    @RequestMapping(value = "/realestate-register/rest/v1.0/dbxx/qjjbxxAndBdcdyzt", method = RequestMethod.POST)
    void synQjJbxxAndBdcdyzt(@RequestParam(name = "processInsId") String processInsId);
}
