package cn.gtmap.realestate.common.core.service.rest.register;

import cn.gtmap.realestate.common.core.dto.building.BatchBdcdyhSyncZtRequestDTO;
import cn.gtmap.realestate.common.core.dto.register.BdcdyZtDTO;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * *
 *
 * @author <a href="mailto:zhangwentao@gtmap.cn>zhangwentao</a>"
 * @version 1.0, 2019/4/17
 * @description 不动产单元状态rest服务
 */
public interface BdcdyZtRestService {
    /**
     * @param bdcdyh 不动产单元号
     * @return BdcdyZtDTO 不动产单元状态
     * @author <a href="mailto:zhangwentao@gtmap.cn">zhangwentao</a>
     * @description 查询不动产单元状态
     */
    @RequestMapping(value = "/realestate-register/rest/v1.0/bdcdyzt/{bdcdyh}", method = RequestMethod.GET)
    BdcdyZtDTO queryBdcdyZt(@PathVariable(name = "bdcdyh") String bdcdyh);

    /**
     * @param bdcdyList 不动产单元号List
     * @return List<BdcdyZtDTO> 不动产单元状态
     * @author <a href="mailto:zhangwentao@gtmap.cn">zhangwentao</a>
     * @description 批量查询不动产单元状态
     */
    @RequestMapping(value = "/realestate-register/rest/v1.0/bdcdyzt/list", method = RequestMethod.POST)
    List<BdcdyZtDTO> queryBdcdyZtList(@RequestBody List<String> bdcdyList);

    /**
     * @author <a href="mailto:lisongtao@gtmap.cn">lisongtao</a>
     * @param bdcdyList 不动产单元号List
     * @return void
     * @description 同步BDCDYH状态
     */
    @RequestMapping(value = "/realestate-register/rest/v1.0/bdcdyzt/sync", method = RequestMethod.PUT)
    void syncBdcdyZtByBdcdyh(@RequestBody List<String> bdcdyList);

    /**
     * @author <a href="mailto:liyinqiao@gtmap.cn">liyinqiao</a>
     * @param bdcdyhList
     * @return cn.gtmap.realestate.common.core.dto.building.BatchBdcdyhSyncZtRequestDTO
     * @description 根据BDCDYH查询状态数量
     */
    @PutMapping("/realestate-register/rest/v1.0/bdcdyzt/listwithnum")
    BatchBdcdyhSyncZtRequestDTO queryBdcdyZtByBdcdyh(@RequestBody List<String> bdcdyhList);

    /**
     * @param gzlslid 工作流实例ID
     * @return List<String> 需要操作的不动产单元信息
     * @author <a href="mailto:zhangwentao@gtmap.cn">zhangwentao</a>
     * @description 查询当前流程需要更新权籍的不动产单元号
     */
    @RequestMapping(value = "/realestate-register/rest/v1.0/bdcdyzt/{gzlslid}/bdcdyh/syncQj", method = RequestMethod.GET)
    List<String> querySyncQjBdcdyh(@PathVariable(value = "gzlslid") String gzlslid);
}
