package cn.gtmap.realestate.common.core.service.rest.register;

import cn.gtmap.realestate.common.core.domain.BdcDldmSyqxGxDO;
import cn.gtmap.realestate.common.core.domain.BdcZdDsfzdgxDO;
import cn.gtmap.realestate.common.core.vo.accept.ui.TreeNodeVO;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * @author <a href ="mailto:songhaowen@gtmap.cn">songhaowen</a>
 * @version 1.3, 2018/12/29
 * @description 不动产字典服务
 */
public interface BdcZdRestService {
    /**
     * @param
     * @return  Map<String, List<Map>>
     * @author <a href ="mailto:songhaowen@gtmap.cn">songhaowen</a>
     * @description 获取所有字典
     */
    @RequestMapping(value = "/realestate-register/rest/v1.0/bdcZd/list", method = RequestMethod.GET)
    Map<String, List<Map>> listBdcZd();

    /**
     * @param zdmc 字段名称
     * @return List<Map>
     * @author <a href ="mailto:songhaowen@gtmap.cn">songhaowen</a>
     * @description 根据字段名称获取字典项
     */
    @RequestMapping(value = "/realestate-register/rest/v1.0/bdcZd/{zdmc}", method = RequestMethod.GET)
    List<Map> queryBdcZd(@PathVariable(name = "zdmc") String zdmc);

    /**
     * @param entity
     * @return
     * @author <a href ="mailto:songhaowen@gtmap.cn">songhaowen</a>
     * @description 字典项代码转名称
     */
    @RequestMapping(value = "/realestate-register/rest/v1.0/bdcZd/convertEntityToMc", method = RequestMethod.POST)
    Object convertEntityToMc(@RequestBody Object entity);
    /**
     * @param entity
     * @return
     * @author <a href ="mailto:songhaowen@gtmap.cn">songhaowen</a>
     * @description 字典项名称转代码
     */
    @RequestMapping(value = "/realestate-register/rest/v1.0/bdcZd/convertEntityToDm", method = RequestMethod.POST)
    Object convertEntityToDm(@RequestBody Object entity);

    /**
     * @param convertMap
     * @return
     * @author <a href ="mailto:songhaowen@gtmap.cn">songhaowen</a>
     * @description 转换map中的字典项代码为名称
     */
    @RequestMapping(value = "/realestate-register/rest/v1.0/bdcZd/convertMapToMc", method = RequestMethod.POST)
    Map convertMapToMc(@RequestBody Map convertMap);

    /**
     * @param convertMap
     * @return
     * @author <a href ="mailto:songhaowen@gtmap.cn">songhaowen</a>
     * @description 转换map中的字典项名称为代码
     */
    @RequestMapping(value = "/realestate-register/rest/v1.0/bdcZd/convertMapToDm", method = RequestMethod.POST)
    Map convertMapToDm(@RequestBody Map convertMap);

    @RequestMapping(value = "/realestate-register/rest/v1.0/dldmSyqxGx/{xmid}", method = RequestMethod.GET)
    BdcDldmSyqxGxDO queryDldmSyqxGx(@PathVariable(name = "xmid") String xmid);

    /**
     * @param
     * @return
     * @author <a href ="mailto:songhaowen@gtmap.cn">songhaowen</a>
     * @description 保存字典信息
     */
    @RequestMapping(value = "/realestate-register/rest/v1.0/bdcZd/save", method = RequestMethod.POST)
    int saveBdcZdxx(@RequestBody String json,
                    @RequestParam(name = "className") String className, @RequestParam(name = "action") String action);

    /**
     * 查询第三方系统与登记系统字典项值对照关系
     *
     * @param bdcZdDsfzdgxDO bdcZdDsfzdgxDO
     * @return BdcZdDsfzdgxDO BdcZdDsfzdgxDO
     * @author <a href="mailto:huangjian@gtmap.cn">huangjian</a>
     */
    @PostMapping("/realestate-register/rest/v1.0/bdcZd/dsfZdgx")
    BdcZdDsfzdgxDO dsfZdgx(@RequestBody BdcZdDsfzdgxDO bdcZdDsfzdgxDO);

    /**
     * 查询数据字典的中国省市区县的树形结构数据
     *
     * @author: <a href="mailto:yaoyi@gtmap.cn">yaoyi</a>
     * @param: [] 无参数
     * @return: List<TreeNodeVO> 树形结构的List<TreeNode>
     */
    @GetMapping("/realestate-register/rest/v1.0/bdcZd/zgssqx")
    List<TreeNodeVO> queryZdZgSsqx();
}
