package cn.gtmap.realestate.common.core.service.rest.register;

import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 不动产信息补录相关服务定义
 *
 * @author <a href="mailto:lixin1@gtmap.cn">lixin</a>
 * @version v1.0, 2019/6/11 18:22
 */
public interface BdcXxblZsRestService {

    /**
     * 补录更新不动产权证号(新增证书)
     * @param xmid xmid
     * @param bdcqzh bdcqzh 录入的不动产权证号，分别持证的逗号隔开，英文中文均可
     */
    @GetMapping(value = "/realestate-register/rest/v1.0/blxx/zs/bdcqzh")
    void updateBlBdcqzh(@RequestParam("xmid") String xmid, @RequestParam("bdcqzh") String bdcqzh);

    /**
     * 更新部分证书信息，同时处理冗余字段
     * 权利其他状况、附记以及不动产权证号
     *
     * @param zsid   证书 id
     * @param xmid   项目 id
     * @param qlqtzk 权利其他状况
     * @param bdcqzh 不动产权证号
     * @param fj     附记
     */
    @GetMapping(value = "/realestate-register/rest/v1.0/blxx/zs/bfxx")
    void updateBfZsxx(@RequestParam(value = "zsid") String zsid,
                      @RequestParam(value = "xmid") String xmid, @RequestParam(value = "qlqtzk") String qlqtzk,
                      @RequestParam(value = "bdcqzh") String bdcqzh, @RequestParam(value = "fj") String fj);

    /**
     * 更新证书锁定 <br>
     * <p>
     * 由于重新生成证书，所以先对于将原证书锁定信息关联到新生成的证书上 <br/>
     *
     * @param xmid xmid
     * @return 更新数据条数
     * @author <a href ="mailto:lixin1@gtmap.cn">lixin</a>
     */
    @PutMapping(value = "/realestate-register/rest/v1.0/blxx/zs/sd")
    int updateZssd(@RequestParam(value = "xmid") String xmid);
}
