package cn.gtmap.realestate.common.core.service.rest.register;

import cn.gtmap.realestate.common.core.domain.register.BdcQzxxDO;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @author <a href="mailto:huangjian@gtmap.cn">huangjian</a>
 * @version 1.0, 2019/12/23 17:12
 * @description 评价器签名接口
 */
public interface BdcQzxxRestService {

    /**
     * @param bdcQzxxDO bdcQzxxDO
     * @author <a href="mailto:zhuyong@gtmap.cn">zhuyong</a>
     * @description 保存签字信息
     */
    @PostMapping(value = "/realestate-register/rest/v1.0/qzxx/SaveQzxx")
    BdcQzxxDO insertBdcQzxx(@RequestBody BdcQzxxDO bdcQzxxDO);

    /**
     * @param bdcQzxxDO 评价器签字Do
     * @author <a href="mailto:gaolining@gtmap.cn">gaolining</a>
     * @description 更新不动产评价器签字信息
     */
    @PostMapping("/realestate-register/rest/v1.0/qzxx/UpdateQzxx")
    Integer updateBdcQzxx(@RequestBody BdcQzxxDO bdcQzxxDO);

     /**
      * 获取pdf文件，进行转码
      * @author <a href="mailto:huangjian@gtmap.cn">huangjian</a>
      * @param
      * @return
      */
    @GetMapping("/realestate-register/rest/v1.0/qzxx/pdfBase64")
    String pdfBase64(@RequestParam(name ="pdf") String pdf);

     /**
      * 查询签字信息
      * @author <a href="mailto:huangjian@gtmap.cn">huangjian</a>
      * @param  bdcQzxxDO bdcQzxxDO
      * @return BdcQzxxDO
      */
     @PostMapping("/realestate-register/rest/v1.0/qzxx/queryBdcQzxx")
    List<BdcQzxxDO> queryBdcQzxx(@RequestBody BdcQzxxDO bdcQzxxDO);
}
