package cn.gtmap.realestate.common.core.service.rest.inquiry;

import cn.gtmap.realestate.common.core.dto.inquiry.BdcFcdaDTO;
import cn.gtmap.realestate.common.core.dto.inquiry.BdcZfxxDTO;
import cn.gtmap.realestate.common.core.qo.inquiry.BdcZfxxQO;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @author <a href="mailto:zhuyong@gtmap.cn">zhuyong</a>
 * @version 1.0, 2019/7/8
 * @description 查询子系统：不动产住房信息查询服务接口定义
 */
public interface BdcZfxxCxRestService {
    /**
     * @author <a href="mailto:zhuyong@gtmap.cn">zhuyong</a>
     * @param bdcZfxxQO 查询参数
     * @return {List} 住房信息
     * @description 根据权利人名称、证件号查询房产信息（有房、无房查询）
     */
    @PostMapping("/realestate-inquiry/rest/v1.0/zfxx")
    List<BdcZfxxDTO> listBdcZfxxDTO(@RequestBody BdcZfxxQO bdcZfxxQO);

    /**
     * @author <a href="mailto:zhuyong@gtmap.cn">zhuyong</a>
     * @param bdcZfxxQO 查询参数
     * @return {List} 住房信息
     * @description （南通）根据权利人名称、证件号查询房产信息（有房、无房查询）
     */
    @PostMapping("/realestate-inquiry/rest/v1.0/nantong/zfxx")
    List<BdcZfxxDTO> listBdcNtZfxxDTO(@RequestBody BdcZfxxQO bdcZfxxQO);

    /**
     * @author <a href="mailto:zhuyong@gtmap.cn">zhuyong</a>
     * @param bdcdyh 不动产单元号
     * @return {List} 房产档案信息
     * @description 根据不动产单元号查询房产档案信息
     */
    @GetMapping("/realestate-inquiry/rest/v1.0/zfxx/{bdcdyh}/fcda")
    BdcFcdaDTO getBdcFcdaDTO(@PathVariable("bdcdyh")String bdcdyh);
}
