package cn.gtmap.realestate.common.core.service.rest.inquiry;

import cn.gtmap.realestate.common.core.domain.BdcYyDO;
import cn.gtmap.realestate.common.core.vo.inquiry.BdcYyVO;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @author <a href ="mailto:songhaowen@gtmap.cn">songhaowen</a>
 * @version 1.3, 2019-07-11
 * @description 查询子系统：不动产异议信息
 */
public interface BdcYyXxCxRestService {
    /**
     * @param pageable
     * @param bdcYyVOJson
     * @return Page<BdcYyDO>
     * @author <a href ="mailto:songhaowen@gtmap.cn">songhaowen</a>
     * @description 分页获取异议信息
     */
    @GetMapping(value = "/realestate-inquiry/rest/v1.0/bdcYyXx/page")
    Page<BdcYyVO> listBdcYyByPage(@RequestBody Pageable pageable,
                                  @RequestParam(name = "bdcYyVOJson", required = false) String bdcYyVOJson);

    /**
     * @param bdcYyVOJson
     * @return Page<BdcYyDO>
     * @author <a href ="mailto:songhaowen@gtmap.cn">songhaowen</a>
     * @description 获取异议信息 用于导出
     */
    @GetMapping(value = "/realestate-inquiry/rest/v1.0/bdcYyXx")
    List listBdcYy(@RequestParam(name = "bdcYyVOJson", required = false) String bdcYyVOJson);

    /**
     * @param
     * @return
     * @author <a href ="mailto:songhaowen@gtmap.cn">songhaowen</a>
     * @description 批量更新 异议
     */
    @PostMapping(value = "/realestate-inquiry/rest/v1.0/bdcYyXx")
    int updateBdcYy(@RequestBody List<BdcYyDO> bdcYyDOList);
}
