package cn.gtmap.realestate.common.core.service.rest.inquiry;

import cn.gtmap.realestate.common.core.domain.BdcSdqghDO;
import cn.gtmap.realestate.common.core.dto.inquiry.BdcSdqBlztRequestDTO;
import cn.gtmap.realestate.common.core.dto.inquiry.BdcSdqBlztResponseDTO;
import cn.gtmap.realestate.common.core.qo.init.BdcSdqywQO;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:zhuyong@gtmap.cn">zhuyong</a>
 * @version 1.0, 2018/11/8
 * @description 查询不动产信息接口
 */
public interface BdcSdqghRestService {

    /**
     *@author <a href="mailto:chenyucheng@gtmap.cn">chenyucheng</a>
     *@param bdcSdqghDO
     *@description 插入水电气过户实体
     */
    @PostMapping(path = "/realestate-inquiry/rest/v1.0/insertSdqgh")
    Integer  insertSdqghDO(@RequestBody BdcSdqghDO bdcSdqghDO);

    /**
     * 通过传入参数返回不动产项目水电气业务实体集合
     * @author  <a href="mailto:chenyucheng@gtmap.cn">chenyucheng</a>
     * @param   bdcSdqywQO 水电气业务查询qo
     * @return  {List} 水电气业务实体集合
     * @description 通过传入参数返回水电气业务实体集合
     */
    @PostMapping(path = "/realestate-inquiry/rest/v1.0/sdqghxx/list")
    List<BdcSdqghDO> querySdqyw(@RequestBody BdcSdqywQO bdcSdqywQO);

    /**
     * 水过户
     * @author  <a href="mailto:chenyucheng@gtmap.cn">chenyucheng</a>
     * @param   processInsId
     * @description 登簿成功后把水的业务过户
     */
    @PostMapping(path = "/realestate-inquiry/rest/v1.0/sdqgh/shuigh/{processInsId}/{isOneWebSource}")
    boolean shuigh(@PathVariable("processInsId") String processInsId,
                   @PathVariable("isOneWebSource") String isOneWebSource);

    /**
     * 电过户
     * @author  <a href="mailto:chenyucheng@gtmap.cn">chenyucheng</a>
     * @param   processInsId
     * @description 登簿成功后把电的业务过户
     */
    @PostMapping(path = "/realestate-inquiry/rest/v1.0/sdqgh/diangh/{processInsId}/{isOneWebSource}")
    boolean diangh(@PathVariable("processInsId") String processInsId,
                   @PathVariable("isOneWebSource") String isOneWebSource);

    /**
     * 气过户
     * @author  <a href="mailto:chenyucheng@gtmap.cn">chenyucheng</a>
     * @param   processInsId
     * @description 登簿成功后把气的业务过户
     */
    @PostMapping(path = "/realestate-inquiry/rest/v1.0/sdqgh/qigh/{processInsId}/{isOneWebSource}")
    boolean qigh(@PathVariable("processInsId") String processInsId,
                 @PathVariable("isOneWebSource") String isOneWebSource);


    /**
     * 获取一窗打印的登记库的 水电气业务数据
     * @param processInsId
     * @return
     */
    @GetMapping(path = "/realestate-inquiry/rest/v1.0/sdqgh/SdqSqbYwDy/{processInsId}")
    List<Map> getSdqSqbYwDyData(@PathVariable("processInsId") String processInsId);

    /**
     *@author <a href="mailto:chenyucheng@gtmap.cn">chenyucheng</a>
     *@param bdcSdqBlztRequestDTO
     *@description 更新水电气过户业务状态
     */
    @PostMapping(path = "/realestate-inquiry/rest/v1.0/sdqgh/updateSdqgh")
    BdcSdqBlztResponseDTO updateSdqBlzt(@RequestBody BdcSdqBlztRequestDTO bdcSdqBlztRequestDTO);
}
