package cn.gtmap.realestate.common.core.service.rest.inquiry;

import cn.gtmap.realestate.common.core.domain.BdcDysdDO;
import cn.gtmap.realestate.common.core.domain.BdcZssdDO;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @author <a href ="mailto:songhaowen@gtmap.cn">songhaowen</a>
 * @version 1.3, 2019-08-07
 * @description 不动产 锁定、解锁业务类
 */
public interface BdcSdRestService {
    /**
     * @param
     * @return
     * @author <a href ="mailto:songhaowen@gtmap.cn">songhaowen</a>
     * @description 锁定不动产单元
     */
    @PostMapping(value = "/realestate-inquiry/rest/v1.0/bdcdy/sd")
    int sdBdcdy(@RequestBody List<BdcDysdDO> bdcDysdDOList);

    /**
     * @param
     * @return
     * @author <a href ="mailto:songhaowen@gtmap.cn">songhaowen</a>
     * @description 锁定不动产权证
     */
    @PostMapping(value = "/realestate-inquiry/rest/v1.0/bdczs/sd")
    int sdBdczs(@RequestBody List<BdcZssdDO> bdcZssdDOList,
                @RequestParam("sdyy") String sdyy);

    /**
     * 更新证书锁定 <br>
     * <p>
     * 由于重新生成证书，所以先对于将原证书锁定信息关联到新生成的证书上 <br/>
     *
     * @param bdcZssdDOList 证书锁定集合
     * @return 更新数据条数
     * @author <a href ="mailto:lixin1@gtmap.cn">lixin</a>
     */
    @PutMapping(value = "/realestate-inquiry/rest/v1.0/bdczs/sd")
    int updateSdZs(@RequestBody List<BdcZssdDO> bdcZssdDOList);

    /**
     * @param
     * @return
     * @author <a href ="mailto:songhaowen@gtmap.cn">songhaowen</a>
     * @description 解锁不动产单元
     */
    @PostMapping(value = "/realestate-inquiry/rest/v1.0/bdcdy/js")
    int jsBdcdy(@RequestBody List<BdcDysdDO> bdcDysdDOList,
                @RequestParam("jsyy") String jsyy);

    /**
     * @param
     * @return
     * @author <a href ="mailto:songhaowen@gtmap.cn">songhaowen</a>
     * @description 解锁不动产权证
     */
    @PostMapping(value = "/realestate-inquiry/rest/v1.0/bdczs/js")
    int jsBdczs(@RequestBody List<BdcZssdDO> bdcZssdDOList,
                @RequestParam("sdyy") String sdyy);

    /**
     * @param
     * @return
     * @author <a href ="mailto:songhaowen@gtmap.cn">songhaowen</a>
     * @description 查询不动产单元锁定
     */
    @PostMapping(value = "/realestate-inquiry/rest/v1.0/bdcdy")
    List<BdcDysdDO> queryBdcdySd(@RequestBody BdcDysdDO bdcDysdDO);

    /**
     * @param
     * @return
     * @author <a href ="mailto:songhaowen@gtmap.cn">songhaowen</a>
     * @description 查询不动产证书锁定
     */
    @PostMapping(value = "/realestate-inquiry/rest/v1.0/bdczs")
    List<BdcZssdDO> queryBdczsSd(@RequestBody BdcZssdDO bdcZssdDO);

    /**
     * @param bdcDysdDO
     * @return
     * @author <a href ="mailto:songhaowen@gtmap.cn">songhaowen</a>
     * @description 保存不动产单元锁定备注
     */
    @PostMapping(value = "/realestate-inquiry/rest/v1.0/bdcdy/bz")
    int saveBdcdysdBz(@RequestBody BdcDysdDO bdcDysdDO);

    /**
     * @param bdcZssdDO
     * @return
     * @author <a href ="mailto:songhaowen@gtmap.cn">songhaowen</a>
     * @description 保存不动产证书锁定备注
     */
    @PostMapping(value = "/realestate-inquiry/rest/v1.0/bdczs/bz")
    int saveBdczssdBz(@RequestBody BdcZssdDO bdcZssdDO);

    /**
     * @param bdcZssdDOList 证书锁定集合
     * @return {int} 删除证书数目
     * @author <a href="mailto:lixin1@gtmap.cn">lixin</a>
     * @description 删除证书锁定信息 <br>
     * 删除补录修改流程时需要同步删除证书锁定信息。
     */
    @PostMapping(value = "/realestate-inquiry/rest/v1.0/bdczs/sd/blsc")
    int deleteBdczsSd(@RequestBody List<BdcZssdDO> bdcZssdDOList);
}
