package cn.gtmap.realestate.common.core.service.rest.inquiry;

import cn.gtmap.realestate.common.core.dto.inquiry.BdcPlcxDTO;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @author <a href="mailto:chenyucheng@gtmap.cn">chenyucheng</a>
 * @version 1.0  2019-11-15
 * @description 批量查询
 */
public interface BdcPlcxRestService {

    /**
     * 分页查询房产信息
     *
     * @param pageable
     * @param bdcPlcxQOJson
     * @return org.springframework.data.domain.Page<cn.gtmap.realestate.common.core.dto.inquiry.BdcPlcxDTO                                                               ;>
     * @author <a href="mailto:chenyucheng@gtmap.cn">chenyucheng</a>
     */
    @GetMapping(value = "/realestate-inquiry/rest/v1.0/bdcPlcx/page")
    Page<BdcPlcxDTO> listBdcPlcxByPage(@RequestBody Pageable pageable,
                                     @RequestParam(name = "bdcPlcxQOJson", required = false) String bdcPlcxQOJson);

}
