package cn.gtmap.realestate.common.core.service.rest.inquiry;

import cn.gtmap.realestate.common.core.dto.inquiry.*;
import cn.gtmap.realestate.common.core.qo.init.BdcXmQO;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author <a href="mailto:zhuyong@gtmap.cn">zhuyong</a>
 * @version 1.0, 2019/11/02
 * @description (南通)不动产房产证明相关处理接口
 */
public interface BdcNtFczmRestService {
    /**
     * @author <a href="mailto:zhuyong@gtmap.cn">zhuyong</a>
     * @param bdcFczmDTO 房产证明信息
     * @return {String} redis key
     * @description 保存（南通）房产证明信息至缓存
     */
    @PostMapping("/realestate-inquiry/rest/v1.0/print/nantong/fcda")
    String saveNtFcdaXx(@RequestBody BdcFczmDTO bdcFczmDTO);

    /**
     * @author <a href="mailto:zhuyong@gtmap.cn">zhuyong</a>
     * @param bdcFczmDTOList 房产证明信息
     * @return {String} redis key
     * @description 批量保存（南通）房产证明信息至缓存
     */
    @PostMapping("/realestate-inquiry/rest/v1.0/print/nantong/fcda/pl")
    String saveNtFcdaXxPl(@RequestBody List<BdcFczmDTO> bdcFczmDTOList);

    /**
     * @author <a href="mailto:zhuyong@gtmap.cn">zhuyong</a>
     * @param key  redis key
     * @return {String} FR3打印的XML数据
     * @description 获取（南通）房产证明打印信息
     */
    @GetMapping("/realestate-inquiry/rest/v1.0/print/nantong/fcda/{key}/xml")
    String getNtFczmXml(@PathVariable("key") String key);

    /**
     * @author <a href="mailto:zhuyong@gtmap.cn">zhuyong</a>
     * @param key redis key
     * @return {String} FR3打印的XML数据
     * @description 获取（南通）房产证明批量打印信息
     */
    @GetMapping("/realestate-inquiry/rest/v1.0/print/nantong/fcda/pl/{key}/xml")
    String getNtFczmPlXml(@PathVariable("key") String key);

    /**
     * @author <a href="mailto:zhuyong@gtmap.cn">zhuyong</a>
     * @param key redis key
     * @return {String} FR3打印的XML数据
     * @description 获取（南通）有房无房证明打印信息
     */
    @GetMapping("/realestate-inquiry/rest/v1.0/print/nantong/yfwfzm/{key}/xml")
    String getNtYfwfzmXml(@PathVariable("key") String key);

    /**
     * @author <a href="mailto:zhuyong@gtmap.cn">zhuyong</a>
     * @param bdcDyzmDTOList 选中的记录数据
     * @return {String} 保存的Redis key
     * @description （南通）将要打印的抵押证明参数信息保存至Redis中
     */
    @PostMapping("/realestate-inquiry/rest/v1.0/print/nantong/dyzm/csxx")
    BdcDyzmDyDTO saveDyzmCsxxToRedis(@RequestBody List<BdcDyzmDTO> bdcDyzmDTOList);

    /**
     * @author <a href="mailto:zhuyong@gtmap.cn">zhuyong</a>
     * @param key redis key
     * @return {String} 打印的数据内容
     * @description （南通）获取抵押证明打印对应的XML数据
     */
    @GetMapping("/realestate-inquiry/rest/v1.0/print/nantong/dyzm/{key}/xml")
    String getPrintXmlOfDyzm(@PathVariable("key")String key);

    /**
     * @author <a href="mailto:zhuyong@gtmap.cn">zhuyong</a>
     * @param xmid 项目ID
     * @return {String} 房产出售时间
     * @description 获取房产出售时间
     */
    @GetMapping("/realestate-inquiry/rest/v1.0/zhcx/nantong/fczm/fdcq/cssj")
    String getFdcqCssj(@RequestParam("xmid") String xmid);


    /**
     * @author <a href="mailto:zhuyong@gtmap.cn">zhuyong</a>
     * @param list 打印请求参数
     * @return {BdcQszmDyDTO} 缓存的Redis KEY以及查询号信息
     * @description 缓存权属证明不动产单元号到redis
     */
    @PostMapping("/realestate-inquiry/rest/v1.0/print/nantong/qszm/bdcdyh")
    BdcQszmDyDTO saveNtFcdaBdcdyhToRedis(@RequestBody List<BdcQszmQO> list);

    /**
     * @author <a href="mailto:zhuyong@gtmap.cn">zhuyong</a>
     * @param key redis key
     * @return {String} XML数据
     * @description 获取打印权属证明的XML数据
     */
    @GetMapping("/realestate-inquiry/rest/v1.0/print/nantong/qszm/{key}/xml")
    String getPrintXmlOfQszm(@PathVariable("key") String key);
}
