package cn.gtmap.realestate.common.core.service.rest.inquiry;

import cn.gtmap.realestate.common.core.dto.inquiry.BdcDyaDTO;
import cn.gtmap.realestate.common.core.qo.inquiry.BdcDyaQo;
import cn.gtmap.realestate.common.core.qo.inquiry.count.DyaTjQO;
import cn.gtmap.realestate.common.core.vo.inquiry.count.BdcDyaTjVO;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author <a href="mailto:huangjian@gtmap.cn">huangjian</a>
 * @version 1.0, 2019/9/3 13:53
 * @description 抵押查询服务
 */
public interface BdcDyaCxRestService {
    /**
     * 分页查询抵押不动产单元
     *
     * @param pageable
     * @param bdcDyaQOJson
     * @return org.springframework.data.domain.Page<cn.gtmap.realestate.common.core.dto.inquiry.BdcDyaDTO>
     * @author <a href="mailto:huangjian@gtmap.cn">huangjian</a>
     */
    @GetMapping(value = "/realestate-inquiry/rest/v1.0/bdcdya/page")
    Page<BdcDyaDTO> listBdcDyaByPage(@RequestBody Pageable pageable,
                                     @RequestParam(name = "bdcDyaQOJson", required = false) String bdcDyaQOJson);

    /**
     * @param dyaTjQO 抵押统计查询QO
     * @return List<BdcDyaTjVO>
     * @author <a href="mailto:zhangwentao@gtmap.cn">zhangwentao</a>
     * @description 获取抵押统计月报信息
     */
    @PostMapping(value = "/realestate-inquiry/rest/v1.0/bdcDya/dyaTjMonth")
    List<BdcDyaTjVO> getDyaTjMonth(@RequestBody DyaTjQO dyaTjQO);

    /**
     * @param dyaTjQO 抵押统计查询QO
     * @return List<BdcDyaTjVO>
     * @author <a href="mailto:zhangwentao@gtmap.cn">zhangwentao</a>
     * @description 获取抵押统计日报信息
     */
    @PostMapping(value = "/realestate-inquiry/rest/v1.0/bdcDya/dyaTjDay")
    List<BdcDyaTjVO> getDyaTjDay(@RequestBody DyaTjQO dyaTjQO);

    /**
     * @param redisKey 保存redis的key值
     * @param dylx     抵押统计的打印类型
     * @return 打印xml信息
     * @author <a href="mailto:zhangwentao@gtmap.cn">zhangwentao</a>
     * @description 获取抵押统计的xml信息
     */
    @GetMapping(value = "/realestate-inquiry/rest/v1.0/print/dyaTj/{dylx}/xml")
    String getDyaTjXml(@RequestParam(value = "redisKey") String redisKey, @PathVariable(value = "dylx") String dylx);

    /**
     * @param dylx         打印类型
     * @param listDyatjStr 打印统计信息
     * @return 保存到redis的key值
     * @author <a href="mailto:zhangwentao@gtmap.cn">zhangwentao</a>
     * @description 保存抵押提交信息到redis
     */
    @PostMapping(value = "/realestate-inquiry/rest/v1.0/dyaTjxx/redis/{dylx}")
    String saveDyatjXxToRedis(@PathVariable(value = "dylx") String dylx, @RequestParam(value = "listDyatjStr") String listDyatjStr);

    /**
     * 抵押分页查询-标准版：查询抵押权表
     *
     * @param bdcDyaQOJson 抵押查询QO
     * @param pageable     pageable
     * @return 抵押查询结果
     * @author <a href="mailto:huangjian@gtmap.cn">huangjian</a>
     */
    @GetMapping(value = "/realestate-inquiry/rest/v1.0/bdcdya/listStandardDyaByPage")
    Page<BdcDyaDTO> listStandardDyaByPage(@RequestBody Pageable pageable,
                                          @RequestParam(name = "bdcDyaQOJson", required = false) String bdcDyaQOJson);

    /**
     * 抵押分页查询-标准版：查询抵押权表
     *
     * @param  bdcDyaQO 抵押查询QO
     * @return 抵押查询结果
     * @author <a href="mailto:hanyi@gtmap.cn">hanyi</a>
     */
    @PostMapping(value = "/realestate-inquiry/rest/v1.0/bdcdya/listStandardDya")
    List listStandardDya(@RequestBody BdcDyaQo bdcDyaQO);
}
