package cn.gtmap.realestate.common.core.service.rest.init;

import cn.gtmap.realestate.common.core.domain.BdcXtJgDO;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 不动产系统银行配置查询接口
 *
 * @author <a href="mailto:lixin1@gtmap.cn">lixin</a>
 * @version 1.0, 2019/05/02
 */
public interface BdcXtJgRestService {
    /**
     * 查询全部的银行配置信息
     *
     * @return List<BdcXtJgDO>
     * @author <a href="mailto:lixin1@gtmap.cn">lixin</a>
     */
    @GetMapping(path = "/init/rest/v1.0/xtjg/list")
    List<BdcXtJgDO> listBdcXtJg(@RequestParam("jglb") Integer jglb);

    /**
     * 根据 yhid 查询出银行信息
     *
     * @return BdcXtJgDO
     * @author <a href="mailto:lixin1@gtmap.cn">lixin</a>
     */
    @GetMapping(path = "/init/rest/v1.0/xtjg")
    BdcXtJgDO queryJgByJgmc(@RequestParam("jgmc") String jgmc);

    /**
     * @param
     * @return
     * @author <a href ="mailto:songhaowen@gtmap.cn">songhaowen</a>
     * @description 获取按月结算 银行结构
     */
    @GetMapping(path = "/init/rest/v1.0/xtjg/list/ayjs")
    List<BdcXtJgDO> listAyjsBdcXtJg();
	
	/**
	 * @param
	 * @return
	 * @author <a href ="mailto:hanyi@gtmap.cn">hanyi</a>
	 * @description 获取按月结算 银行结构
	 */
	@GetMapping(path = "/init/rest/v1.0/xtjg/list/ayjs/yhmc")
	List<BdcXtJgDO> listAyjsBdcXtJgYhmc(@RequestParam("yhmc")String yhmc);
}
