package cn.gtmap.realestate.common.core.service.rest.init;

import cn.gtmap.realestate.common.core.domain.*;
import cn.gtmap.realestate.common.core.dto.init.BdcCfxxPageResponseDTO;
import cn.gtmap.realestate.common.core.dto.init.BdcQlPageResponseDTO;
import cn.gtmap.realestate.common.core.dto.init.BdcXmDTO;
import cn.gtmap.realestate.common.core.dto.init.BdcXmZhxxDTO;
import cn.gtmap.realestate.common.core.qo.init.*;
import cn.gtmap.realestate.common.core.vo.accept.ui.BdcXmFwzkfbVO;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:zhuyong@gtmap.cn">zhuyong</a>
 * @version 1.0, 2018/11/8
 * @description 查询不动产信息接口
 */
public interface BdcXmRestService {
    /**
     * 通过传入参数返回不动产项目信息
     * @author  <a href="mailto:zhuyong@gtmap.cn">zhuyong</a>
     * @param   bdcXmQO 不动产项目
     * @return  {List} 不动产项目信息
     * @description 通过传入参数返回不动产项目信息
     */
    @PostMapping(path = "/init/rest/v1.0/xmxx/list")
    List<BdcXmDO> listBdcXm(@RequestBody BdcXmQO bdcXmQO);

    /**
     * 通过传入bdcdyh返回对象的现势产权项目信息
     * @author  <a href="mailto:lisongtao@gtmap.cn">lisongtao</a>
     * @param   bdcdyhList 不动产单元号集合
     * @return  {List} 不动产项目信息
     * @description 通过传入bdcdyh返回对象的现势产权项目信息
     */
    @PostMapping(path = "/init/rest/v1.0/xmxx/xscq/list")
    List<BdcXmDO> listBdcXmXscq(@RequestBody List<String> bdcdyhList);

    /**
     * @author <a href="mailto:liyinqiao@gtmap.cn">liyinqiao</a>
     * @param bdcXmQO
     * @return java.util.List<cn.gtmap.realestate.common.core.domain.BdcXmDO>
     * @description 根据办结日期 查询XM的BDCDYH
     */
    @PostMapping(path = "/init/rest/v1.0/xmxx/listbybjrq")
    List<BdcXmDO> listBdcXmByBjrq(@RequestBody BdcXmQO bdcXmQO);

    /**
     * 更新不动产项目信息bdcQlPageByPageJson
     *@author <a href="mailto:yanzhenkun@gtmap.cn">yanzhenkun</a>
     *@param bdcXmDO 不动产项目
     *@description 更新不动产项目信息
     */
    @PutMapping(path = "/init/rest/v1.0/xmxx")
    int updateBdcXm(@RequestBody BdcXmDO bdcXmDO);

    /**
     * 选择不动产权利页面后台服务
     *@author <a href="mailto:yanzhenkun@gtmap.cn">yanzhenkun</a>
     * @param pageable
     * @param bdcQlQoStr  bdcQlQo的json串
     *@return Page<BdcQlPageResponseDTO> 分页查询对象
     *@description 选择不动产权利页面后台服务
     */
    @PostMapping(path = "/init/rest/v1.0/xmxx/page")
    Page<BdcQlPageResponseDTO> bdcQlPageByPageJson(Pageable pageable,
                                                   @RequestParam(name = "bdcQlQoStr",required = false) String bdcQlQoStr);


    /**
     * 选择不动产权利页面后台服务(非分页)
     *@author <a href="mailto:lisongtao@gtmap.cn">lisongtao</a>
     * @param bdcQlQO  bdcQlQo
     *@return List<BdcQlPageResponseDTO> 查询对象集合
     *@description 选择不动产权利页面后台服务
     */
    @PostMapping(path = "/init/rest/v1.0/xmxx/bdcql/list")
    List<BdcQlPageResponseDTO> bdcQlList(@RequestBody(required = false) BdcQlQO bdcQlQO);

    /**
     * 选择查封信息页面后台服务(不分页)
     *@author <a href="mailto:lisongtao@gtmap.cn">lisongtao</a>
     * @param bdcCfQO
     *@return List<BdcCfxxPageResponseDTO> 查询对象集合
     *@description 选择查封信息页面后台服务
     */
    @PostMapping(path = "/init/rest/v1.0/cfxx/list")
    List<BdcCfxxPageResponseDTO> bdcCfxxList(@RequestBody(required = false) BdcCfQO bdcCfQO);


    /**
     * 选择查封信息页面后台服务
     *@author <a href="mailto:lisongtao@gtmap.cn">lisongtao</a>
     * @param pageable
     * @param bdcCfQoStr
     *@return Page<BdcCfxxPageResponseDTO> 分页查询对象
     *@description 选择查封信息页面后台服务
     */
    @PostMapping(path = "/init/rest/v1.0/cfxx/page")
    Page<BdcCfxxPageResponseDTO> bdcCfxxPageByPageJson(Pageable pageable,
                                                       @RequestParam(name = "bdcCfQoStr",required = false) String bdcCfQoStr);


   /**
    *根据项目id获取开关实例数据
    *@author <a href="mailto:lisongtao@gtmap.cn">lisongtao</a>
    *@param xmid 项目id
    *@return BdcCshFwkgSlDO 实例信息
    *@description
    */
    @GetMapping(path = "/init/rest/v1.0/{xmid}/fwkgsl")
    BdcCshFwkgSlDO queryFwkgsl(@PathVariable("xmid") String xmid);

    /**
     *@author <a href="mailto:yanzhenkun@gtmap.cn">yanzhenkun</a>
     *@param bdcXmLsgxDOList
     *@return
     *@description 外联证书接口
     */
    @PutMapping(path = "/init/rest/v1.0/bdcxmlsgx/batchInsert")
    void batchInsertBdcXmLsgx(@RequestBody List<BdcXmLsgxDO> bdcXmLsgxDOList);


    /**
     * 获得组合的所有项目信息
     * @param xmid
     * @return List<BdcXmZhxxDTO>
     * @author <a href="mailto:lisongtao@gtmap.cn">lisongtao</a>
     * @description 获得组合的所有项目信息
     */
    @GetMapping("/init/rest/v1.0/zhxmxx/{xmid}/list")
    List<BdcXmZhxxDTO> queryBdcXmZhxx(@PathVariable("xmid") String xmid);


    /**
     * 根据工作流实例ID获取挂接附件的项目  空的话用gzlslid去获取
     *@author <a href="mailto:lisongtao@gtmap.cn">lisongtao</a>
     *@param gzlslid
     *@return List<BdcXmDO>
     *@description 根据工作流实例ID获取挂接附件的项目  空的话用gzlslid去获取
     */
    @GetMapping(path = "/init/rest/v1.0/fileXm/{gzlslid}/list")
    List<BdcXmDO> queryFileXmList(@PathVariable("gzlslid") String gzlslid);

    /**
     * 根据受理编号和证件号获取项目信息
     *@author <a href="mailto:lisongtao@gtmap.cn">lisongtao</a>
     *@param slbh
     *@param zjh
     *@return List<Map>
     *@description 根据受理编号和证件号获取项目信息
     */
    @GetMapping(path = "/init/rest/v1.0/xmxx/{slbh}/{zjh}/list")
    List<Map> queryBjjdXx(@PathVariable("slbh") String slbh, @PathVariable("zjh") String zjh);

    /**
     * 根据产权证号获取项目信息
     *
     * @param bdcqzh 不动产权证号
     * @param qszt   权属状态
     * @return List<Map>
     * @author <a href="mailto:lixin1@gtmap.cn">lixin</a>
     */
    @GetMapping(path = "/init/rest/v1.0/xmxx/bdcqz/qszt/xmid")
    List<Map> queryBdcxmByCqzh(@RequestParam("bdcqzh") String bdcqzh, @RequestParam("qszt") String qszt);



    /**
     * 根据 djxl 获取登记原因配置
     * @param djxl 登记小类
     * @return  List<BdcDjxlDjyyGxDO>
     * @author <a href="mailto:lisongtao@gtmap.cn">lisongtao</a>
     */
    @GetMapping(path = "/init/rest/v1.0/djyy/{djxl}")
    List<BdcDjxlDjyyGxDO> queryDjxlDjyy(@PathVariable("djxl") String djxl);

    /**
     * 根据 gzlslid 确定项目类型
     * @param gzlslid 工作流实例 id
     * @author <a href="mailto:lisongtao@gtmap.cn">lisongtao</a>
     * @return 1:普通  2：组合  3：批量  4:批量组合
     */
    @GetMapping(path = "/init/rest/v1.0/xmxx/{gzlslid}/xmlx")
    int makeSureBdcXmLx(@PathVariable("gzlslid") String gzlslid);

    /**
     * 根据 gzlslid 确定项目类型
     * @param gzlslid 工作流实例 id
     * @author <a href="mailto:lisongtao@gtmap.cn">lisongtao</a>
     * @return 1:普通  2：组合  3：批量  4:批量组合
     */
    @PostMapping(path = "/init/rest/v1.0/xmxx/xmlx")
    int makeSureBdcXmLx(@RequestBody List<BdcXmDO> list);

    /**
     * 通过传入参数返回不动产项目部分信息
     * @author  <a href="mailto:lisongtao@gtmap.cn">lisongtao</a>
     * @param   gzlslid 工作流实例id
     * @return  {List} 不动产项目部分信息
     * @description 通过传入参数返回不动产项目部分信息
     */
    @GetMapping(path = "/init/rest/v1.0/bfxmxx/{gzlslid}/gzlslid/list")
    List<BdcXmDTO> listBdcXmBfxxByGzlslid(@PathVariable("gzlslid")String gzlslid);

    /**
     * 通过传入参数返回不动产项目部分信息
     * @author  <a href="mailto:lisongtao@gtmap.cn">lisongtao</a>
     * @param   gzlslid 工作流实例id
     * @return  {List} 不动产项目部分信息
     * @description 通过传入参数返回不动产项目部分信息
     */
    @GetMapping(path = "/init/rest/v1.0/bfxmxx/{slbh}/slbh/list")
    List<BdcXmDTO> listBdcXmBfxxBySlbh(@PathVariable("slbh")String slbh);

    /**
     * 通过传入工作流实例id返回受理编号
     * @author  <a href="mailto:lisongtao@gtmap.cn">lisongtao</a>
     * @param   gzlslid 工作流实例id
     * @return  受理编号
     * @description 通过传入工作流实例id返回受理编号
     */
    @GetMapping(path = "/init/rest/v1.0/lc/slbh/{gzlslid}")
    String querySlbh(@PathVariable("gzlslid")String gzlslid);

    /**
     * 通过传入受理编号返回工作流实例id
     * @author  <a href="mailto:lisongtao@gtmap.cn">lisongtao</a>
     * @param   slbh 受理编号
     * @return  工作流实例id
     * @description 通过传入受理编号返回工作流实例id
     */
    @GetMapping(path = "/init/rest/v1.0/lc/gzlslid/{slbh}")
    String queryGzlslid(@PathVariable("slbh")String slbh);

    /**
     * 通过传入工作流实例ID和权利类型获取登记原因
     * @author  <a href="mailto:lisongtao@gtmap.cn">lisongtao</a>
     * @param   gzlslid 工作流实例ID
     * @param   qllx 权利类型
     * @return  登记原因
     * @description 通过传入工作流实例ID和权利类型获取登记原因
     */
    @GetMapping(path = "/init/rest/v1.0/lc/djyy/{gzlslid}")
    String queryDjyy(@PathVariable("gzlslid")String gzlslid,@RequestParam(value = "qllx",required = false)Integer qllx);

    /**
     *根据工作流实例ID获取开关实例数据
     *@author <a href="mailto:lisongtao@gtmap.cn">lisongtao</a>
     *@param gzlslid 工作流实例ID
     *@return List<BdcCshFwkgSlDO> 实例集合
     *@description
     */
    @GetMapping(path = "/init/rest/v1.0/{gzlslid}/fwkgsl/list")
    List<BdcCshFwkgSlDO> queryFwkgslByGzlslid(@PathVariable("gzlslid") String gzlslid);

    /**
     * @param bdcDjxxUpdateQO 更新对象
     * @return 更新数量
     * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
     * @description  批量更新项目
     */
    @PostMapping(path = "/init/rest/v1.0/xmxx/jsonStr")
    int updateBatchBdcXm(@RequestBody BdcDjxxUpdateQO bdcDjxxUpdateQO);


    /**
     * @param bdcQlQoStr 查询对象
     * @return 分页信息
     * @author <a href="mailto:gaolining@gtmap.cn">gaolining</a>
     * @description  分页查询原权利信息
     */
    @PostMapping(path = "/init/rest/v1.0/xmxx/bdcyql/list/page")
    Page<BdcQlPageResponseDTO> listBdcYqlByPage(Pageable pageable,
                                                @RequestParam(name = "bdcQlQoStr",required = false) String bdcQlQoStr);

    /**
     * @param bdcXmDO
     * @return List<BdcXmFwzkfbVO> 查询结果
     * @author <a href="mailto:yanjiaqiang@gtmap.cn">yanjiaqiang</a>
     * @description 查询抵押物清单
     */
    @RequestMapping(value = "/init/rest/v1.0/fwzkbPage", method = RequestMethod.POST)
    List<BdcXmFwzkfbVO> listFwzkbByPage(@RequestBody BdcXmDO bdcXmDO);

    /**
     * @param bdcXmDO
     * @return List<BdcXmFwzkfbVO> 查询结果
     * @author <a href="mailto:yanjiaqiang@gtmap.cn">yanjiaqiang</a>
     * @description 查询原抵押物清单
     */
    @RequestMapping(value = "/init/rest/v1.0/yxmfwzkbPage", method = RequestMethod.POST)
    List<BdcXmFwzkfbVO> listYxmFwzkbByPage(@RequestBody BdcXmDO bdcXmDO);


    /**
     * @param bdcFdcqDO
     * @author <a href="mailto:chenyucheng@gtmap.cn">chenyucheng</a>
     * @description 同步qlrmc到fdcq tdsyqr
     */
    @PutMapping("/init/rest/v1.0/updateBdcFdcq")
    Integer updateBdcFdcq(@RequestBody BdcFdcqDO bdcFdcqDO);

    /**
     * @param xmid
     * @return List<String> 项目集合
     * @author <a href="mailto:lisongtao@gtmap.cn">lisongtao</a>
     * @description 查询当前证书项目的涉及的项目集合
     */
    @GetMapping(value = "/init/rest/v1.0/{xmid}/zsxm/list")
    List<String> queryZsxmList(@PathVariable("xmid") String xmid);

    /**
     * @param bdcXmDO 项目信息
     * @return int 更新数量
     * @author <a href="mailto:zhangwentao@gtmap.cn">zhangwentao</a>
     * @description 更新证书相关的项目的部分权利其他状况
     */
    @PutMapping(value = "/init/rest/v1.0/xmxx/bfqlqtzk")
    int updateBdcZsXmBfqlqtzk(@RequestBody BdcXmDO bdcXmDO);

    /**
     * @return List<String> 用途集合
     * @author <a href="mailto:chenyucheng@gtmap.cn">chenyucheng</a>
     * @description 查询要默认主房的用途集合
     */
    @RequestMapping(value = "/init/rest/v1.0/xmxx/getZfYt", method = RequestMethod.GET)
    List<String> getZfYt();

   /**
    * @param gzlslid 工作流实例ID
    * @return List<BdcZdFwytDO>
    * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
    * @description 根据工作流实例ID获取房屋用途字典项
    */
    @GetMapping(path = "/init/rest/v1.0/zdfwyt/{gzlslid}")
    List<BdcZdFwytDO> queryZdFwytByGzlslid(@PathVariable("gzlslid") String gzlslid);

    /**
     * @param
     * @return
     * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
     * @description 根据当前工作流实例ID查询原项目
     */
    @PostMapping(value = "/init/rest/v1.0/xmxx/listYxm")
    List<BdcXmDO> listYxmByGzlslid(@RequestBody BdcXmLsgxDO bdcXmLsgxDO,@RequestParam(name = "gzlslid") String gzlslid,@RequestParam(name = "djxl",required = false) String djxl);
}
