package cn.gtmap.realestate.common.core.service.rest.exchange;

import cn.gtmap.realestate.common.core.domain.exchange.MessageModel;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:liyinqiao@gtmap.cn">liyinqiao</a>
 * @version 1.0  2019-04-19
 * @description 自动上报 服务
 */
public interface NationalAccessRestService {

    /**
     * @author <a href="mailto:liyinqiao@gtmap.cn">liyinqiao</a>
     * @param xmid 项目主键
     * @return void
     * @description 根据项目主键汇交当前项目
     */
    @GetMapping("/realestate-exchange/rest/v1.0/access/xmid")
    void autoAccessByXmid(@RequestParam(name = "xmid") String xmid);

    /**
     * @author <a href="mailto:wangzijie@gtmap.cn">wangzijie</a>
     * @param xmidList 项目主键集合
     * @return void
     * @description 根据项目主键集合汇交当前项目
     */
    @GetMapping("/realestate-exchange/rest/v1.0/access/xmidlist")
    void autoAccessByXmidList(@RequestParam(name = "xmidList") List<String> xmidList);

    /**
     * @author <a href="mailto:liyinqiao@gtmap.cn">liyinqiao</a>
     * @param xmid 项目主键
     * @return void
     * @description 根据项目主键汇交同一流程所有项目
     */
    @GetMapping("/realestate-exchange/rest/v1.0/access/all/xmid")
    void autoAccessAllXmByXmid(@RequestParam(name = "xmid") String xmid);

    /**
     * @author <a href="mailto:liyinqiao@gtmap.cn">liyinqiao</a>
     * @param processInsId 工作流主键
     * @return void
     * @description 根据工作流主键上交
     */
    @GetMapping("/realestate-exchange/rest/v1.0/access/proccessid")
    void autoAccessByProcessInsId(@RequestParam(name = "processInsId") String processInsId);

    /**
     * @author <a href="mailto:liyinqiao@gtmap.cn">liyinqiao</a>
     * @param messageModel 汇交数据实体
     * @return boolean 汇交结果
     * @description 汇交数据实体
     */
    @PostMapping("/realestate-exchange/rest/v1.0/access/model")
    boolean autoAccessByMessageModel(@RequestBody MessageModel messageModel);

    /**
     * @author <a href="mailto:liyinqiao@gtmap.cn">liyinqiao</a>
     * @param date yyyy-mm-dd格式日期
     * @return void
     * @description 手动触发上报登簿日志
     */
    @GetMapping("/realestate-exchange/rest/v1.0/access/dbrz")
    boolean accessLog(String date);
	
	/**
	 * @author <a href="mailto:hanyi@gtmap.cn">hanyi</a>
	 * @param date yyyy-mm-dd格式日期
	 * @return void
	 * @description (南通)手动触发上报登簿日志
	 */
	@GetMapping("/realestate-exchange/rest/v1.0/access/dbrz/nt")
	boolean accessLogNt(@RequestParam(name = "date") String date,@RequestParam("qxdm") String qxdm);
	
	/**
	 * @author <a href="mailto:hanyi@gtmap.cn">hanyi</a>
	 * @param id
	 * @return Map
	 * @description (南通)获取登簿日志明细信息
	 */
	@GetMapping("/realestate-exchange/rest/v1.0/access/dbrz/mx")
	Map<String, Object> dbrzMx(@RequestParam(name = "id")String id);
	
}
