package cn.gtmap.realestate.common.core.service.rest.exchange;

import cn.gtmap.realestate.common.core.dto.exchange.sdqgh.dian.sqgh.request.HefeiDianSqghRequestDTO;
import cn.gtmap.realestate.common.core.dto.exchange.sdqgh.dian.sqgh.response.HefeiDianSqghResponseDTO;
import cn.gtmap.realestate.common.core.dto.exchange.sdqgh.dian.yhcx.request.HefeiDianYhcxRequestDTO;
import cn.gtmap.realestate.common.core.dto.exchange.sdqgh.dian.yhcx.response.HefeiDianYhcxResponseDTO;
import cn.gtmap.realestate.common.core.dto.exchange.sdqgh.dian.yhcx.response.HefeiDianYhcxResponseData;
import cn.gtmap.realestate.common.core.dto.exchange.sdqgh.ranqi.ghcx.request.HefeiRanqiGhcxRequestDTO;
import cn.gtmap.realestate.common.core.dto.exchange.sdqgh.ranqi.ghcx.response.HefeiRanqiGhcxResponseDTO;
import cn.gtmap.realestate.common.core.dto.exchange.sdqgh.ranqi.sqgh.request.HefeiRanqiSqghRequestDTO;
import cn.gtmap.realestate.common.core.dto.exchange.sdqgh.ranqi.sqgh.response.HefeiRanqiSqghResponseDTO;
import cn.gtmap.realestate.common.core.dto.exchange.sdqgh.shui.shuifeicx.request.HefeiShuifeicxRequestDTO;
import cn.gtmap.realestate.common.core.dto.exchange.sdqgh.shui.shuifeicx.response.HefeiShuifeicxResponseDTO;
import cn.gtmap.realestate.common.core.dto.exchange.sdqgh.shui.sqgh.request.HefeiShuiSqghRequestDTO;
import cn.gtmap.realestate.common.core.dto.exchange.sdqgh.shui.sqgh.request.HefeiShuiSqghRequestTransferPerson;
import cn.gtmap.realestate.common.core.dto.exchange.sdqgh.shui.sqgh.response.HefeiShuiSqghResponseDTO;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @author <a href="mailto:liyinqiao@gtmap.cn">liyinqiao</a>
 * @version 1.0  2019-11-20
 * @description 合肥 水、 电、 气 相关接口
 */
public interface HefeiSdqRestService {

    /**
     * @author <a href="mailto:liyinqiao@gtmap.cn">liyinqiao</a>
     * @param requestDTO
     * @return cn.gtmap.realestate.common.core.dto.exchange.sdqgh.ranqi.ghcx.response.HefeiRanqiGhcxResponseDTO
     * @description 燃气 过户查询
     */
    @PostMapping("/realestate-exchange/rest/v1.0/hefeisdq/ranqi/ghcx")
    HefeiRanqiGhcxResponseDTO ranqiGhcx(@RequestBody HefeiRanqiGhcxRequestDTO requestDTO);


    /**
     * @author <a href="mailto:liyinqiao@gtmap.cn">liyinqiao</a>
     * @param requestDTO
     * @return cn.gtmap.realestate.common.core.dto.exchange.sdqgh.ranqi.sqgh.response.HefeiRanqiSqghResponseDTO
     * @description  燃气申请过户
     */
    @PostMapping("/realestate-exchange/rest/v1.0/hefeisdq/ranqi/sqgh")
    HefeiRanqiSqghResponseDTO ranqiSqgh(@RequestBody HefeiRanqiSqghRequestDTO requestDTO);



    /**
     * @author <a href="mailto:liyinqiao@gtmap.cn">liyinqiao</a>
     * @param requestDTO
     * @return cn.gtmap.realestate.common.core.dto.exchange.sdqgh.dian.yhcx.response.HefeiDianYhcxResponseData
     * @description 电 过户查询
     */
    @PostMapping("/realestate-exchange/rest/v1.0/hefeisdq/dian/ghcx")
    HefeiDianYhcxResponseDTO dianGhcx(@RequestBody HefeiDianYhcxRequestDTO requestDTO);


    /**
     * @author <a href="mailto:liyinqiao@gtmap.cn">liyinqiao</a>
     * @param requestDTO
     * @return cn.gtmap.realestate.common.core.dto.exchange.sdqgh.dian.sqgh.response.HefeiDianSqghResponseDTO
     * @description 电 申请过户
     */
    @PostMapping("/realestate-exchange/rest/v1.0/hefeisdq/dian/sqgh")
    HefeiDianSqghResponseDTO dianSqgh(@RequestBody HefeiDianSqghRequestDTO requestDTO);

    /**
     * @author <a href="mailto:liyinqiao@gtmap.cn">liyinqiao</a>
     * @param requestDTO
     * @return cn.gtmap.realestate.common.core.dto.exchange.sdqgh.shui.sqgh.response.HefeiShuiSqghResponseDTO
     * @description 水 申请过户
     */
    @PostMapping("/realestate-exchange/rest/v1.0/hefeisdq/shui/sqgh")
    HefeiShuiSqghResponseDTO shuiSqgh(@RequestBody HefeiShuiSqghRequestTransferPerson requestDTO);


    /**
     * @author <a href="mailto:liyinqiao@gtmap.cn">liyinqiao</a>
     * @param requestDTO
     * @return cn.gtmap.realestate.common.core.dto.exchange.sdqgh.shui.shuifeicx.response.HefeiShuifeicxResponseDTO
     * @description 水费查询
     */
    @PostMapping("/realestate-exchange/rest/v1.0/hefeisdq/shui/shuifeicx")
    HefeiShuifeicxResponseDTO shuifeiCx(@RequestBody HefeiShuifeicxRequestDTO requestDTO);
}
