package cn.gtmap.realestate.common.core.service.rest.exchange;

import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author <a href="mailto:hanyi@gtmap.cn">hanyi</a>
 * @version 1.0, 2020/3/27
 * @description 登簿日志上报接口
 */
public interface AccessLogRestService {

    /**
     * @author <a href="mailto:hanyi@gtmap.cn">hanyi</a>
     * @param ywh
     * @param logType
     * @return java.lang.String
     * @description 查看响应报文
     */
    @PostMapping(value = "/queryXybw")
    String queryXybw(@RequestParam(name = "ywh") String ywh,@RequestParam(name = "logType", required = false) String logType);

    /**
     * @author <a href="mailto:hanyi@gtmap.cn">hanyi</a>
     * @param ywh
     * @param logType
     * @return java.lang.String
     * @description 查看业务报文
     */
    @PostMapping(value = "/queryJrbw")
    String queryJrbw(@RequestParam(name = "ywh") String ywh,@RequestParam(name = "logType", required = false) String logType);

    /**
     * @param xmid
     * @author <a href="mailto:hanyi@gtmap.cn">hanyi</a>
     * @description 上报日志台账数据校验
     */
    @GetMapping(value = "/checkDataByXmid")
    public Boolean checkDataByXmid(@RequestParam(name = "xmid")String xmid);

    /**
     * @param xmidList 包含xmid和type（国家上报或省级上报）
     * @param logType
     * @return
     * @author <a href="mailto:hanyi@gtmap.cn">hanyi</a>
     * @description 获取响应报文
     */
    @GetMapping(value = "/getAccessResponse")
    public String getAccessResponse(@RequestParam(name = "xmidList") List<String> xmidList,
                                    @RequestParam(name = "logType") String logType);
}
