package cn.gtmap.realestate.common.core.service.rest.certificate;

import cn.gtmap.realestate.common.core.domain.BdcXmDO;
import cn.gtmap.realestate.common.core.dto.certificate.BdcEcertificateConfigDTO;
import cn.gtmap.realestate.common.core.dto.realestate_e_certificate.DzzzResponseModel;
import org.springframework.web.bind.annotation.*;

import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * *
 *
 * @author <a href="mailto:zhangwentao@gtmap.cn>zhangwentao</a>"
 * @version 1.0, 2019/12/17
 * @description 电子证照rest服务
 */
public interface ECertificateRestService {
    /**
     * @author <a href="mailto:zhangwentao@gtmap.cn">zhangwentao</a>
     * @description 获取电子证照的访问token值
     */
    @RequestMapping(value = "/realestate-certificate/rest/v1.0/eCertificate/token", method = RequestMethod.GET)
    String getECertificateToken();

    /**
     * @param processInsId 工作流实例ID
     * @author <a href="mailto:zhangwentao@gtmap.cn">zhangwentao</a>
     * @description 创建电子证照
     */
    @RequestMapping(value = "/realestate-certificate/rest/v1.0/eCertificate", method = RequestMethod.POST)
    void createECertificate(@RequestParam(value = "processInsId") String processInsId, @RequestParam(value = "currentUserName") String currentUserName);

    /**
     * @param bdcXmDO 项目ID
     * @return List<DzzzResponseModel   <   Map>>
     * @author <a href="mailto:zhangwentao@gtmap.cn">zhangwentao</a>
     * @description 生成项目的电子证照，返回电子证照请求结果
     */
    @RequestMapping(value = "/realestate-certificate/rest/v1.0/eCertificate/xm", method = RequestMethod.POST)
    List<DzzzResponseModel<Map>> createXmECertificate(@RequestBody BdcXmDO bdcXmDO, @RequestParam(value = "currentUserName") String currentUserName);

    /**
     * @param processInsId 工作流实例ID
     * @author <a href="mailto:zhangwentao@gtmap.cn">zhangwentao</a>
     * @description 注销原项目电子证照
     */
    @RequestMapping(value = "/realestate-certificate/rest/v1.0/eCertificate", method = RequestMethod.PUT)
    void cancelYxmECertificate(@RequestParam(value = "processInsId") String processInsId, @RequestParam(value = "currentUserName") String currentUserName);

    /**
     * @param bdcXmDO         当前项目信息
     * @param currentUserName 当前请求的用户信息
     * @return List<DzzzResponseModel < Map>> 电子证照请求结果
     * @author <a href="mailto:zhangwentao@gtmap.cn">zhangwentao</a>
     * @description 注销当前项目的电子证照信息
     */
    @RequestMapping(value = "/realestate-certificate/rest/v1.0/eCertificate/xm/zx", method = RequestMethod.POST)
    List<DzzzResponseModel> cancelXmECertificate(@RequestBody BdcXmDO bdcXmDO, @RequestParam(value = "currentUserName") String currentUserName);

    /**
     * @param bdcXmDO         当前项目信息
     * @param currentUserName 当前请求的用户信息
     * @return List<DzzzResponseModel < Map>> 电子证照请求结果
     * @author <a href="mailto:zhangwentao@gtmap.cn">zhangwentao</a>
     * @description 作废当前项目的电子证照信息
     */
    @RequestMapping(value = "/realestate-certificate/rest/v1.0/eCertificate/xm/zf", method = RequestMethod.POST)
    List<DzzzResponseModel> zfXmECertificate(@RequestBody BdcXmDO bdcXmDO, @RequestParam(value = "currentUserName") String currentUserName);

    /**
     * @param bdcXmDO         当前流程的项目信息
     * @param currentUserName 当前请求的用户信息
     * @return
     * @author <a href="mailto:zhangwentao@gtmap.cn">zhangwentao</a>
     * @description 根据当前项目注销原项目的电子证照信息
     */
    @RequestMapping(value = "/realestate-certificate/rest/v1.0/eCertificate/yxm", method = RequestMethod.POST)
    void cancelYxmECertificate(@RequestBody BdcXmDO bdcXmDO, @RequestParam(value = "currentUserName") String currentUserName);

    /**
     * @author <a href="mailto:zhangwentao@gtmap.cn">zhangwentao</a>
     * @param zzbs 证照标识
     * @return Base64字符串值
     * @description 下载电子证照，返回Base64字符串值
     */
    @RequestMapping(value = "/realestate-certificate/rest/v1.0/eCertificate/download", method = RequestMethod.GET)
    String getECertificateContent(@RequestParam(value = "zzbs", required = false) String zzbs);

    /**
     * @param gzlslid 工作流实例ID
     * @param zzbs 证照标识
     * @param fileName 上传大云的电子证照文件名
     * @return Base64字符串值
     * @author <a href="mailto:zhangwentao@gtmap.cn">zhangwentao</a>
     * @description 获取电子证照，并上传文件中心
     */
    @RequestMapping(value = "/realestate-certificate/rest/v1.0/eCertificate/upload/{gzlslid}", method = RequestMethod.GET)
    void uploadECertificateContent(@PathVariable(value = "gzlslid") String gzlslid, @RequestParam(value = "zzbs") String zzbs, @RequestParam(value = "fileName") String fileName) throws IOException;


    /**
     * @param gzlslid 工作流实例ID
     * @param bdcqzh  不动产权证号
     * @return 字符窜
     * @author <a href="mailto:lisongtao@gtmap.cn">lisongtao</a>
     * @description 获取电子证照上传文件中心的附件的下载路径
     */
    @RequestMapping(value = "/realestate-certificate/rest/v1.0/eCertificate/file/{gzlslid}", method = RequestMethod.POST)
    String getECertificateFilePath(@PathVariable(value = "gzlslid") String gzlslid, @RequestParam(value = "bdcqzh") String bdcqzh);

    /**
     * 获取电子证照相关配置
     *
     * @return BdcEcertificateConfigDTO 电子证照配置实体
     * @Date 2020/2/27
     * @author <a href="mailto:huangjian@gtmap.cn">huangjian</a>
     */
    @GetMapping(value = "/realestate-certificate/rest/v1.0/eCertificate/queryconfig")
    BdcEcertificateConfigDTO queryConfig();

    /**
     * @param zsidList 证书ID信息
     * @return List<DzzzResponseModel   <   Map>> 查询结果信息
     * @author <a href="mailto:zhangwentao@gtmap.cn">zhangwentao</a>
     * @description 查询证书的电子证照状态
     */
    @RequestMapping(value = "/realestate-certificate/rest/v1.0/eCertificate/zzzt", method = RequestMethod.POST)
    List<DzzzResponseModel<List<Map>>> checkZzzt(@RequestBody List<String> zsidList);
}
