package cn.gtmap.realestate.common.core.service.rest.certificate;

import cn.gtmap.realestate.common.core.domain.BdcXmDO;
import cn.gtmap.realestate.common.core.domain.BdcZsDO;
import cn.gtmap.realestate.common.core.dto.certificate.BdcBdcqzhDTO;
import cn.gtmap.realestate.common.core.dto.certificate.BdcZsQsztDTO;
import cn.gtmap.realestate.common.core.qo.certificate.BdcZsQO;
import cn.gtmap.realestate.common.core.vo.register.ui.BdcZsVO;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author <a href="mailto:zhuyong@gtmap.cn">zhuyong</a>
 * @version 1.0, 2018/11/14
 * @description 不动产证书业务服务接口定义
 */
public interface BdcZsRestService {

    /**
     * 从redis中获取保存的xmids
     * @param key
     * @return
     */
    @RequestMapping("/realestate-certificate/rest/v1.0/zs/xmZsyl/getAllXmids")
    List<String> getXmidsByKey(@RequestParam("key") String key);

    /**
     * @author  <a href="mailto:chenyucheng@gtmap.cn">chenyucheng</a>
     * @param  xmids 选中的记录数据
     * @return {String} 保存的Redis key
     * @description  证书附表的xmids，保存至Redis中
     */
    @PostMapping(value = "/realestate-certificate/rest/v1.0/zs/xmZsyl/fbyl")
    String saveListXmidsToRedis(@RequestParam("xmids") String xmids);


    /**
     * @author  <a href="mailto:zhuyong@gtmap.cn">zhuyong</a>
     * @param   zsid 证书ID
     * @return  {BdcZsDo} 不动产证书
     * @description 获取不动产权证书
     */
    @RequestMapping(value = "/realestate-certificate/rest/v1.0/zs/{zsid}", method = RequestMethod.GET)
    BdcZsDO queryBdcZs(@PathVariable(value = "zsid") String zsid);

    /**
     * @param zsid 证书ID
     * @return List<BdcXmDO> 项目信息
     * @author <a href="mailto:zhangwentao@gtmap.cn">zhangwentao</a>
     * @description 获取当前证书相关的项目信息
     */
    @RequestMapping(value = "/realestate-certificate/rest/v1.0/zsXm/{zsid}", method = RequestMethod.GET)
    List<BdcXmDO> queryZsXmByZsid(@PathVariable(value = "zsid") String zsid);

    @RequestMapping(value = "/realestate-certificate/rest/v1.0/zs", method = RequestMethod.PATCH)
    int updateBdcZs(@RequestBody BdcZsDO bdcZsDO);

    /**
     * @author  <a href="mailto:zhuyong@gtmap.cn">zhuyong</a>
     * @param   xmid 项目ID
     * @return  {List} 不动产权证号信息集合
     * @description  生成单个项目不动产项目证书（明）号
     */
    @RequestMapping(value = "/realestate-certificate/rest/v1.0/zs/{xmid}/bdcqzh", method = RequestMethod.GET)
    List<BdcBdcqzhDTO> generateBdcqzh(@PathVariable("xmid")String xmid);

    /**
     * @author  <a href="mailto:zhuyong@gtmap.cn">zhuyong</a>
     * @param   processInsId 流程实例ID
     * @return  {List} 不动产权证号信息集合
     * @description  流程关联项目生成证书（明）号
     */
    @RequestMapping(value = "/realestate-certificate/rest/v1.0/zs/bdcqzh", method = RequestMethod.GET)
    void generateBdcqzhOfPro(@RequestParam("processInsId") String processInsId);


    /**
     * @param xmid 项目id
     * @return List<BdcZsDO>
     * @author <a href="mailto:bianwen@gtmap.cn">bianwen</a>
     * @description 获取不动产权证书列表
     */
    @RequestMapping(value = "/realestate-certificate/rest/v1.0/xm/{xmid}/zs", method = RequestMethod.GET)
    List<BdcZsDO> queryBdcZsByXmid(@PathVariable("xmid") String xmid);

    /**
     * @param bdcZsQO 证书查询对象
     * @return List<BdcZsDO> 不动产权证list
     * @author <a href="mailto:bianwen@gtmap.cn">bianwen</a>
     * @description 获取不动产权证书列表
     */
    @RequestMapping(value = "/realestate-certificate/rest/v1.0/zs/list", method = RequestMethod.POST)
    List<BdcZsDO> listBdcZs(@RequestBody BdcZsQO bdcZsQO);

    /**
     * @param bdcZsQO 证书查询对象
     * @return Integer 查询到的证书数量
     * @author <a href="mailto:zhangwentao@gtmap.cn">zhangwentao</a>
     * @description 根据条件查询证书，返回查询到的结果集
     */
    @RequestMapping(value = "/realestate-certificate/rest/v1.0/zs/num", method = RequestMethod.POST)
    Integer countBdcZs(@RequestBody BdcZsQO bdcZsQO);
    /**
     * @param bdcZsQO  证书查询对象
     * @param page 分页查询页数
     * @param size 分页查询行数
     * @param sort 分页查询排序
     * @return Page<BdcZsDO>
     * @author <a href="mailto:bianwen@gtmap.cn">bianwen</a>
     * @description 获取不动产权证书分页
     */
    @RequestMapping(value = "/realestate-certificate/rest/v1.0/zs/page", method = RequestMethod.POST)
    Page<BdcZsVO> bdcZsByPageJson(@RequestParam(name = "page") int page, @RequestParam(name = "size") int size, @RequestParam(name = "sort",required = false) Sort sort, @RequestBody BdcZsQO bdcZsQO);

    /**
     * @param bdcZsQO 证书查询QO
     * @author <a href="mailto:zhangwentao@gtmap.cn">zhangwentao</a>
     * @return　 List<String>　zsid列表
     * @description 依据条件查询zsid
     */
    @RequestMapping(value = "/realestate-certificate/rest/v1.0/zs/print/zsidList", method = RequestMethod.POST)
    List<String> queryZsid(@RequestBody BdcZsQO bdcZsQO);

    /**
     * @param gzlslid 工作流实例
     * @author <a href="mailto:zhangwentao@gtmap.cn">zhangwentao</a>
     * @return　 List<String>　zsid列表
     * @description 查询当前流程所有的zsid
     */
    @RequestMapping(value = "/realestate-certificate/rest/v1.0/zsid/{gzlslid}/list", method = RequestMethod.GET)
    List<String> queryGzlZsid(@PathVariable(name = "gzlslid") String gzlslid);

    /**
     * @param gzlslid 工作流实例ID
     * @param xmid
     * @return List<String>  zsid列表
     * @author <a href="mailto:zhangwentao@gtmap.cn">zhangwentao</a>
     * @description 获取当前工作流所有的证书类型
     */
    @RequestMapping(value = "/realestate-certificate/rest/v1.0/zslx/list", method = RequestMethod.GET)
    List<String> queryGzlZslx(@RequestParam(name = "gzlslid", required = false) String gzlslid, @RequestParam(name = "xmid", required = false) String xmid);

    /**
     * @param bdcZsQO 证书查询QO
     * @return BdcZsQsztDTO 证书状态DTO
     * @author <a href="mailto:zhangwentao@gtmap.cn">zhangwentao</a>
     * @description 查询证书的项目权属状态
     */
    @RequestMapping(value = "/realestate-certificate/rest/v1.0/zsQszt", method = RequestMethod.POST)
    List<BdcZsQsztDTO> queryBdcZsQszt(@RequestBody BdcZsQO bdcZsQO);

    /**
     * @param zsidList 需要更新的证书IDList
     * @param dyzt     打印状态（对应字典表 是否字典表）
     * @return 更新的数据量
     * @author <a href="mailto:zhangwentao@gtmap.cn">zhangwentao</a>
     * @description 更新证书的打印状态
     */
    @RequestMapping("/realestate-certificate/rest/v1.0/zs/dyzt/{dyzt}")
    int updateBdcZsDyzt(@RequestBody List<String> zsidList, @PathVariable(value = "dyzt") Integer dyzt);

    /**
     * 查询原项目的证书信息
     *<p>通过工作流实例ID查询原项目证书信息（去重）</p>
     * @author: <a href="mailto:yaoyi@gtmap.cn">yaoyi</a>
     * @param: gzlslid 工作流实例ID
     * @return: 原项目证书信息集合
     */
    @RequestMapping(value = "/realestate-certificate/rest/v1.0/zs/bdcqz/{gzlslid}", method = RequestMethod.GET)
    List<BdcZsDO> queryYxmBdcqzhByGzlslid(@PathVariable(value="gzlslid") String gzlslid);

    /**
     * @param bdcZsQO 证书查询对象
     * @return List<BdcZsDO> 原项目的证书信息
     * @author <a href="mailto:zhangwentao@gtmap.cn">zhangwentao</a>
     * @description 条件查询原项目的证书信息
     */
    @RequestMapping(value = "/realestate-certificate/rest/v1.0/zs/bdcqz/yxm", method = RequestMethod.POST)
    List<BdcZsDO> queryYxmZs(@RequestBody BdcZsQO bdcZsQO);
}
