package cn.gtmap.realestate.common.core.service.rest.building;

import cn.gtmap.realestate.common.core.domain.building.FwHsDO;
import cn.gtmap.realestate.common.core.dto.building.DjdcbFwhsResponseDTO;
import cn.gtmap.realestate.common.core.dto.building.FwHsHbZhsRequestDTO;
import cn.gtmap.realestate.common.core.dto.building.FwhsBatchUpdateRequestDTO;
import cn.gtmap.realestate.common.core.vo.building.BatchUpdateFwhsVO;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:liyinqiao@gtmap.cn">liyinqiao</a>
 * @version 1.0  2018-11-08
 * @description 房屋户室相关服务
 */
public interface FwHsRestService {

    /**
     * @param fwHsDO
     * @return cn.gtmap.realestate.common.core.domain.building.FwHsDO
     * @author <a href="mailto:wangzijie@gtmap.cn">wangzijie</a>
     * @description 新增户室服务
     */
    @PostMapping("/building/rest/v1.0/hs")
    FwHsDO insertFwHs(@RequestBody FwHsDO fwHsDO);

    /**
     * @param fwHsDO
     * @param updateNull true表示空字段更新，false，false表示空字段不更新
     * @return void
     * @author <a href="mailto:wangzijie@gtmap.cn">wangzijie</a>
     * @description 修改户室信息服务
     */
    @PutMapping("/building/rest/v1.0/hs")
    Integer updateFwHs(@RequestBody FwHsDO fwHsDO, @RequestParam(name = "updateNull", required = false) boolean updateNull);

    /**
     * @param fwHsIndex
     * @return void
     * @author <a href="mailto:wangzijie@gtmap.cn">wangzijie</a>
     * @description 根据主键删除户室信息
     */
    @DeleteMapping("/building/rest/v1.0/hs/{fwHsIndex}")
    Integer deleteHsByFwHsIndex(@PathVariable("fwHsIndex") String fwHsIndex);

    /**
     * @param bdcdyh
     * @return cn.gtmap.realestate.common.core.domain.building.FwHsDO
     * @author <a href="mailto:liyinqiao@gtmap.cn">liyinqiao</a>
     * @description 根据BDCDYH查询户室基本信息
     */
    @GetMapping("/building/rest/v1.0/hs/bdcdy/{bdcdyh}")
    FwHsDO queryFwhsByBdcdyh(@PathVariable("bdcdyh") String bdcdyh);


    /**
     * @param fwDcbIndex
     * @param fwHsIndexList
     * @return java.lang.Integer
     * @author <a href="mailto:wangzijie@gtmap.cn">wangzijie</a>
     * @description 修改房屋户室逻辑幢
     */
    @PutMapping("/building/rest/v1.0/hs/ljz")
    void updateFwHsLjz(@RequestParam(value = "fwHsIndexList", required = false) List<String> fwHsIndexList, @RequestParam(value = "fwDcbIndex", required = false) String fwDcbIndex);


    /**
     * @author <a href="mailto:liyinqiao@gtmap.cn">liyinqiao</a>
     * @param fcdah
     * @return java.util.List<cn.gtmap.realestate.common.core.domain.building.FwHsDO>
     * @description 根据FCDAH查询FWHS
     */
    @GetMapping("/building/rest/v1.0/hs/fcdah/{fcdah}")
    List<FwHsDO> listFwhsByFcdah(@PathVariable("fcdah") String fcdah);


    /**
     * @author <a href="mailto:liyinqiao@gtmap.cn">liyinqiao</a>
     * @param fwbm
     * @return java.util.List<cn.gtmap.realestate.common.core.domain.building.FwHsDO>
     * @description 根据FWBM 查询 FWHS
     */
    @GetMapping("/building/rest/v1.0/hs/fwbm/{fwbm}")
    List<FwHsDO> listFwhsByFwbm(@PathVariable("fwbm") String fwbm);


    /**
     * @author <a href="mailto:liyinqiao@gtmap.cn">liyinqiao</a>
     * @param fwDcbIndex
     * @return java.util.List<cn.gtmap.realestate.common.core.domain.building.FwHsDO>
     * @description 根据 fwDcbIndex 查询 FWHS
     */
    @GetMapping("/building/rest/v1.0/hs/fwdcbindex/{fwDcbIndex}")
    List<FwHsDO> listFwhsByFwDcbIndex(@PathVariable("fwDcbIndex") String fwDcbIndex);

    /**
     * @author <a href="mailto:liyinqiao@gtmap.cn">liyinqiao</a>
     * @param fwHsIndex
     * @return cn.gtmap.realestate.common.core.domain.building.FwHsDO
     * @description 根据主键查询房屋户室
     */
    @GetMapping("/building/rest/v1.0/hs/{fwHsIndex}")
    FwHsDO queryFwHsByFwHsIndex(@PathVariable("fwHsIndex") String fwHsIndex);


    /**
     * @author <a href="mailto:liyinqiao@gtmap.cn">liyinqiao</a>
     * @param pageable
     * @param paramJson
     * @return org.springframework.data.domain.Page<cn.gtmap.realestate.common.core.domain.building.FwHsDO>
     * @description
     */
    @PostMapping("/building/rest/v1.0/hs/listbypage")
    Page<FwHsDO> listFwHsByPageJson(@RequestBody Pageable pageable,
                                    @RequestParam(value = "paramJson", required = false) String paramJson);
    /**
     * @author <a href="mailto:liyinqiao@gtmap.cn">liyinqiao</a>
     * @param pageable
     * @param paramJson
     * @return Map
     * @description
     */
    @PostMapping("/building/rest/v1.0/hs/gl/listbypage")
    Page<Map> glListFwHsByPageJson(@RequestBody Pageable pageable,
                                   @RequestParam(value = "paramJson", required = false) String paramJson);


    /**
     * @author <a href="mailto:liyinqiao@gtmap.cn">liyinqiao</a>
     * @param batchUpdateRequestDTO
     * @return void
     * @description 批量更新户室
     */
    @PutMapping("/building/rest/v1.0/hs/batchupdate")
    void batchUpdateFwhs(@RequestBody FwhsBatchUpdateRequestDTO batchUpdateRequestDTO);

    /**
     * @author <a href="mailto:wangzijie@gtmap.cn">wangzijie</a>
     * @param bdcdyh
     * @return cn.gtmap.realestate.common.core.dto.building.DjdcbFwhsResponseDTO
     * @description 根据不动产单元号查询地籍调查表房屋信息
     */
    @GetMapping("/building/rest/v1.0/hs/djdcb/bdcdyh")
    DjdcbFwhsResponseDTO queryDjdcbFwhsByBdcdyh(@RequestParam(value = "bdcdyh", required = false) String bdcdyh);

    /**
     * @author <a href="mailto:liyinqiao@gtmap.cn">liyinqiao</a>
     * @param pageable
     * @param paramJson
     * @return org.springframework.data.domain.Page<cn.gtmap.realestate.common.core.domain.building.FwHsDO>
     * @description
     */
    @PostMapping("/building/rest/v1.0/hs/zhslistbypage")
    Page<FwHsHbZhsRequestDTO> listHsHbZhsByPageJson(@RequestBody Pageable pageable,
                                                    @RequestParam(value = "paramJson", required = false) String paramJson);

    /**
     * @param fwHsDO
     * @return List<String>
     * @author <a href="mailto:wangzijie@gtmap.cn">wangzijie</a>
     * @description 根据房屋户室实体查询有效的不动产单元号
     */
    @PostMapping("/building/rest/v1.0/hs/vaildbdcdyh/fwhsdo")
    List<String> listValidBdcdyhByFwHsDO(@RequestBody FwHsDO fwHsDO);

    /**
     * @param fwHsIndexList
     * @return List<String>
     * @author <a href="mailto:wangzijie@gtmap.cn">wangzijie</a>
     * @description 根据房屋户室主键集合查询有效的不动产单元号
     */
    @PostMapping("/building/rest/v1.0/hs/vaildbdcdyh/fwhsindexlist")
    List<String> listValidBdcdyhByFwHsIndexList(@RequestBody List<String> fwHsIndexList);

    /**
     * @param bgbh
     * @return List<String>
     * @author <a href="mailto:wangzijie@gtmap.cn">wangzijie</a>
     * @description 根据bgbh查询有效的不动产单元号
     */
    @PostMapping("/building/rest/v1.0/hs/vaildbdcdyh/bgbh")
    List<String> listValidBdcdyhByBgbh(@RequestBody String bgbh);

    /**
     * @param fwHsIndex
     * @return List<String>
     * @author <a href="mailto:wangzijie@gtmap.cn">wangzijie</a>
     * @description 根据fwHsIndex查询有效的不动产单元号
     */
    @GetMapping("/building/rest/v1.0/hs/vaildbdcdyh/fwHsIndex")
    List<String> listValidBdcdyhByFwHsIndex(@PathVariable("fwHsIndex") String fwHsIndex);

    /**
     * @param jsonData
     * @return List<String>
     * @author <a href="mailto:wangzijie@gtmap.cn">wangzijie</a>
     * @description 根据json查询有效的不动产单元号
     */
    @PostMapping("/building/rest/v1.0/hs/vaildbdcdyh/json")
    List<String> listValidBdcdyhByJson(@RequestBody String jsonData);


    /**
     * @param batchUpdateFwhsVO
     * @return List<String>
     * @author <a href="mailto:wangzijie@gtmap.cn">wangzijie</a>
     * @description 根据批量修改户室vo查询有效的不动产单元号
     */
    @PostMapping("/building/rest/v1.0/hs/vaildbdcdyh/batchfwhsvo")
    List<String> listValidBdcdyhByBatchUpdateFwhsVO(@RequestBody BatchUpdateFwhsVO batchUpdateFwhsVO);




}
