package cn.gtmap.realestate.common.core.service.rest.building;

import cn.gtmap.realestate.common.core.domain.building.*;
import cn.gtmap.realestate.common.core.dto.building.BdcdyPageResponseDTO;
import cn.gtmap.realestate.common.core.dto.building.BdcdyResponseDTO;
import cn.gtmap.realestate.common.core.dto.building.DjDcbResponseDTO;
import cn.gtmap.realestate.common.core.dto.building.FwBdcdyDTO;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:liyinqiao@gtmap.cn">liyinqiao</a>
 * @version 1.0  2018-11-08
 * @description 权籍不动产单元信息服务
 */
public interface BdcdyRestService {

    /**
     * @param pageable
     * @param paramJson
     * @return org.springframework.data.domain.Page<cn.gtmap.realestate.common.core.dto.building.BdcdyPageResponseDTO>
     * @author <a href="mailto:liyinqiao@gtmap.cn">liyinqiao</a>
     * @description 分页查询实测户室不动产单元信息
     */
    @PostMapping("/building/rest/v1.0/bdcdy/sc/page")
    Page<Map> listScFwHsBdcdy(@RequestBody Pageable pageable,
                                               @RequestParam(name = "paramJson",required = false) String paramJson);

    /**
     * @param pageable
     * @param paramJson
     * @return org.springframework.data.domain.Page<cn.gtmap.realestate.common.core.dto.building.BdcdyPageResponseDTO>
     * @author <a href="mailto:liyinqiao@gtmap.cn">liyinqiao</a>
     * @description 分页查询预测户室不动产单元信息
     */
    @PostMapping("/building/rest/v1.0/bdcdy/yc/page")
    Page<Map> listYcFwHsBdcdy(@RequestBody Pageable pageable,
                              @RequestParam(name = "paramJson", required = false) String paramJson);


    /**
     * @param bdcdyh
     * @param bdcdyfwlx
     * @return org.springframework.data.domain.Page<cn.gtmap.realestate.common.core.dto.building.BdcdyPageResponseDTO>
     * @author <a href="mailto:liyinqiao@gtmap.cn">liyinqiao</a>
     * @description 根据BDCDYH查询不动单元基本信息
     */
    @GetMapping("/building/rest/v1.0/bdcdy/{bdcdyh}")
    BdcdyResponseDTO queryBdcdy(@PathVariable("bdcdyh") String bdcdyh,
                                @RequestParam(name = "bdcdyfwlx", required = false) String bdcdyfwlx);

    /**
     * @author <a href="mailto:liyinqiao@gtmap.cn">liyinqiao</a>
     * @param fwbm
     * @return cn.gtmap.realestate.common.core.dto.building.BdcdyResponseDTO
     * @description 根据Fwbm查询不动单元基本信息(包含FW_HS  FW_YCHS FW_LJZ FW_XMXX)
     */
    @GetMapping("/building/rest/v1.0/bdcdy/byfwbm")
    BdcdyResponseDTO queryBdcdyByFwbm(@RequestParam("fwbm") String fwbm);

    /**
     * @author <a href="mailto:liyinqiao@gtmap.cn">liyinqiao</a>
     * @param ysfwbm
     * @return cn.gtmap.realestate.common.core.dto.building.BdcdyResponseDTO
     * @description  根据ysFwbm查询户室不动单元基本信息(包含FW_HS  FW_YCHS)
     */
    @GetMapping("/building/rest/v1.0/bdcdy/byysfwbm")
    BdcdyResponseDTO queryHsBdcdyByYsfwbm(@RequestParam("ysfwbm") String ysfwbm);

    /**
     * @author <a href="mailto:liyinqiao@gtmap.cn">liyinqiao</a>
     * @param ysfwbm
     * @param hslx
     * @return cn.gtmap.realestate.common.core.dto.building.BdcdyResponseDTO
     * @description 根据ysFwbm查询户室不动单元基本信息(可根据户室类型做判断)
     */
    @GetMapping("/building/rest/v1.0/bdcdy/byysfwbmwithhslx")
    BdcdyResponseDTO queryHsBdcdyByYsfwbmWithHslx(@RequestParam("ysfwbm") String ysfwbm,
                                          @RequestParam(name = "hslx", required = false) String hslx);

    /**
     * @author <a href="mailto:liyinqiao@gtmap.cn">liyinqiao</a>
     * @param bdcdyh
     * @return cn.gtmap.realestate.common.core.domain.building.FwHsDO
     * @description 根据BDCDYH查询户室信息
     */
    @GetMapping("/building/rest/v1.0/bdcdy/hs/{bdcdyh}")
    FwHsDO queryHsByBdcdyh(@PathVariable("bdcdyh") String bdcdyh,
                           @RequestParam(name = "hslx", required = false) String hslx);


    /**
     * @author <a href="mailto:liyinqiao@gtmap.cn">liyinqiao</a>
     * @param fwbm
     * @return java.util.List<cn.gtmap.realestate.common.core.dto.building.FwBdcdyDTO>
     * @description 根据FWBM查询户室类型的不动产单元
     */
    @GetMapping("/building/rest/v1.0/bdcdy/hs/listbyfwbm")
    List<FwBdcdyDTO> listFwBdcdyByFwbm(@RequestParam(name = "fwbm") String fwbm);

    /**
     * @author <a href="mailto:liyinqiao@gtmap.cn">liyinqiao</a>
     * @param ybdcdyh
     * @return cn.gtmap.realestate.common.core.dto.building.BdcdyResponseDTO
     * @description 合肥版本中 FW_HS FW_LJZ 表中包含ybdcdyh
     */
    @GetMapping("/building/rest/v1.0/bdcdy/hs/listbyybdcdyh")
    BdcdyResponseDTO queryFwHsAndFwLjzByYbdcdyh(@RequestParam(name = "ybdcdyh") String ybdcdyh);


    /**
     * @author <a href="mailto:liyinqiao@gtmap.cn">liyinqiao</a>
     * @param pageable, paramJson
     * @return org.springframework.data.domain.Page<java.util.Map>
     * @description 为外网提供的 分页查询房产信息
     */
    @PostMapping("/building/rest/v1.0/bdcdyh/hs/wwsq/listbypage")
    Page<Map> listHsForWwsqByPage(@RequestBody Pageable pageable,@RequestParam(name = "paramJson",required = false)String paramJson);

}
