package cn.gtmap.realestate.common.core.service.rest.accept;

import cn.gtmap.realestate.common.core.domain.BdcQlrDO;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @author <a href="mailto:yaoyi@gtmap.cn">yaoyi</a>
 * @version 1.0, 2020/1/13.
 * @description 不动产权利人RESR接口服务，提取accept中处理权利人信息通用接口服务供外部接口调用
 */
public interface BdcSlQlrRestService {

    /**
     * 批量修改权利人（用于批量页面）
     * @author: <a href="mailto:yaoyi@gtmap.cn">yaoyi</a>
     * @param: json 权利人集合JSON
     * @param: processInsId 流程实例ID
     * @param: xmid 项目ID
     * @return: Integer 修改数量
     */
    @PatchMapping(value = "/realestate-accept/rest/v1.0/qlr/list/pllc")
    Integer updatePlBdcQlr(@RequestBody String json, @RequestParam("processInsId") String processInsId,
                           @RequestParam("xmid") String xmid) throws Exception;
    /**
     * @description 批量修改权利人(用于批量组合页面)
     * @author: <a href="mailto:yaoyi@gtmap.cn">yaoyi</a>
     * @param: json 权利人集合JSON
     * @param: processInsId 流程实例ID
     * @param: xmid 项目ID
     * @param: djxl 登记小类
     * @return: List<BdcQlrDO> 不动产权利人DO集合
     */
    @PatchMapping(value = "/realestate-accept/rest/v1.0/qlr/list/plzh")
    List<BdcQlrDO> updatePlzhBdcQlr(@RequestBody String json,
                                    @RequestParam("processInsId") String processInsId,
                                    @RequestParam("xmid") String xmid,
                                    @RequestParam("djxl") String djxl) throws Exception;
    /**
     * 修改权利人共有方式接口
     * @author: <a href="mailto:yaoyi@gtmap.cn">yaoyi</a>
     * @param:  bdcQlrList 不动产权利人集合,  gzlslid 工作流实例ID, xmid 项目ID, lclx 流程类型
     * @return: List<BdcQlrDO> 不动产权利人DO集合
     */
    @PatchMapping(value = "/realestate-accept/rest/v1.0/qlr/list/gyfs")
    List<BdcQlrDO> updateBdcQlrGyfs(@RequestBody List<BdcQlrDO> bdcQlrList,
                                    @RequestParam("processInsId") String processInsId,
                                    @RequestParam("xmid") String xmid,
                                    @RequestParam("lclx") String lclx) throws Exception;


}
