package cn.gtmap.realestate.common.core.service.rest.accept;

import cn.gtmap.realestate.common.core.domain.accept.BdcSlJbxxDO;
import cn.gtmap.realestate.common.core.dto.accept.BdcSlCshDTO;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;

/**
 * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
 * @version 1.0, 2018/11/10
 * @description 不动产受理基本信息rest服务
 */
public interface BdcSlJbxxRestService {
    /**
     * @param jbxxid 基本信息ID
     * @return 不动产受理基本信息
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @description 根据基本信息ID获取不动产受理基本信息
     */
    @GetMapping("/realestate-accept/rest/v1.0/jbxx/{jbxxid}")
    BdcSlJbxxDO queryBdcSlJbxxByJbxxid(@PathVariable(value = "jbxxid") String jbxxid);

    /**
     * @param gzlslid 工作流实例ID
     * @return 不动产受理基本信息
     * @author <a href="mailto:zhangguangguang@gtmap.cn">zhangguangguang</a>
     * @description 根据工作流实例ID获取不动产受理基本信息
     */
    @GetMapping("/realestate-accept/rest/v1.0/jbxx/processinsid/{gzlslid}")
    BdcSlJbxxDO queryBdcSlJbxxByGzlslid(@PathVariable(value = "gzlslid") String gzlslid);

    /**
     * @param slbh 受理编号
     * @return 不动产受理基本信息
     * @author <a href="mailto:chenyucheng@gtmap.cn">chenyucheng</a>
     * @description 根据受理编号获取不动产受理基本信息
     */
    @GetMapping("/realestate-accept/rest/v1.0/jbxx/slbh/{slbh}")
    BdcSlJbxxDO queryBdcSlJbxxBySlbh(@PathVariable(value = "slbh") String slbh);


    /**
     * @param bdcSlCshDTO 受理初始化信息DTO
     * @return 不动产受理基本信息
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @description 新增不动产受理基本信息
     */
    @PostMapping("/realestate-accept/rest/v1.0/jbxx/xzjbxx")
    BdcSlJbxxDO insertBdcSlJbxx(@RequestBody BdcSlCshDTO bdcSlCshDTO);

    /**
     * @param bdcSlJbxxDO 不动产受理基本信息
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @description 新增不动产受理基本信息
     */
    @PostMapping("/realestate-accept/rest/v1.0/jbxx/")
    BdcSlJbxxDO insertBdcSlJbxx(@RequestBody BdcSlJbxxDO bdcSlJbxxDO);

    /**
     * @param bdcSlJbxxDO 不动产受理基本信息
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @description 更新不动产受理基本信息
     */
    @PutMapping("/realestate-accept/rest/v1.0/jbxx/")
    Integer updateBdcSlJbxx(@RequestBody BdcSlJbxxDO bdcSlJbxxDO);

    /**
     * @param jbxxid 基本信息ID
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @description 根据基本信息ID删除不动产受理基本信息
     */
    @DeleteMapping("/realestate-accept/rest/v1.0/jbxx/{jbxxid}")
    Integer deleteBdcSlJbxxByJbxxid(@PathVariable(value = "jbxxid") String jbxxid);

    /**
     * @param bdcSlJbxxQO 不动产一窗受理流程查询qo
     * @author <a href="mailto:chenyucheng@gtmap.cn">chenyucheng</a>
     * @description 不动产一窗受理流程
     */
    @GetMapping("/realestate-accept/rest/v1.0/jbxx/page")
    Page<BdcSlJbxxDO> listBdcSlJbxxByPageJson(@RequestBody Pageable pageable,
                                              @RequestParam(name = "bdcSlJbxxQO", required = false) String bdcSlJbxxQO);

    /**
     * @param slbh 重复受理编号
     * @return 处理后受理编号
     * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
     * @description 处理重复受理编号
     */
    @GetMapping("/realestate-accept/rest/v1.0/jbxx/dealSameSlbh/{slbh}")
    String dealSameSlbh(@PathVariable(value = "slbh") String slbh);

}
