package cn.gtmap.realestate.common.core.service.rest.accept;

import cn.gtmap.realestate.common.core.domain.BdcXmDO;
import cn.gtmap.realestate.common.core.domain.accept.BdcSlJbxxDO;
import cn.gtmap.realestate.common.core.dto.accept.BdcSlxxDTO;
import cn.gtmap.realestate.common.core.dto.engine.BdcGzYzTsxxDTO;
import cn.gtmap.realestate.common.core.qo.engine.BdcGzYzQO;
import cn.gtmap.realestate.common.core.vo.portal.BdcGzyzVO;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
 * @version 1.0, 2019/7/22
 * @description 规则验证
 */
public interface BdcGzyzRestService {

    /**
     * @param bdcGzYzQO 规则验证查询实体(支持任意参数)
     * @return 验证结果（包含入参）
     * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
     * @description 流程规则验证
     */
    @PostMapping(value = "/realestate-accept/rest/v1.0/gzyz")
    List<Map<String, Object>> yzBdcgz(@RequestBody BdcGzYzQO bdcGzYzQO);

    /**
     * @author: <a href="mailto:yaoyi@gtmap.cn">yaoyi</a>
     * @param: [bdcdywybh] 不动产唯一编码 房屋编号或地籍
     * @return: Boolean
     * @description 验证不动产单元号、唯一编号与权籍是否一致
     */
    @GetMapping(value = "/realestate-accept/rest/v1.0/gzyz/bdcdy/{bdcdywybh}")
    Boolean checkBdcdyhAndBdcdywybhConsistent(@PathVariable("bdcdywybh") String bdcdywybh);

    /**
     * @param processInsId 工作流实例ID
     * @return 规则验证信息
     * @author <a href="mailto:zhangwentao@gtmap.cn">zhangwentao</a>
     * @description 验证流程的收费状态
     */
    @GetMapping(value = "/realestate-accept/rest/v1.0/gzyz/sfzt/{processInsId}")
    BdcGzyzVO checkLcSfzt(@PathVariable(name = "processInsId") String processInsId);

    /**
     * @param jbxxid 基本信息ID
     * @return 查封文号数量
     * @author <a href="mailto:zhangwentao@gtmap.cn">zhangwentao</a>
     * @description 验证查封文号是否重复（批量解封不允许不重复）
     */
    @GetMapping(value = "/realestate-accept/rest/v1.0/gzyz/cjyz/{jbxxid}")
    Integer checkCfwhSfcf(@PathVariable(name = "jbxxid") String jbxxid);

    /**
     * @param qllx 权利类型的逗号分隔字符串
     * @author: <a href="mailto:yaoyi@gtmap.cn">yaoyi</a>
     * @param: bdcdyh 不动产单元号
     * @return: Boolean 验证结果 已生成权利返回 True 否则 False
     * @description 验证该不动产单元在登记系统是否已生成权利
     */
    @GetMapping(value = "/realestate-accept/rest/v1.0/gzyz/bdcdy/scql/{bdcdyh}/{qllx}")
    List<BdcXmDO> checkBdcdyScQl(@PathVariable(name = "bdcdyh") String bdcdyh, @PathVariable(name = "qllx") String qllx);

    /**
     * @param xmid
     * @return
     * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
     * @description 首套房验证;当申请人申请首套房时,验证申请人是否有过买房记录
     */
    @GetMapping(value = "/realestate-accept/rest/v1.0/gzyz/stfyz/{xmid}")
    BdcSlxxDTO checkStfFwtc(@PathVariable(name = "xmid") String xmid);

    /**
     * @param xmid
     * @return
     * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
     * @description 是否房查验证
     */
    @GetMapping(value = "/realestate-accept/rest/v1.0/gzyz/sffwcx/{xmid}")
    Boolean checkSfFwcxForYcslByXmid(@PathVariable(name = "xmid") String xmid);

    /**
     * @param bdcdyh  不动产单元
     * @param gzlslid 当前流程
     * @return
     * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
     * @description 验证当前不动产单元号是否正在办理其他非登记流程
     */
    @GetMapping(value = "/realestate-accept/rest/v1.0/gzyz/qtfdjlc/{bdcdyh}")
    BdcSlJbxxDO checkIsblQtfdjlc(@PathVariable(name = "bdcdyh") String bdcdyh, @RequestParam(name = "gzlslid", required = false) String gzlslid);

    /**
     * @param gzlslid 工作流实例ID
     * @param zhbs    组合规则标识
     * @return 提示信息
     * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
     * @description 非登记流程规则验证:流程转发/退回/
     */
    @PostMapping(value = "/realestate-accept/rest/v1.0/gzyz/fdjlc/{gzlslid}/{zhbs}")
    List<BdcGzYzTsxxDTO> fdjlcGzyz(@PathVariable(name = "gzlslid") String gzlslid, @PathVariable(name = "zhbs") String zhbs);

    /**
     * @param jbxxid 基本信息ID
     * @author <a href="mailto:chneyucheng@gtmap.cn">chneyucheng</a>
     * @description 验证一证多房的情况下，是否都都选全
     */
    @GetMapping(value = "/realestate-accept/rest/v1.0/gzyz/checkYzdfIsInclude/{jbxxid}")
    boolean checkYzdfIsInclude(@PathVariable(name = "jbxxid") String jbxxid);


    /**
     * @param jbxxid 基本信息ID
     * @author <a href="mailto:gaolining@gtmap.cn">gaolining</a>
     * @description 验证商品房交易信息权利人是否一致
     */
    @GetMapping(value = "/realestate-accept/rest/v1.0/gzyz/checkQlrSfyz/{jbxxid}")
    boolean checkQlrSfyz(@PathVariable(name = "jbxxid") String jbxxid);

    /**
     * @param gzlslid 工作流实例id
     * @author <a href="mailto:gaolining@gtmap.cn">gaolining</a>
     * @description 验证是否线上缴费成功 成功状态 sfzt=2&& jkfs=2
     * @date : 2020/3/6 8:39
     */
    @GetMapping(value = "/realestate-accept/rest/v1.0/gzyz/sfxsjfcg/{gzlslid}")
    boolean checkSfxsJfcg(@PathVariable(name = "gzlslid") String gzlslid);

    /**
     * @param jbxxid 基本信息id
     * @author <a href="mailto:gaolining@gtmap.cn">gaolining</a>
     * @description 获取当前添加购物车的数据的匹配落宗状态
     * @date : 2020/3/13 14:27
     */
    @GetMapping(value = "/realestate-accept/rest/v1.0/gzyz/pplzzt/{jbxxid}")
    Map checkPplzzt(@PathVariable(name = "jbxxid") String jbxxid, @RequestParam(name = "xztzlx") String xztzlx);


    /**
     * @param jbxxid 基本信息id
     * @author <a href="mailto:gaolining@gtmap.cn">gaolining</a>
     * @description 用于创建验证当前流程是否存在外联证书
     * @date : 2020/4/15 9:17
     */
    @GetMapping(value = "/realestate-accept/rest/v1.0/gzyz/sfwlzs/{jbxxid}")
    Integer checkSfwlzs(@PathVariable(name = "jbxxid") String jbxxid);
}
