package cn.gtmap.realestate.common.core.qo.inquiry;

import io.swagger.annotations.ApiModelProperty;

import java.util.Arrays;
import java.util.List;

/**
 * @author <a href="mailto:zhuyong@gtmap.cn">zhuyong</a>
 * @version 1.0, 2019/5/16
 * @description  查询子系统：不动产证书证明查询QO实体定义
 *
 *  模糊类型：0 精确  1 左匹配  2 右匹配 3 全模糊
 *
 *  名称后加后缀 2 的为二次查询筛选时候新增的查询字段
 */
public class BdcZszmQO {
    /**
     * 合肥版： hefei
     * 南通版： nantong
     * 标准版： standard
     */
    @ApiModelProperty(value = "版本标识")
    private String version;

    @ApiModelProperty(value = "不动产单元号")
    private String bdcdyh;

    @ApiModelProperty(value = "不动产单元号 模糊类型")
    private Integer bdcdyhmhlx;

    @ApiModelProperty(value = "不动产单元号2")
    private String bdcdyh2;

    @ApiModelProperty(value = "不动产单元号2 模糊类型")
    private Integer bdcdyhmhlx2;

    @ApiModelProperty(value = "不动产权证号")
    private String bdcqzh;

    @ApiModelProperty(value = "不动产权证号 模糊类型")
    private Integer bdcqzhmhlx;

    @ApiModelProperty(value = "不动产权证号2")
    private String bdcqzh2;

    @ApiModelProperty(value = "不动产权证号2 模糊类型")
    private Integer bdcqzhmhlx2;

    @ApiModelProperty(value = "原产权证号")
    private String ycqzh;

    @ApiModelProperty(value = "原产权证号 模糊类型")
    private Integer ycqzhmhlx;

    @ApiModelProperty(value = "权利人名称")
    private String[] qlrmc;

    @ApiModelProperty(value = "权利人名称 模糊类型")
    private Integer qlrmcmhlx;

    @ApiModelProperty(value = "权利人名称2")
    private String qlrmc2;

    @ApiModelProperty(value = "权利人名称2 模糊类型")
    private Integer qlrmcmhlx2;

    @ApiModelProperty(value = "权利人证件号")
    private String[] qlrzjh;

    @ApiModelProperty(value = "权利人证件号 模糊类型")
    private Integer qlrzjhmhlx;

    @ApiModelProperty(value = "权利人证件号2")
    private String qlrzjh2;

    @ApiModelProperty(value = "权利人证件号2 模糊类型")
    private Integer qlrzjhmhlx2;

    @ApiModelProperty(value = "义务人名称")
    private String[] ywrmc;

    @ApiModelProperty(value = "义务人名称 模糊类型")
    private Integer ywrmcmhlx;

    @ApiModelProperty(value = "义务人名称2")
    private String ywrmc2;

    @ApiModelProperty(value = "义务人名称2 模糊类型")
    private Integer ywrmcmhlx2;

    @ApiModelProperty(value = "义务人证件号")
    private String[] ywrzjh;

    @ApiModelProperty(value = "义务人证件号 模糊类型")
    private Integer ywrzjhmhlx;

    @ApiModelProperty(value = "义务人证件号2")
    private String ywrzjh2;

    @ApiModelProperty(value = "义务人证件号2 模糊类型")
    private Integer ywrzjhmhlx2;

    @ApiModelProperty(value = "证书类型")
    private Integer zslx;

    @ApiModelProperty(value = "坐落")
    private String zl;

    @ApiModelProperty(value = "坐落 模糊类型")
    private Integer zlmhlx;

    @ApiModelProperty(value = "坐落2")
    private String zl2;

    @ApiModelProperty(value = "坐落2 模糊类型")
    private Integer zlmhlx2;

    @ApiModelProperty(value = "幢号")
    private String zh;

    @ApiModelProperty(value = "幢号 模糊类型")
    private Integer zhmhlx;

    @ApiModelProperty(value = "幢号2")
    private String zh2;

    @ApiModelProperty(value = "幢号2 模糊类型")
    private Integer zhmhlx2;

    @ApiModelProperty(value = "房间号")
    private String fjh;

    @ApiModelProperty(value = "房间号 模糊类型")
    private Integer fjhmhlx;

    @ApiModelProperty(value = "房间号2")
    private String fjh2;

    @ApiModelProperty(value = "房间号2 模糊类型")
    private Integer fjhmhlx2;

    @ApiModelProperty(value = "缮证人")
    private String szr;

    @ApiModelProperty(value = "缮证时间 起")
    private String szsjq;

    @ApiModelProperty(value = "缮证时间 止")
    private String szsjz;

    @ApiModelProperty(value = "权属状态")
    private Integer qszt;

    @ApiModelProperty(value = "权属状态2")
    private Integer qszt2;

    @ApiModelProperty(value = "权属状态3")
    private Integer[] qszt3;

    @ApiModelProperty(value = "证书ID")
    private String zsid;

    @ApiModelProperty(value = "业务编号")
    private String slbh;

    @ApiModelProperty(value = "业务编号模糊类型")
    private String slbhmhlx;

    @ApiModelProperty(value = "业务编号2")
    private String slbh2;

    @ApiModelProperty(value = "业务编号2 模糊类型")
    private String slbhmhlx2;

    @ApiModelProperty(value = "房屋编号")
    private String fwbh;

    @ApiModelProperty(value = "房屋编号模糊类型")
    private String fwbhmhlx;

    @ApiModelProperty(value = "房屋编号2")
    private String fwbh2;

    @ApiModelProperty(value = "房屋编号2 模糊类型")
    private String fwbhmhlx2;

    @ApiModelProperty(value = "证书流水号")
    private String zhlsh;

    @ApiModelProperty(value = "证书流水号模糊类型")
    private String zhlshmhlx;

    @ApiModelProperty(value = "证书流水号2")
    private String zhlsh2;

    @ApiModelProperty(value = "证书流水号2 模糊类型")
    private String zhlshmhlx2;

    @ApiModelProperty(value = "不动产类型")
    private Integer bdclx;

    @ApiModelProperty(value = "原地籍号")
    private String ybdcdyh;

    @ApiModelProperty(value = "原地籍号模糊类型")
    private String ybdcdyhmhlx;

    @ApiModelProperty(value = "登记原因")
    private String djyy;

    @ApiModelProperty(value = "登记原因 模糊类型")
    private String djyymhlx;

    @ApiModelProperty(value = "规划用途")
    private String ghyt;

    @ApiModelProperty(value = "规划用途 模糊类型")
    private String ghytmhlx;

    @ApiModelProperty(value = "权利类型")
    private Integer[] qllx;

    @ApiModelProperty(value = "原系统产权证号")
    private String yxtcqzh;

    @ApiModelProperty(value = "原系统产权证号 模糊类型")
    private String yxtcqzhmhlx;

    @ApiModelProperty(value = "原系统产权证号2")
    private String yxtcqzh2;

    @ApiModelProperty(value = "原系统产权证号2 模糊类型")
    private String yxtcqzhmhlx2;

    @ApiModelProperty(value = "IP地址")
    private String ipaddress;

    @ApiModelProperty(value = "（不展示的）流程登记小类代码")
    private String djxldm;


    @ApiModelProperty(value = "证书印制号")
    private String zsyzh;

    @ApiModelProperty(value = "证书印制号模糊类型")
    private String zsyzhmhlx;


    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getZsyzh() {
        return zsyzh;
    }

    public void setZsyzh(String zsyzh) {
        this.zsyzh = zsyzh;
    }

    public String getZsyzhmhlx() {
        return zsyzhmhlx;
    }

    public void setZsyzhmhlx(String zsyzhmhlx) {
        this.zsyzhmhlx = zsyzhmhlx;
    }

    public String getDjxldm() {
        return djxldm;
    }

    public void setDjxldm(String djxldm) {
        this.djxldm = djxldm;
    }

    public String getIpaddress() {
        return ipaddress;
    }

    public void setIpaddress(String ipaddress) {
        this.ipaddress = ipaddress;
    }

    public Integer[] getQszt3() {
        return qszt3;
    }

    public void setQszt3(Integer[] qszt3) {
        this.qszt3 = qszt3;
    }

    public String getZl2() {
        return zl2;
    }

    public void setZl2(String zl2) {
        this.zl2 = zl2;
    }

    public Integer getZlmhlx2() {
        return zlmhlx2;
    }

    public void setZlmhlx2(Integer zlmhlx2) {
        this.zlmhlx2 = zlmhlx2;
    }

    public Integer getQszt2() {
        return qszt2;
    }

    public void setQszt2(Integer qszt2) {
        this.qszt2 = qszt2;
    }

    public String getYxtcqzh2() {
        return yxtcqzh2;
    }

    public void setYxtcqzh2(String yxtcqzh2) {
        this.yxtcqzh2 = yxtcqzh2;
    }

    public String getYxtcqzhmhlx2() {
        return yxtcqzhmhlx2;
    }

    public void setYxtcqzhmhlx2(String yxtcqzhmhlx2) {
        this.yxtcqzhmhlx2 = yxtcqzhmhlx2;
    }

    public String getYxtcqzh() {
        return yxtcqzh;
    }

    public void setYxtcqzh(String yxtcqzh) {
        this.yxtcqzh = yxtcqzh;
    }

    public String getYxtcqzhmhlx() {
        return yxtcqzhmhlx;
    }

    public void setYxtcqzhmhlx(String yxtcqzhmhlx) {
        this.yxtcqzhmhlx = yxtcqzhmhlx;
    }

    public String getSlbh2() {
        return slbh2;
    }

    public void setSlbh2(String slbh2) {
        this.slbh2 = slbh2;
    }

    public String getSlbhmhlx2() {
        return slbhmhlx2;
    }

    public void setSlbhmhlx2(String slbhmhlx2) {
        this.slbhmhlx2 = slbhmhlx2;
    }

    public String getBdcdyh() {
        return bdcdyh;
    }

    public void setBdcdyh(String bdcdyh) {
        this.bdcdyh = bdcdyh;
    }

    public Integer getBdcdyhmhlx() {
        return bdcdyhmhlx;
    }

    public void setBdcdyhmhlx(Integer bdcdyhmhlx) {
        this.bdcdyhmhlx = bdcdyhmhlx;
    }

    public String getBdcqzh() {
        return bdcqzh;
    }

    public void setBdcqzh(String bdcqzh) {
        this.bdcqzh = bdcqzh;
    }

    public Integer getBdcqzhmhlx() {
        return bdcqzhmhlx;
    }

    public void setBdcqzhmhlx(Integer bdcqzhmhlx) {
        this.bdcqzhmhlx = bdcqzhmhlx;
    }

    public String[] getQlrmc() {
        return qlrmc;
    }

    public void setQlrmc(String[] qlrmc) {
        this.qlrmc = qlrmc;
    }

    public Integer getQlrmcmhlx() {
        return qlrmcmhlx;
    }

    public void setQlrmcmhlx(Integer qlrmcmhlx) {
        this.qlrmcmhlx = qlrmcmhlx;
    }

    public String[] getQlrzjh() {
        return qlrzjh;
    }

    public void setQlrzjh(String[] qlrzjh) {
        this.qlrzjh = qlrzjh;
    }

    public Integer getQlrzjhmhlx() {
        return qlrzjhmhlx;
    }

    public void setQlrzjhmhlx(Integer qlrzjhmhlx) {
        this.qlrzjhmhlx = qlrzjhmhlx;
    }

    public String[] getYwrmc() {
        return ywrmc;
    }

    public void setYwrmc(String[] ywrmc) {
        this.ywrmc = ywrmc;
    }

    public Integer getYwrmcmhlx() {
        return ywrmcmhlx;
    }

    public void setYwrmcmhlx(Integer ywrmcmhlx) {
        this.ywrmcmhlx = ywrmcmhlx;
    }

    public String[] getYwrzjh() {
        return ywrzjh;
    }

    public void setYwrzjh(String[] ywrzjh) {
        this.ywrzjh = ywrzjh;
    }

    public Integer getYwrzjhmhlx() {
        return ywrzjhmhlx;
    }

    public void setYwrzjhmhlx(Integer ywrzjhmhlx) {
        this.ywrzjhmhlx = ywrzjhmhlx;
    }

    public Integer getZslx() {
        return zslx;
    }

    public void setZslx(Integer zslx) {
        this.zslx = zslx;
    }

    public String getZl() {
        return zl;
    }

    public void setZl(String zl) {
        this.zl = zl;
    }

    public Integer getZlmhlx() {
        return zlmhlx;
    }

    public void setZlmhlx(Integer zlmhlx) {
        this.zlmhlx = zlmhlx;
    }

    public String getSzr() {
        return szr;
    }

    public void setSzr(String szr) {
        this.szr = szr;
    }

    public String getSzsjq() {
        return szsjq;
    }

    public void setSzsjq(String szsjq) {
        this.szsjq = szsjq;
    }

    public String getSzsjz() {
        return szsjz;
    }

    public void setSzsjz(String szsjz) {
        this.szsjz = szsjz;
    }

    public Integer getQszt() {
        return qszt;
    }

    public void setQszt(Integer qszt) {
        this.qszt = qszt;
    }

    public String getZsid() {
        return zsid;
    }

    public void setZsid(String zsid) {
        this.zsid = zsid;
    }

    public String getYcqzh() {
        return ycqzh;
    }

    public void setYcqzh(String ycqzh) {
        this.ycqzh = ycqzh;
    }

    public Integer getYcqzhmhlx() {
        return ycqzhmhlx;
    }

    public void setYcqzhmhlx(Integer ycqzhmhlx) {
        this.ycqzhmhlx = ycqzhmhlx;
    }

    public String getZh() {
        return zh;
    }

    public void setZh(String zh) {
        this.zh = zh;
    }

    public Integer getZhmhlx() {
        return zhmhlx;
    }

    public void setZhmhlx(Integer zhmhlx) {
        this.zhmhlx = zhmhlx;
    }

    public String getFjh() {
        return fjh;
    }

    public void setFjh(String fjh) {
        this.fjh = fjh;
    }

    public Integer getFjhmhlx() {
        return fjhmhlx;
    }

    public void setFjhmhlx(Integer fjhmhlx) {
        this.fjhmhlx = fjhmhlx;
    }

    public String getSlbh() {
        return slbh;
    }

    public void setSlbh(String slbh) {
        this.slbh = slbh;
    }

    public String getSlbhmhlx() {
        return slbhmhlx;
    }

    public void setSlbhmhlx(String slbhmhlx) {
        this.slbhmhlx = slbhmhlx;
    }

    public String getFwbh() {
        return fwbh;
    }

    public void setFwbh(String fwbh) {
        this.fwbh = fwbh;
    }

    public String getFwbhmhlx() {
        return fwbhmhlx;
    }

    public void setFwbhmhlx(String fwbhmhlx) {
        this.fwbhmhlx = fwbhmhlx;
    }

    public String getZhlsh() {
        return zhlsh;
    }

    public void setZhlsh(String zhlsh) {
        this.zhlsh = zhlsh;
    }

    public String getZhlshmhlx() {
        return zhlshmhlx;
    }

    public void setZhlshmhlx(String zhlshmhlx) {
        this.zhlshmhlx = zhlshmhlx;
    }

    public Integer getBdclx() {
        return bdclx;
    }

    public void setBdclx(Integer bdclx) {
        this.bdclx = bdclx;
    }

    public String getYbdcdyh() {
        return ybdcdyh;
    }

    public void setYbdcdyh(String ybdcdyh) {
        this.ybdcdyh = ybdcdyh;
    }

    public String getYbdcdyhmhlx() {
        return ybdcdyhmhlx;
    }

    public void setYbdcdyhmhlx(String ybdcdyhmhlx) {
        this.ybdcdyhmhlx = ybdcdyhmhlx;
    }

    public String getBdcdyh2() {
        return bdcdyh2;
    }

    public void setBdcdyh2(String bdcdyh2) {
        this.bdcdyh2 = bdcdyh2;
    }

    public Integer getBdcdyhmhlx2() {
        return bdcdyhmhlx2;
    }

    public void setBdcdyhmhlx2(Integer bdcdyhmhlx2) {
        this.bdcdyhmhlx2 = bdcdyhmhlx2;
    }

    public String getBdcqzh2() {
        return bdcqzh2;
    }

    public void setBdcqzh2(String bdcqzh2) {
        this.bdcqzh2 = bdcqzh2;
    }

    public Integer getBdcqzhmhlx2() {
        return bdcqzhmhlx2;
    }

    public void setBdcqzhmhlx2(Integer bdcqzhmhlx2) {
        this.bdcqzhmhlx2 = bdcqzhmhlx2;
    }

    public String getQlrmc2() {
        return qlrmc2;
    }

    public void setQlrmc2(String qlrmc2) {
        this.qlrmc2 = qlrmc2;
    }

    public Integer getQlrmcmhlx2() {
        return qlrmcmhlx2;
    }

    public void setQlrmcmhlx2(Integer qlrmcmhlx2) {
        this.qlrmcmhlx2 = qlrmcmhlx2;
    }

    public String getQlrzjh2() {
        return qlrzjh2;
    }

    public void setQlrzjh2(String qlrzjh2) {
        this.qlrzjh2 = qlrzjh2;
    }

    public Integer getQlrzjhmhlx2() {
        return qlrzjhmhlx2;
    }

    public void setQlrzjhmhlx2(Integer qlrzjhmhlx2) {
        this.qlrzjhmhlx2 = qlrzjhmhlx2;
    }

    public String getYwrmc2() {
        return ywrmc2;
    }

    public void setYwrmc2(String ywrmc2) {
        this.ywrmc2 = ywrmc2;
    }

    public Integer getYwrmcmhlx2() {
        return ywrmcmhlx2;
    }

    public void setYwrmcmhlx2(Integer ywrmcmhlx2) {
        this.ywrmcmhlx2 = ywrmcmhlx2;
    }

    public String getYwrzjh2() {
        return ywrzjh2;
    }

    public void setYwrzjh2(String ywrzjh2) {
        this.ywrzjh2 = ywrzjh2;
    }

    public Integer getYwrzjhmhlx2() {
        return ywrzjhmhlx2;
    }

    public void setYwrzjhmhlx2(Integer ywrzjhmhlx2) {
        this.ywrzjhmhlx2 = ywrzjhmhlx2;
    }

    public String getZh2() {
        return zh2;
    }

    public void setZh2(String zh2) {
        this.zh2 = zh2;
    }

    public Integer getZhmhlx2() {
        return zhmhlx2;
    }

    public void setZhmhlx2(Integer zhmhlx2) {
        this.zhmhlx2 = zhmhlx2;
    }

    public String getFjh2() {
        return fjh2;
    }

    public void setFjh2(String fjh2) {
        this.fjh2 = fjh2;
    }

    public Integer getFjhmhlx2() {
        return fjhmhlx2;
    }

    public void setFjhmhlx2(Integer fjhmhlx2) {
        this.fjhmhlx2 = fjhmhlx2;
    }

    public String getFwbh2() {
        return fwbh2;
    }

    public void setFwbh2(String fwbh2) {
        this.fwbh2 = fwbh2;
    }

    public String getFwbhmhlx2() {
        return fwbhmhlx2;
    }

    public void setFwbhmhlx2(String fwbhmhlx2) {
        this.fwbhmhlx2 = fwbhmhlx2;
    }

    public String getZhlsh2() {
        return zhlsh2;
    }

    public void setZhlsh2(String zhlsh2) {
        this.zhlsh2 = zhlsh2;
    }

    public String getZhlshmhlx2() {
        return zhlshmhlx2;
    }

    public void setZhlshmhlx2(String zhlshmhlx2) {
        this.zhlshmhlx2 = zhlshmhlx2;
    }

    public String getDjyy() {
        return djyy;
    }

    public void setDjyy(String djyy) {
        this.djyy = djyy;
    }

    public String getDjyymhlx() {
        return djyymhlx;
    }

    public void setDjyymhlx(String djyymhlx) {
        this.djyymhlx = djyymhlx;
    }

    public String getGhyt() {
        return ghyt;
    }

    public void setGhyt(String ghyt) {
        this.ghyt = ghyt;
    }

    public String getGhytmhlx() {
        return ghytmhlx;
    }

    public void setGhytmhlx(String ghytmhlx) {
        this.ghytmhlx = ghytmhlx;
    }

    public Integer[] getQllx() {
        return qllx;
    }

    public void setQllx(Integer[] qllx) {
        this.qllx = qllx;
    }

    @Override
    public String toString() {
        return "BdcZszmQO{" +
                "bdcdyh='" + bdcdyh + '\'' +
                ", bdcdyhmhlx=" + bdcdyhmhlx +
                ", bdcqzh='" + bdcqzh + '\'' +
                ", bdcqzhmhlx=" + bdcqzhmhlx +
                ", ycqzh='" + ycqzh + '\'' +
                ", ycqzhmhlx=" + ycqzhmhlx +
                ", qlrmc=" + Arrays.toString(qlrmc) +
                ", qlrmcmhlx=" + qlrmcmhlx +
                ", qlrzjh=" + Arrays.toString(qlrzjh) +
                ", qlrzjhmhlx=" + qlrzjhmhlx +
                ", ywrmc=" + Arrays.toString(ywrmc) +
                ", ywrmcmhlx=" + ywrmcmhlx +
                ", ywrzjh=" + Arrays.toString(ywrzjh) +
                ", ywrzjhmhlx=" + ywrzjhmhlx +
                ", zslx=" + zslx +
                ", zl='" + zl + '\'' +
                ", zlmhlx=" + zlmhlx +
                ", zh='" + zh + '\'' +
                ", zhmhlx=" + zhmhlx +
                ", fjh='" + fjh + '\'' +
                ", fjhmhlx=" + fjhmhlx +
                ", szr='" + szr + '\'' +
                ", szsjq='" + szsjq + '\'' +
                ", szsjz='" + szsjz + '\'' +
                ", qszt=" + qszt +
                ", zsid='" + zsid + '\'' +
                ", slbh='" + slbh + '\'' +
                ", slbhmhlx='" + slbhmhlx + '\'' +
                ", fwbh='" + fwbh + '\'' +
                ", fwbhmhlx='" + fwbhmhlx + '\'' +
                ", zhlsh='" + zhlsh + '\'' +
                ", zhlshmhlx='" + zhlshmhlx + '\'' +
                ", bdclx=" + bdclx +
                ", ybdcdyh='" + ybdcdyh + '\'' +
                ", ybdcdyhmhlx='" + ybdcdyhmhlx + '\'' +
                ", qllx='" + Arrays.toString(qllx) + '\'' +
                '}';
    }
}
