package cn.gtmap.realestate.common.core.qo.inquiry;

import cn.gtmap.realestate.common.core.qo.init.BdcQlrQO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * @author <a href="mailto:zhuyong@gtmap.cn">zhuyong</a>
 * @version 1.0, 2019/7/8
 * @description  不动产住房信息查询参数QO定义
 */
@ApiModel(value = "BdcZfxxQO", description = "不动产住房查询参数封装对象")
public class BdcZfxxQO {
    /**
     * 权利人名称与证件号需要成对，避免单独分开名称和证件号
     */
    @ApiModelProperty(value = "权利人信息")
    private List<BdcQlrQO> qlrxx;

    /**
     * 1 不动产登记系统  2  自助查询机  3 互联网+   4 （南通）自助交互机
     * 5 合肥大数据局
     */
    @ApiModelProperty(value = "查询来源")
    private String cxly;

    /**
     * 查询单位名称（主要用于记录，不用于过滤）
     */
    @ApiModelProperty(value = "查询单位名称")
    private String cxdw;
    /**
     * 发起请求机器mac地址
     */
    @ApiModelProperty(value = "来源地址")
    private String lydz;

    /**
     * 有些场景会单独传不动产单元号查询（多个的话逗号分隔）
     */
    @ApiModelProperty(value = "不动产单元号")
    private String bdcdyh;

    /**
     * 规划用途
     */
    @ApiModelProperty(value = "规划用途")
    private String ghyt;


    @ApiModelProperty(value = "是否需要过滤规划用途  Y 是 N 否")
    private String sfghyt;


    public String getSfghyt() {
        return sfghyt;
    }

    public void setSfghyt(String sfghyt) {
        this.sfghyt = sfghyt;
    }

    public List<BdcQlrQO> getQlrxx() {
        return qlrxx;
    }

    public void setQlrxx(List<BdcQlrQO> qlrxx) {
        this.qlrxx = qlrxx;
    }

    public String getCxly() {
        return cxly;
    }

    public void setCxly(String cxly) {
        this.cxly = cxly;
    }

    public String getLydz() {
        return lydz;
    }

    public void setLydz(String lydz) {
        this.lydz = lydz;
    }

    public String getBdcdyh() {
        return bdcdyh;
    }

    public void setBdcdyh(String bdcdyh) {
        this.bdcdyh = bdcdyh;
    }

    public String getGhyt() {
        return ghyt;
    }

    public void setGhyt(String ghyt) {
        this.ghyt = ghyt;
    }

    public String getCxdw() {
        return cxdw;
    }

    public void setCxdw(String cxdw) {
        this.cxdw = cxdw;
    }

    @Override
    public String toString() {
        return "BdcZfxxQO{" +
                "qlrxx=" + qlrxx +
                ", cxly='" + cxly + '\'' +
                ", cxdw='" + cxdw + '\'' +
                ", lydz='" + lydz + '\'' +
                ", bdcdyh='" + bdcdyh + '\'' +
                ", ghyt='" + ghyt + '\'' +
                ", sfghyt='" + sfghyt + '\'' +
                '}';
    }
}
