package cn.gtmap.realestate.common.core.qo.inquiry;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;

/**
 * @author <a href="mailto:huangjian@gtmap.cn">huangjian</a>
 * @version 1.0, 2019/9/3 09:54
 * @description 抵押查询Qo
 */
@Api(value = "BdcDyaQO", description = "抵押信息查询对象")
public class BdcDyaQo {

    @ApiModelProperty("不动产单元号")
    private String bdcdyh;

    @ApiModelProperty("权利人名称")
    private String qlrmc;

    @ApiModelProperty("权利人证件号")
    private String qlrzjh;

    @ApiModelProperty("坐落")
    private String zl;

    @ApiModelProperty("抵押证明号")
    private String bdcqzh;

    @ApiModelProperty("原系统产权证号")
    private String yxtcqzh;

    @ApiModelProperty("义务人")
    private String ywr;

    @ApiModelProperty("义务人证件号")
    private String ywrzjh;

    @ApiModelProperty("受理编号")
    private String slbh;

    @ApiModelProperty("原产权证号")
    private String ycqzh;

    @ApiModelProperty("查询类型")
    private String type;

    @ApiModelProperty(value = "权属状态")
    private Integer qszt;

    @ApiModelProperty("客户端ip")
    private String clientIp;

    public String getSlbh() {
        return slbh;
    }

    public void setSlbh(String slbh) {
        this.slbh = slbh;
    }

    public String getBdcdyh() {
        return bdcdyh;
    }

    public void setBdcdyh(String bdcdyh) {
        this.bdcdyh = bdcdyh;
    }

    public String getQlrmc() {
        return qlrmc;
    }

    public void setQlrmc(String qlrmc) {
        this.qlrmc = qlrmc;
    }

    public String getZl() {
        return zl;
    }

    public void setZl(String zl) {
        this.zl = zl;
    }

    public String getBdcqzh() {
        return bdcqzh;
    }

    public void setBdcqzh(String bdcqzh) {
        this.bdcqzh = bdcqzh;
    }

    public String getYxtcqzh() {
        return yxtcqzh;
    }

    public void setYxtcqzh(String yxtcqzh) {
        this.yxtcqzh = yxtcqzh;
    }

    public String getYwr() {
        return ywr;
    }

    public void setYwr(String ywr) {
        this.ywr = ywr;
    }

    public String getYwrzjh() {
        return ywrzjh;
    }

    public void setYwrzjh(String ywrzjh) {
        this.ywrzjh = ywrzjh;
    }

    public String getYcqzh() {
        return ycqzh;
    }

    public void setYcqzh(String ycqzh) {
        this.ycqzh = ycqzh;
    }


    public String getQlrzjh() {
        return qlrzjh;
    }

    public void setQlrzjh(String qlrzjh) {
        this.qlrzjh = qlrzjh;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }


    public Integer getQszt() {
        return qszt;
    }

    public void setQszt(Integer qszt) {
        this.qszt = qszt;
    }

    public String getClientIp() {
        return clientIp;
    }

    public void setClientIp(String clientIp) {
        this.clientIp = clientIp;
    }

    @Override
    public String toString() {
        return "BdcDyaQo{" +
                "bdcdyh='" + bdcdyh + '\'' +
                ", qlrmc='" + qlrmc + '\'' +
                ", qlrzjh='" + qlrzjh + '\'' +
                ", zl='" + zl + '\'' +
                ", bdcqzh='" + bdcqzh + '\'' +
                ", yxtcqzh='" + yxtcqzh + '\'' +
                ", ywr='" + ywr + '\'' +
                ", ywrzjh='" + ywrzjh + '\'' +
                ", slbh='" + slbh + '\'' +
                ", ycqzh='" + ycqzh + '\'' +
                ", type='" + type + '\'' +
                ", qszt=" + qszt +
                '}';
    }
}
