package cn.gtmap.realestate.common.core.qo.init;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.StringUtils;

import java.util.List;

/**
 * @author <a href="mailto:lisongtao@gtmap.cn">lisongtao</a>
 * @description 不动产查封信息查询对象
 */
@ApiModel(value = "BdcCfQO", description = "不动产查封信息查询对象")
public class BdcCfQO {
    @ApiModelProperty(value = "权利人")
    private String qlrmc;
    @ApiModelProperty(value = "坐落")
    private String zl;
    @ApiModelProperty(value = "不动产单元号")
    private List<String> bdcdyh;
    @ApiModelProperty(value = "义务人")
    private String ywrmc;
    @ApiModelProperty(value = "义务人模糊方式 1:精确 2:左模糊 3:右模糊 4:全模糊")
    private String ywrmcmh;
    @ApiModelProperty(value = "查封文号")
    private String cfwh;
    @ApiModelProperty(value = "查封机关")
    private String cfjg;
    @ApiModelProperty(value = "受理编号")
    private String slbh;
    @ApiModelProperty(value = "原产权证号")
    private String ycqzh;
    @ApiModelProperty(value = "项目ID")
    private List<String> xmid;

    @Override
    public String toString() {
        return "BdcCfQO{" +
                "qlrmc='" + qlrmc + '\'' +
                ", zl='" + zl + '\'' +
                ", bdcdyh='" + bdcdyh + '\'' +
                ", ywrmc='" + ywrmc + '\'' +
                ", ywrmcmh='" + ywrmcmh + '\'' +
                ", cfwh='" + cfwh + '\'' +
                ", cfjg='" + cfjg + '\'' +
                ", slbh='" + slbh + '\'' +
                ", ycqzh='" + ycqzh + '\'' +
                ", xmid=" + xmid +
                '}';
    }

    public String getQlrmc() {
        return qlrmc;
    }

    public void setQlrmc(String qlrmc) {
        this.qlrmc = qlrmc;
    }

    public String getZl() {
        return zl;
    }

    public void setZl(String zl) {
        this.zl = zl;
    }

    public List<String> getBdcdyh() {
        return bdcdyh;
    }

    public void setBdcdyh(List<String> bdcdyh) {
        this.bdcdyh = bdcdyh;
    }

    public String getYwrmc() {
        return ywrmc;
    }

    public void setYwrmc(String ywrmc) {
        this.ywrmc = ywrmc;
    }

    public String getCfwh() {
        return cfwh;
    }

    public void setCfwh(String cfwh) {
        this.cfwh = cfwh;
    }

    public String getCfjg() {
        return cfjg;
    }

    public void setCfjg(String cfjg) {
        this.cfjg = cfjg;
    }

    public String getSlbh() {
        return slbh;
    }

    public void setSlbh(String slbh) {
        this.slbh = slbh;
    }

    public String getYcqzh() {
        return ycqzh;
    }

    public void setYcqzh(String ycqzh) {
        this.ycqzh = ycqzh;
    }

    public List<String> getXmid() {
        return xmid;
    }

    public void setXmid(List<String> xmid) {
        this.xmid = xmid;
    }

    public String getYwrmcmh() {
        if (StringUtils.isBlank(ywrmcmh)) {
            return "3";
        } else {
            return ywrmcmh;
        }
    }

    public void setYwrmcmh(String ywrmcmh) {
        this.ywrmcmh = ywrmcmh;
    }
}
