package cn.gtmap.realestate.common.core.qo.certificate;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * *
 *
 * @author <a href="mailto:zhangwentao@gtmap.cn>zhangwentao</a>"
 * @version 1.0, 2018/12/3
 * @description 不动产印制号查询QO
 */
@ApiModel(value = "BdcYzhQO", description = "不动产印制号查询对象")
public class BdcYzhQO {
    @ApiModelProperty(value = "使用情况")
    Integer syqk;
    @ApiModelProperty(value = "印制号ID")
    String yzhid;
    @ApiModelProperty(value = "证书类型")
    Integer zslx;
    @ApiModelProperty(value = "证书ID")
    String zsid;
    @ApiModelProperty(value = "权证印刷序列号")
    String qzysxlh;
    @ApiModelProperty(value = "使用人")
    String syr;
    @ApiModelProperty(value = "使用人ID")
    String syrid;
    @ApiModelProperty(value = "领取人ID")
    String lqrid;
    @ApiModelProperty(value = "领取部门ID")
    String lqbmid;
    @ApiModelProperty(value = "区县代码")
    String qxdm;
    @ApiModelProperty(value = "年份")
    String nf;
    @ApiModelProperty(value = "排序列名（字段名）")
    String orderField;
    @ApiModelProperty(value = "排序类型（ASC/DESC）")
    String orderType;
    @ApiModelProperty(value = "获取的数量", hidden = true)
    Integer num;
    @ApiModelProperty(value = "有相同印制号查询状态的证书ID")
    List<String> zsidList;

    public List<String> getZsidList() {
        return zsidList;
    }

    public void setZsidList(List<String> zsidList) {
        this.zsidList = zsidList;
    }

    public String getSyrid() {
        return syrid;
    }

    public void setSyrid(String syrid) {
        this.syrid = syrid;
    }
    public String getZsid() {
        return zsid;
    }

    public void setZsid(String zsid) {
        this.zsid = zsid;
    }
    public Integer getSyqk() {
        return syqk;
    }

    public void setSyqk(Integer syqk) {
        this.syqk = syqk;
    }

    public String getYzhid() {
        return yzhid;
    }

    public void setYzhid(String yzhid) {
        this.yzhid = yzhid;
    }

    public Integer getZslx() {
        return zslx;
    }

    public void setZslx(Integer zslx) {
        this.zslx = zslx;
    }

    public String getQzysxlh() {
        return qzysxlh;
    }

    public void setQzysxlh(String qzysxlh) {
        this.qzysxlh = qzysxlh;
    }

    public String getSyr() {
        return syr;
    }

    public void setSyr(String syr) {
        this.syr = syr;
    }

    public String getLqrid() {
        return lqrid;
    }

    public void setLqrid(String lqrid) {
        this.lqrid = lqrid;
    }

    public String getLqbmid() {
        return lqbmid;
    }

    public void setLqbmid(String lqbmid) {
        this.lqbmid = lqbmid;
    }

    public String getQxdm() {
        return qxdm;
    }

    public void setQxdm(String qxdm) {
        this.qxdm = qxdm;
    }

    public String getNf() {
        return nf;
    }

    public void setNf(String nf) {
        this.nf = nf;
    }

    public String getOrderField() {
        return orderField;
    }

    public void setOrderField(String orderField) {
        this.orderField = orderField;
    }

    public String getOrderType() {
        return orderType;
    }

    public void setOrderType(String orderType) {
        this.orderType = orderType;
    }

    public Integer getNum() {
        return num;
    }

    public void setNum(Integer num) {
        this.num = num;
    }
    @Override
    public String toString() {
        return "BdcYzhQO{" +
                "syqk=" + syqk +
                ", yzhid='" + yzhid + '\'' +
                ", zslx=" + zslx +
                ", zsid='" + zsid + '\'' +
                ", qzysxlh='" + qzysxlh + '\'' +
                ", syr='" + syr + '\'' +
                ", syrid='" + syrid + '\'' +
                ", lqrid='" + lqrid + '\'' +
                ", lqbmid='" + lqbmid + '\'' +
                ", qxdm='" + qxdm + '\'' +
                ", nf='" + nf + '\'' +
                ", orderField='" + orderField + '\'' +
                ", orderType='" + orderType + '\'' +
                ", num=" + num +
                ", zsidList=" + zsidList +
                '}';
    }

}
