package cn.gtmap.realestate.common.core.qo.certificate;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * @author <a href="mailto:bianwen@gtmap.cn">bianwen/a>"
 * @version 1.0, 2018/11/19
 * @description 归档信息查询QO
 */
@ApiModel(value = "BdcGdxxQO",description = "不动产归档信息查询对象")
public class BdcGdxxQO implements Serializable {

    @ApiModelProperty(value = "不动产权证号")
    private String bdcqzh;

    @ApiModelProperty(value = "坐落")
    private String zl;

    @ApiModelProperty(value = "不动产单元号")
    private String bdcdyh;

    @ApiModelProperty(value = "项目id", hidden = true)
    private String xmid;

    @ApiModelProperty(value = "档案id", hidden=true)
    private String daid;

    @ApiModelProperty(value = "受理编号")
    private String slbh;

    @ApiModelProperty(value = "归档人姓名")
    private String gdrxm;

    @ApiModelProperty(value = "是否已归档")
    private Integer sfygd;

    @ApiModelProperty(value = "是否已移交")
    private Integer sfyyj;

    public Integer getSfygd() {
        return sfygd;
    }

    public void setSfygd(Integer sfygd) {
        this.sfygd = sfygd;
    }

    public Integer getSfyyj() {
        return sfyyj;
    }

    public void setSfyyj(Integer sfyyj) {
        this.sfyyj = sfyyj;
    }

    public String getBdcqzh() {
        return bdcqzh;
    }

    public void setBdcqzh(String bdcqzh) {
        this.bdcqzh = bdcqzh;
    }

    public String getZl() {
        return zl;
    }

    public void setZl(String zl) {
        this.zl = zl;
    }

    public String getBdcdyh() {
        return bdcdyh;
    }

    public void setBdcdyh(String bdcdyh) {
        this.bdcdyh = bdcdyh;
    }

    public String getXmid() {
        return xmid;
    }

    public void setXmid(String xmid) {
        this.xmid = xmid;
    }

    public String getDaid() {
        return daid;
    }

    public void setDaid(String daid) {
        this.daid = daid;
    }

    public String getSlbh() {
        return slbh;
    }

    public void setSlbh(String slbh) {
        this.slbh = slbh;
    }

    public String getGdrxm() {
        return gdrxm;
    }

    public void setGdrxm(String gdrxm) {
        this.gdrxm = gdrxm;
    }

    @Override
    public String toString() {
        return "BdcGdxxQO{" +
                "bdcqzh='" + bdcqzh + '\'' +
                ", zl='" + zl + '\'' +
                ", bdcdyh='" + bdcdyh + '\'' +
                ", xmid='" + xmid + '\'' +
                ", daid='" + daid + '\'' +
                ", slbh='" + slbh + '\'' +
                ", gdrxm='" + gdrxm + '\'' +
                ", sfygd=" + sfygd +
                ", sfyyj=" + sfyyj +
                '}';
    }
}
