package cn.gtmap.realestate.common.core.qo.analysis;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * @author <a href="mailto:wangwei2@gtmap.cn">wangwei2</a>
 * @version 1.0, 2018/12/14
 * @description
 */
@ApiModel(value = "BdcZfcxZmdQO", description = "住房查询证明单QO")
public class BdcZfcxZmdQO{

    @ApiModelProperty("项目id")
    private List<String> xmid;

    @ApiModelProperty("全选记录 0:否  1:是")
    private String exportAll;

    @ApiModelProperty("导出全选记录时，不导出的记录")
    private List<String> unExportList;

    @ApiModelProperty("住房查询条件，导出全部记录时使用")
    private BdcZfcxQO zfcxQO;

    @ApiModelProperty("")
    private String areaName;

    @ApiModelProperty("行政区名称")
    private String xzqmc;

    @ApiModelProperty("代理人")
    private String dlr;

    @ApiModelProperty("代理人证件号")
    private String dlrZjh;

    @ApiModelProperty("类别")
    private String lb;

    @ApiModelProperty("经办人")
    private String jbr;

    @ApiModelProperty("附记")
    private String fj;

    @ApiModelProperty("")
    private String xzdm;

    @ApiModelProperty("查询目的")
    private String cxmd;

    @ApiModelProperty("权利人姓名，多个以','拼接")
    private String qlrs;

    @ApiModelProperty("权利人证件号，多个以','拼接")
    private String zjhs;

    @ApiModelProperty("权利人姓名")
    private String qlrmc;

    @ApiModelProperty("权利人证件号")
    private String qlrzjh;

    @ApiModelProperty("申请人")
    private String sqr;

    @ApiModelProperty("申请人证件号")
    private String sqrzjh;

    @ApiModelProperty(value = "权利人或证件号个数", hidden = true)
    private int size;

    @ApiModelProperty("登记机构")
    private String djjg;

    @ApiModelProperty("")
    private String yt;

    @ApiModelProperty("登记机构联系电话")
    private String djjglxdh;

    @ApiModelProperty("查询编号")
    private String cxbh;

    @ApiModelProperty("模板名称")
    private String templatName;

    public List<String> getXmid() {
        return xmid;
    }

    public void setXmid(List<String> xmid) {
        this.xmid = xmid;
    }

    public String getExportAll() {
        return exportAll;
    }

    public void setExportAll(String exportAll) {
        this.exportAll = exportAll;
    }

    public List<String> getUnExportList() {
        return unExportList;
    }

    public void setUnExportList(List<String> unExportList) {
        this.unExportList = unExportList;
    }

    public String getAreaName() {
        return areaName;
    }

    public void setAreaName(String areaName) {
        this.areaName = areaName;
    }

    public String getXzqmc() {
        return xzqmc;
    }

    public void setXzqmc(String xzqmc) {
        this.xzqmc = xzqmc;
    }

    public String getDlr() {
        return dlr;
    }

    public void setDlr(String dlr) {
        this.dlr = dlr;
    }

    public String getDlrZjh() {
        return dlrZjh;
    }

    public void setDlrZjh(String dlrZjh) {
        this.dlrZjh = dlrZjh;
    }

    public String getLb() {
        return lb;
    }

    public void setLb(String lb) {
        this.lb = lb;
    }

    public String getJbr() {
        return jbr;
    }

    public void setJbr(String jbr) {
        this.jbr = jbr;
    }

    public String getFj() {
        return fj;
    }

    public void setFj(String fj) {
        this.fj = fj;
    }

    public String getXzdm() {
        return xzdm;
    }

    public void setXzdm(String xzdm) {
        this.xzdm = xzdm;
    }

    public String getCxmd() {
        return cxmd;
    }

    public void setCxmd(String cxmd) {
        this.cxmd = cxmd;
    }

    public String getQlrs() {
        return qlrs;
    }

    public void setQlrs(String qlrs) {
        this.qlrs = qlrs;
    }

    public String getZjhs() {
        return zjhs;
    }

    public void setZjhs(String zjhs) {
        this.zjhs = zjhs;
    }

    public String getQlrmc() {
        return qlrmc;
    }

    public void setQlrmc(String qlrmc) {
        this.qlrmc = qlrmc;
    }

    public String getQlrzjh() {
        return qlrzjh;
    }

    public void setQlrzjh(String qlrzjh) {
        this.qlrzjh = qlrzjh;
    }

    public int getSize() {
        return size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public String getDjjg() {
        return djjg;
    }

    public void setDjjg(String djjg) {
        this.djjg = djjg;
    }

    public String getYt() {
        return yt;
    }

    public void setYt(String yt) {
        this.yt = yt;
    }

    public String getDjjglxdh() {
        return djjglxdh;
    }

    public void setDjjglxdh(String djjglxdh) {
        this.djjglxdh = djjglxdh;
    }

    public String getCxbh() {
        return cxbh;
    }

    public void setCxbh(String cxbh) {
        this.cxbh = cxbh;
    }

    public BdcZfcxQO getZfcxQO() {
        return zfcxQO;
    }

    public void setZfcxQO(BdcZfcxQO zfcxQO) {
        this.zfcxQO = zfcxQO;
    }

    public String getSqr() {
        return sqr;
    }

    public void setSqr(String sqr) {
        this.sqr = sqr;
    }

    public String getSqrzjh() {
        return sqrzjh;
    }

    public void setSqrzjh(String sqrzjh) {
        this.sqrzjh = sqrzjh;
    }

    public String getTemplatName() {
        return templatName;
    }

    public void setTemplatName(String templatName) {
        this.templatName = templatName;
    }
}
