package cn.gtmap.realestate.common.core.dto.init;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * @author <a href="mailto:yanzhenkun@gtmap.cn">yanzhenkun</a>
 * @version 1.0, 2018/11/14
 * @description 分页查询不动产权利页面的返回对象
 */
@ApiModel(value = "BdcQlPageResponseDTO",description = "分页查询不动产权利页面的返回对象")
public class BdcQlPageResponseDTO {
    @ApiModelProperty(value = "项目ID")
    private String xmid;
    @ApiModelProperty(value = "工作流实例id")
    private String gzlslid;
    @ApiModelProperty(value = "权利类型")
    private String qllx;
    @ApiModelProperty(value = "权利类型名称")
    private String qllxMc;
    @ApiModelProperty(value = "登记小类")
    private String djxl;
    @ApiModelProperty(value = "不动产单元号")
    private String bdcdyh;
    @ApiModelProperty(value = "证号")
    private String bdcqzh;
    @ApiModelProperty(value = "权利人")
    private String qlrmc;
    @ApiModelProperty(value = "坐落")
    private String zl;
    @ApiModelProperty(value = "权属状态")
    private Integer qszt;
    @ApiModelProperty(value = "定着物面积")
    private Double dzwmj;
    @ApiModelProperty(value = "定着物用途")
    private Integer dzwyt;
    @ApiModelProperty(value = "定着物用途2")
    private Integer dzwyt2;
    @ApiModelProperty(value = "定着物用途3")
    private Integer dzwyt3;
    @ApiModelProperty(value = "宗地宗海面积")
    private Double zdzhmj;

    @ApiModelProperty(value = "不动产单元房屋类型")
    private Integer bdcdyfwlx;
    @ApiModelProperty(value = "原产权证号")
    private String ycqzh;
    @ApiModelProperty(value = "原房产证号")
    private String yfczh;
    @ApiModelProperty(value = "原土地证号")
    private String ytdzh;
    @ApiModelProperty(value = "流程名称")
    private String gzldymc;
    @ApiModelProperty(value = "登记时间",example = "2018-10-01 12:18:48")
    private Date djsj;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "受理时间",example = "2018-10-01 12:18:48")
    private Date slsj;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "结束时间",example = "2018-10-01 12:18:48")
    private Date jssj;

    @ApiModelProperty(value = "不动产单元唯一编号")
    private String bdcdywybh;

    @ApiModelProperty(value = "权利人证件号")
    private String qlrzjh;

    @ApiModelProperty(value = "项目来源")
    private String xmly;

    @ApiModelProperty(value = "不动产类型")
    private String bdclx;

    @ApiModelProperty(value = "房产预售房屋编码")
    private String ysfwbm;

    @ApiModelProperty(value = "TT系统证号")
    private String yxtcqzh;

    @ApiModelProperty(value = "原不动产单元号")
    private String ybdcdyh;

    @ApiModelProperty(value = "受理编号")
    private String slbh;

    public String getSlbh() {
        return slbh;
    }

    public void setSlbh(String slbh) {
        this.slbh = slbh;
    }

    public String getYbdcdyh() {
        return ybdcdyh;
    }

    public void setYbdcdyh(String ybdcdyh) {
        this.ybdcdyh = ybdcdyh;
    }

    public String getGzlslid() {
        return gzlslid;
    }

    public void setGzlslid(String gzlslid) {
        this.gzlslid = gzlslid;
    }

    public Date getDjsj() {
        return djsj;
    }

    public void setDjsj(Date djsj) {
        this.djsj = djsj;
    }

    public Integer getQszt() {
        return qszt;
    }

    public void setQszt(Integer qszt) {
        this.qszt = qszt;
    }

    public Double getDzwmj() {
        return dzwmj;
    }

    public void setDzwmj(Double dzwmj) {
        this.dzwmj = dzwmj;
    }

    public Integer getDzwyt() {
        return dzwyt;
    }

    public void setDzwyt(Integer dzwyt) {
        this.dzwyt = dzwyt;
    }

    public Integer getDzwyt2() {
        return dzwyt2;
    }

    public void setDzwyt2(Integer dzwyt2) {
        this.dzwyt2 = dzwyt2;
    }

    public Integer getDzwyt3() {
        return dzwyt3;
    }

    public void setDzwyt3(Integer dzwyt3) {
        this.dzwyt3 = dzwyt3;
    }

    public Double getZdzhmj() {
        return zdzhmj;
    }

    public void setZdzhmj(Double zdzhmj) {
        this.zdzhmj = zdzhmj;
    }


    public Integer getBdcdyfwlx() {
        return bdcdyfwlx;
    }

    public void setBdcdyfwlx(Integer bdcdyfwlx) {
        this.bdcdyfwlx = bdcdyfwlx;
    }

    public String getYcqzh() {
        return ycqzh;
    }

    public void setYcqzh(String ycqzh) {
        this.ycqzh = ycqzh;
    }

    public String getYfczh() {
        return yfczh;
    }

    public void setYfczh(String yfczh) {
        this.yfczh = yfczh;
    }

    public String getYtdzh() {
        return ytdzh;
    }

    public void setYtdzh(String ytdzh) {
        this.ytdzh = ytdzh;
    }

    public String getXmid() {
        return xmid;
    }

    public void setXmid(String xmid) {
        this.xmid = xmid;
    }

    public String getQllx() {
        return qllx;
    }

    public void setQllx(String qllx) {
        this.qllx = qllx;
    }

    public String getDjxl() {
        return djxl;
    }

    public void setDjxl(String djxl) {
        this.djxl = djxl;
    }

    public String getBdcdyh() {
        return bdcdyh;
    }

    public void setBdcdyh(String bdcdyh) {
        this.bdcdyh = bdcdyh;
    }

    public String getBdcqzh() {
        return bdcqzh;
    }

    public void setBdcqzh(String bdcqzh) {
        this.bdcqzh = bdcqzh;
    }

    public String getQlrmc() {
        return qlrmc;
    }

    public void setQlrmc(String qlrmc) {
        this.qlrmc = qlrmc;
    }

    public String getZl() {
        return zl;
    }

    public void setZl(String zl) {
        this.zl = zl;
    }


    public Date getSlsj() {
        return slsj;
    }

    public void setSlsj(Date slsj) {
        this.slsj = slsj;
    }

    public Date getJssj() {
        return jssj;
    }

    public void setJssj(Date jssj) {
        this.jssj = jssj;
    }

    public String getGzldymc() {
        return gzldymc;
    }

    public void setGzldymc(String gzldymc) {
        this.gzldymc = gzldymc;
    }

    public String getBdcdywybh() {
        return bdcdywybh;
    }

    public void setBdcdywybh(String bdcdywybh) {
        this.bdcdywybh = bdcdywybh;
    }

    public String getQlrzjh() {
        return qlrzjh;
    }

    public void setQlrzjh(String qlrzjh) {
        this.qlrzjh = qlrzjh;
    }

    public String getXmly() {
        return xmly;
    }

    public void setXmly(String xmly) {
        this.xmly = xmly;
    }

    public String getBdclx() {
        return bdclx;
    }

    public void setBdclx(String bdclx) {
        this.bdclx = bdclx;
    }

    public String getYsfwbm() {
        return ysfwbm;
    }

    public void setYsfwbm(String ysfwbm) {
        this.ysfwbm = ysfwbm;
    }

    public String getQllxMc() {
        return qllxMc;
    }

    public void setQllxMc(String qllxMc) {
        this.qllxMc = qllxMc;
    }

    public String getYxtcqzh() {
        return yxtcqzh;
    }

    public void setYxtcqzh(String yxtcqzh) {
        this.yxtcqzh = yxtcqzh;
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("BdcQlPageResponseDTO{");
        sb.append("xmid='").append(xmid).append('\'');
        sb.append(", gzlslid='").append(gzlslid).append('\'');
        sb.append(", qllx='").append(qllx).append('\'');
        sb.append(", qllxMc='").append(qllxMc).append('\'');
        sb.append(", djxl='").append(djxl).append('\'');
        sb.append(", bdcdyh='").append(bdcdyh).append('\'');
        sb.append(", bdcqzh='").append(bdcqzh).append('\'');
        sb.append(", qlrmc='").append(qlrmc).append('\'');
        sb.append(", zl='").append(zl).append('\'');
        sb.append(", qszt=").append(qszt);
        sb.append(", dzwmj=").append(dzwmj);
        sb.append(", dzwyt=").append(dzwyt);
        sb.append(", dzwyt2=").append(dzwyt2);
        sb.append(", dzwyt3=").append(dzwyt3);
        sb.append(", zdzhmj=").append(zdzhmj);
        sb.append(", bdcdyfwlx=").append(bdcdyfwlx);
        sb.append(", ycqzh='").append(ycqzh).append('\'');
        sb.append(", yfczh='").append(yfczh).append('\'');
        sb.append(", ytdzh='").append(ytdzh).append('\'');
        sb.append(", gzldymc='").append(gzldymc).append('\'');
        sb.append(", djsj=").append(djsj);
        sb.append(", slsj=").append(slsj);
        sb.append(", jssj=").append(jssj);
        sb.append(", bdcdywybh='").append(bdcdywybh).append('\'');
        sb.append(", qlrzjh='").append(qlrzjh).append('\'');
        sb.append(", xmly='").append(xmly).append('\'');
        sb.append(", bdclx='").append(bdclx).append('\'');
        sb.append(", ysfwbm='").append(ysfwbm).append('\'');
        sb.append(", ybdcdyh='").append(ybdcdyh).append('\'');
        sb.append(", slbh='").append(slbh).append('\'');
        sb.append('}');
        return sb.toString();
    }
}
