package cn.gtmap.realestate.common.core.dto.building;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

/**
 * @author <a href="mailto:wangzijie@gtmap.cn">wangzijie</a>
 * @version 1.0  2018/11/16
 * @description 宗地地籍调查簿DTO
 */
@ApiModel(value = "ZdDjdcbResponseDTO", description = "宗地地籍调查簿DTO")
@JsonTypeInfo(use = JsonTypeInfo.Id.CLASS, include = JsonTypeInfo.As.PROPERTY, property = "@Clazz",defaultImpl = ZdDjdcbResponseDTO.class)
public class ZdDjdcbResponseDTO extends DjDcbResponseDTO {

    /**
     * 主键
     */
    @ApiModelProperty(value = "主键")
    private String zdDjdcbIndex;
    /**
     * 地籍号
     */
    @ApiModelProperty(value = "地籍号")
    private String djh;
    /**
     * 不动产单元号
     */
    @ApiModelProperty(value = "不动产单元号")
    private String bdcdyh;
    /**
     * 土地所有者名称
     */
    @ApiModelProperty(value = "土地所有者名称")
    private String tdsyzmc;
    /**
     * 所在图幅号
     */
    @ApiModelProperty(value = "所在图幅号")
    private String sztfh;
    /**
     * 权属性质
     */
    @ApiModelProperty(value = "权属性质")
    private String qsxz;
    /**
     * 宗地特征码
     */
    @ApiModelProperty(value = "宗地特征码")
    private String qslx;
    /**
     * 土地座落
     */
    @ApiModelProperty(value = "土地座落")
    private String tdzl;
    /**
     * 使用权类型
     */
    @ApiModelProperty(value = "使用权类型")
    private String syqlx;
    /**
     * 比例尺
     */
    @ApiModelProperty(value = "比例尺")
    private String blc;
    /**
     * 土地用途
     */
    @ApiModelProperty(value = "土地用途")
    private String tdyt;
    /**
     * 土地用途2
     */
    @ApiModelProperty(value = "土地用途2")
    private String tdyt2;
    /**
     * 土地用途3
     */
    @ApiModelProperty(value = "土地用途3")
    private String tdyt3;
    /**
     * 起始日期
     */
    @ApiModelProperty(value = "起始日期",example = "2018-10-01 12:18:21")
    private Date qsrq;
    /**
     * 起始日期2
     */
    @ApiModelProperty(value = "起始日期2",example = "2018-10-01 12:18:21")
    private Date qsrq2;
    /**
     * 起始日期3
     */
    @ApiModelProperty(value = "起始日期3",example = "2018-10-01 12:18:21")
    private Date qsrq3;
    /**
     * 终止日期
     */
    @ApiModelProperty(value = "终止日期",example = "2018-10-01 12:18:21")
    private Date zzrq;
    /**
     * 终止日期2
     */
    @ApiModelProperty(value = "终止日期2",example = "2018-10-01 12:18:21")
    private Date zzrq2;
    /**
     * 终止日期3
     */
    @ApiModelProperty(value = "终止日期3",example = "2018-10-01 12:18:21")
    private Date zzrq3;
    /**
     * 面积单位
     */
    @ApiModelProperty(value = "面积单位")
    private Integer mjdw;
    /**
     * 实测面积
     */
    @ApiModelProperty(value = "实测面积")
    private Double scmj;
    /**
     * 发证面积
     */
    @ApiModelProperty(value = "发证面积")
    private Double fzmj;
    /**
     * 建筑密度
     */
    @ApiModelProperty(value = "建筑密度")
    private Double jzmd;
    /**
     * 批准面积
     */
    @ApiModelProperty(value = "批准面积")
    private Double pzmj;
    /**
     * 建筑容积率
     */
    @ApiModelProperty(value = "建筑容积率")
    private Double jzrjl;
    /**
     * 批准用途
     */
    @ApiModelProperty(value = "批准用途")
    private String pzyt;
    /**
     * 土地级别
     */
    @ApiModelProperty(value = "土地级别")
    private String tdjb;
    /**
     * 等级
     */
    @ApiModelProperty(value = "等级")
    private String dj;
    /**
     * 申报地价
     */
    @ApiModelProperty(value = "申报地价")
    private Double sbdj;
    /**
     * 取得价格
     */
    @ApiModelProperty(value = "取得价格")
    private Double qdjg;
    /**
     * 占地总面积
     */
    @ApiModelProperty(value = "占地总面积")
    private Double zdzmj;
    /**
     * 建筑总面积
     */
    @ApiModelProperty(value = "建筑总面积")
    private Double jzzmj;
    /**
     * 建筑限高
     */
    @ApiModelProperty(value = "建筑限高")
    private Double jzxg;
    /**
     * 调查类型
     */
    @ApiModelProperty(value = "调查类型")
    private String dclx;
    /**
     * 权利设定方式
     */
    @ApiModelProperty(value = "权利设定方式")
    private String qlsdfs;
    /**
     * 来源权利编号
     */
    @ApiModelProperty(value = "来源权利编号")
    private String lyqlbh;
    /**
     * 宗地四至-东
     */
    @ApiModelProperty(value = "宗地四至-东")
    private String zdszd;
    /**
     * 宗地四至-南
     */
    @ApiModelProperty(value = "宗地四至-南")
    private String zdszn;
    /**
     * 宗地四至-西
     */
    @ApiModelProperty(value = "宗地四至-西")
    private String zdszx;
    /**
     * 宗地四至-北
     */
    @ApiModelProperty(value = "宗地四至-北")
    private String zdszb;
    /**
     * 土地权属来源证明材料
     */
    @ApiModelProperty(value = "土地权属来源证明材料")
    private String tdqslyzmcl;
    /**
     * 建筑物所有权共有权利人
     */
    @ApiModelProperty(value = "建筑物所有权共有权利人")
    private String jzwsuqgyqlr;
    /**
     * 共有共用情况
     */
    @ApiModelProperty(value = "共有共用情况")
    private String gysyqqk;
    /**
     * 国民经济行业分类代码
     */
    @ApiModelProperty(value = "国民经济行业分类代码")
    private String gmjjhyfldm;
    /**
     * 预编地籍号
     */
    @ApiModelProperty(value = "预编地籍号")
    private String ybdjh;
    /**
     * 原地籍号
     */
    @ApiModelProperty(value = "原地籍号")
    private String ydjh;
    /**
     * 宗地扫描件
     */
    @ApiModelProperty(value = "宗地扫描件")
    private String zdsmj;
    /**
     * 不动产单元号状态
     */
    @ApiModelProperty(value = "不动产单元号状态")
    private String bdcdyhzt;
    /**
     * 是否有宗
     */
    @ApiModelProperty(value = "是否有宗")
    private String sfgyz;
    /**
     * 是否虚宗
     */
    @ApiModelProperty(value = "是否虚宗")
    private String sfxz;
    /**
     * 邮政编码
     */
    @ApiModelProperty(value = "邮政编码")
    private String yzbm;
    /**
     * 更新日期
     */
    @ApiModelProperty(value = "更新日期",example = "2018-10-01 12:18:21")
    private Date gxrq;

    /**
     * 建立日期
     */
    @ApiModelProperty(value = "建立日期",example = "2018-10-01 12:18:21")
    private Date jlrq;
    /**
     * 备注
     */
    @ApiModelProperty(value = "备注")
    private String bz;

    /**
     * TODO 合肥版本特殊需求 增加原用途名称
     */
    @ApiModelProperty(value = "原用途名称")
    private String yytmc;

    @ApiModelProperty(value = "受理编号")
    private String slbh;

    public String getZdDjdcbIndex() {
        return zdDjdcbIndex;
    }

    public void setZdDjdcbIndex(String zdDjdcbIndex) {
        this.zdDjdcbIndex = zdDjdcbIndex;
    }

    public String getDjh() {
        return djh;
    }

    public void setDjh(String djh) {
        this.djh = djh;
    }

    public String getBdcdyh() {
        return bdcdyh;
    }

    public void setBdcdyh(String bdcdyh) {
        this.bdcdyh = bdcdyh;
    }

    public String getTdsyzmc() {
        return tdsyzmc;
    }

    public void setTdsyzmc(String tdsyzmc) {
        this.tdsyzmc = tdsyzmc;
    }

    public String getSztfh() {
        return sztfh;
    }

    public void setSztfh(String sztfh) {
        this.sztfh = sztfh;
    }

    public String getQsxz() {
        return qsxz;
    }

    public void setQsxz(String qsxz) {
        this.qsxz = qsxz;
    }

    public String getQslx() {
        return qslx;
    }

    public void setQslx(String qslx) {
        this.qslx = qslx;
    }

    public String getTdzl() {
        return tdzl;
    }

    public void setTdzl(String tdzl) {
        this.tdzl = tdzl;
    }

    public String getSyqlx() {
        return syqlx;
    }

    public void setSyqlx(String syqlx) {
        this.syqlx = syqlx;
    }

    public String getBlc() {
        return blc;
    }

    public void setBlc(String blc) {
        this.blc = blc;
    }

    public String getTdyt() {
        return tdyt;
    }

    public void setTdyt(String tdyt) {
        this.tdyt = tdyt;
    }

    public String getTdyt2() {
        return tdyt2;
    }

    public void setTdyt2(String tdyt2) {
        this.tdyt2 = tdyt2;
    }

    public String getTdyt3() {
        return tdyt3;
    }

    public void setTdyt3(String tdyt3) {
        this.tdyt3 = tdyt3;
    }

    public Date getQsrq() {
        return qsrq;
    }

    public void setQsrq(Date qsrq) {
        this.qsrq = qsrq;
    }

    public Date getQsrq2() {
        return qsrq2;
    }

    public void setQsrq2(Date qsrq2) {
        this.qsrq2 = qsrq2;
    }

    public Date getQsrq3() {
        return qsrq3;
    }

    public void setQsrq3(Date qsrq3) {
        this.qsrq3 = qsrq3;
    }

    public Date getZzrq() {
        return zzrq;
    }

    public void setZzrq(Date zzrq) {
        this.zzrq = zzrq;
    }

    public Date getZzrq2() {
        return zzrq2;
    }

    public void setZzrq2(Date zzrq2) {
        this.zzrq2 = zzrq2;
    }

    public Date getZzrq3() {
        return zzrq3;
    }

    public void setZzrq3(Date zzrq3) {
        this.zzrq3 = zzrq3;
    }

    public Integer getMjdw() {
        return mjdw;
    }

    public void setMjdw(Integer mjdw) {
        this.mjdw = mjdw;
    }

    public Double getScmj() {
        return scmj;
    }

    public void setScmj(Double scmj) {
        this.scmj = scmj;
    }

    public Double getFzmj() {
        return fzmj;
    }

    public void setFzmj(Double fzmj) {
        this.fzmj = fzmj;
    }

    public Double getJzmd() {
        return jzmd;
    }

    public void setJzmd(Double jzmd) {
        this.jzmd = jzmd;
    }

    public Double getPzmj() {
        return pzmj;
    }

    public void setPzmj(Double pzmj) {
        this.pzmj = pzmj;
    }

    public Double getJzrjl() {
        return jzrjl;
    }

    public void setJzrjl(Double jzrjl) {
        this.jzrjl = jzrjl;
    }

    public String getPzyt() {
        return pzyt;
    }

    public void setPzyt(String pzyt) {
        this.pzyt = pzyt;
    }

    public String getTdjb() {
        return tdjb;
    }

    public void setTdjb(String tdjb) {
        this.tdjb = tdjb;
    }

    public String getDj() {
        return dj;
    }

    public void setDj(String dj) {
        this.dj = dj;
    }

    public Double getSbdj() {
        return sbdj;
    }

    public void setSbdj(Double sbdj) {
        this.sbdj = sbdj;
    }

    public Double getQdjg() {
        return qdjg;
    }

    public void setQdjg(Double qdjg) {
        this.qdjg = qdjg;
    }

    public Double getZdzmj() {
        return zdzmj;
    }

    public void setZdzmj(Double zdzmj) {
        this.zdzmj = zdzmj;
    }

    public Double getJzzmj() {
        return jzzmj;
    }

    public void setJzzmj(Double jzzmj) {
        this.jzzmj = jzzmj;
    }

    public Double getJzxg() {
        return jzxg;
    }

    public void setJzxg(Double jzxg) {
        this.jzxg = jzxg;
    }

    public String getDclx() {
        return dclx;
    }

    public void setDclx(String dclx) {
        this.dclx = dclx;
    }

    public String getQlsdfs() {
        return qlsdfs;
    }

    public void setQlsdfs(String qlsdfs) {
        this.qlsdfs = qlsdfs;
    }

    public String getLyqlbh() {
        return lyqlbh;
    }

    public void setLyqlbh(String lyqlbh) {
        this.lyqlbh = lyqlbh;
    }

    public String getZdszd() {
        return zdszd;
    }

    public void setZdszd(String zdszd) {
        this.zdszd = zdszd;
    }

    public String getZdszn() {
        return zdszn;
    }

    public void setZdszn(String zdszn) {
        this.zdszn = zdszn;
    }

    public String getZdszx() {
        return zdszx;
    }

    public void setZdszx(String zdszx) {
        this.zdszx = zdszx;
    }

    public String getZdszb() {
        return zdszb;
    }

    public void setZdszb(String zdszb) {
        this.zdszb = zdszb;
    }

    public String getTdqslyzmcl() {
        return tdqslyzmcl;
    }

    public void setTdqslyzmcl(String tdqslyzmcl) {
        this.tdqslyzmcl = tdqslyzmcl;
    }

    public String getJzwsuqgyqlr() {
        return jzwsuqgyqlr;
    }

    public void setJzwsuqgyqlr(String jzwsuqgyqlr) {
        this.jzwsuqgyqlr = jzwsuqgyqlr;
    }

    public String getGysyqqk() {
        return gysyqqk;
    }

    public void setGysyqqk(String gysyqqk) {
        this.gysyqqk = gysyqqk;
    }

    public String getGmjjhyfldm() {
        return gmjjhyfldm;
    }

    public void setGmjjhyfldm(String gmjjhyfldm) {
        this.gmjjhyfldm = gmjjhyfldm;
    }

    public String getYbdjh() {
        return ybdjh;
    }

    public void setYbdjh(String ybdjh) {
        this.ybdjh = ybdjh;
    }

    public String getYdjh() {
        return ydjh;
    }

    public void setYdjh(String ydjh) {
        this.ydjh = ydjh;
    }

    public String getZdsmj() {
        return zdsmj;
    }

    public void setZdsmj(String zdsmj) {
        this.zdsmj = zdsmj;
    }

    public String getBdcdyhzt() {
        return bdcdyhzt;
    }

    public void setBdcdyhzt(String bdcdyhzt) {
        this.bdcdyhzt = bdcdyhzt;
    }

    public String getSfgyz() {
        return sfgyz;
    }

    public void setSfgyz(String sfgyz) {
        this.sfgyz = sfgyz;
    }

    public String getSfxz() {
        return sfxz;
    }

    public void setSfxz(String sfxz) {
        this.sfxz = sfxz;
    }

    public String getYzbm() {
        return yzbm;
    }

    public void setYzbm(String yzbm) {
        this.yzbm = yzbm;
    }

    public Date getGxrq() {
        return gxrq;
    }

    public void setGxrq(Date gxrq) {
        this.gxrq = gxrq;
    }

    public Date getJlrq() {
        return jlrq;
    }

    public void setJlrq(Date jlrq) {
        this.jlrq = jlrq;
    }

    public String getBz() {
        return bz;
    }

    public void setBz(String bz) {
        this.bz = bz;
    }

    public String getYytmc() {
        return yytmc;
    }

    public void setYytmc(String yytmc) {
        this.yytmc = yytmc;
    }

    public String getSlbh() {
        return slbh;
    }

    public void setSlbh(String slbh) {
        this.slbh = slbh;
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("ZdDjdcbResponseDTO{");
        sb.append("zdDjdcbIndex='").append(zdDjdcbIndex).append('\'');
        sb.append(", djh='").append(djh).append('\'');
        sb.append(", bdcdyh='").append(bdcdyh).append('\'');
        sb.append(", tdsyzmc='").append(tdsyzmc).append('\'');
        sb.append(", sztfh='").append(sztfh).append('\'');
        sb.append(", qsxz='").append(qsxz).append('\'');
        sb.append(", qslx='").append(qslx).append('\'');
        sb.append(", tdzl='").append(tdzl).append('\'');
        sb.append(", syqlx='").append(syqlx).append('\'');
        sb.append(", blc='").append(blc).append('\'');
        sb.append(", tdyt='").append(tdyt).append('\'');
        sb.append(", tdyt2='").append(tdyt2).append('\'');
        sb.append(", tdyt3='").append(tdyt3).append('\'');
        sb.append(", qsrq=").append(qsrq);
        sb.append(", qsrq2=").append(qsrq2);
        sb.append(", qsrq3=").append(qsrq3);
        sb.append(", zzrq=").append(zzrq);
        sb.append(", zzrq2=").append(zzrq2);
        sb.append(", zzrq3=").append(zzrq3);
        sb.append(", mjdw=").append(mjdw);
        sb.append(", scmj=").append(scmj);
        sb.append(", fzmj=").append(fzmj);
        sb.append(", jzmd=").append(jzmd);
        sb.append(", pzmj=").append(pzmj);
        sb.append(", jzrjl=").append(jzrjl);
        sb.append(", pzyt='").append(pzyt).append('\'');
        sb.append(", tdjb='").append(tdjb).append('\'');
        sb.append(", dj='").append(dj).append('\'');
        sb.append(", sbdj=").append(sbdj);
        sb.append(", qdjg=").append(qdjg);
        sb.append(", zdzmj=").append(zdzmj);
        sb.append(", jzzmj=").append(jzzmj);
        sb.append(", jzxg=").append(jzxg);
        sb.append(", dclx='").append(dclx).append('\'');
        sb.append(", qlsdfs='").append(qlsdfs).append('\'');
        sb.append(", lyqlbh='").append(lyqlbh).append('\'');
        sb.append(", zdszd='").append(zdszd).append('\'');
        sb.append(", zdszn='").append(zdszn).append('\'');
        sb.append(", zdszx='").append(zdszx).append('\'');
        sb.append(", zdszb='").append(zdszb).append('\'');
        sb.append(", tdqslyzmcl='").append(tdqslyzmcl).append('\'');
        sb.append(", jzwsuqgyqlr='").append(jzwsuqgyqlr).append('\'');
        sb.append(", gysyqqk='").append(gysyqqk).append('\'');
        sb.append(", gmjjhyfldm='").append(gmjjhyfldm).append('\'');
        sb.append(", ybdjh='").append(ybdjh).append('\'');
        sb.append(", ydjh='").append(ydjh).append('\'');
        sb.append(", zdsmj='").append(zdsmj).append('\'');
        sb.append(", bdcdyhzt='").append(bdcdyhzt).append('\'');
        sb.append(", sfgyz='").append(sfgyz).append('\'');
        sb.append(", sfxz='").append(sfxz).append('\'');
        sb.append(", yzbm='").append(yzbm).append('\'');
        sb.append(", gxrq=").append(gxrq);
        sb.append(", jlrq=").append(jlrq);
        sb.append(", bz='").append(bz).append('\'');
        sb.append(", yytmc='").append(yytmc).append('\'');
        sb.append(", slbh='").append(slbh).append('\'');
        sb.append('}');
        return sb.toString();
    }
}