package cn.gtmap.realestate.common.core.dto.accept;

import cn.gtmap.realestate.common.core.domain.BdcFdcqDO;
import cn.gtmap.realestate.common.core.domain.accept.BdcSlFwxxDO;
import cn.gtmap.realestate.common.core.domain.accept.BdcSlJbxxDO;
import cn.gtmap.realestate.common.core.domain.accept.BdcSlJyxxDO;
import cn.gtmap.realestate.common.core.domain.accept.BdcSlSqrDO;
import cn.gtmap.realestate.common.core.domain.accept.BdcSlXmDO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
 * @version 1.0, 2019/7/17
 * @description 推送到税务的数据
 */
@ApiModel(value = "TsswDataDTO", description = "推送到税务的数据模型")
public class TsswDataDTO {

    @ApiModelProperty(value = "项目ID")
    private String xmid;

    @ApiModelProperty(value = "受理编号")
    private String slbh;

    @ApiModelProperty(value = "不动产受理基本信息")
    private BdcSlJbxxDO bdcSlJbxx;

    @ApiModelProperty(value = "不动产受理房屋信息")
    private BdcSlFwxxDO bdcSlFwxx;

    @ApiModelProperty(value = "不动产受理项目")
    private BdcSlXmDO bdcSlXm;

    @ApiModelProperty(value = "不动产受理交易信息")
    private BdcSlJyxxDO bdcSlJyxx;

    @ApiModelProperty(value = "不动产房地产权信息")
    private BdcFdcqDO bdcFdcqDO;

    @ApiModelProperty(value = "不动产受理申请人信息")
    private List<BdcSlSqrDO> sqrList;

    @ApiModelProperty(value = "附件材料信息列表")
    private List<TsswDataFjclDTO> fjclList;

    public String getXmid() {
        return xmid;
    }

    public void setXmid(String xmid) {
        this.xmid = xmid;
    }

    public String getSlbh() {
        return slbh;
    }

    public void setSlbh(String slbh) {
        this.slbh = slbh;
    }

    public BdcSlJbxxDO getBdcSlJbxx() {
        return bdcSlJbxx;
    }

    public void setBdcSlJbxx(BdcSlJbxxDO bdcSlJbxx) {
        this.bdcSlJbxx = bdcSlJbxx;
    }

    public BdcSlFwxxDO getBdcSlFwxx() {
        return bdcSlFwxx;
    }

    public void setBdcSlFwxx(BdcSlFwxxDO bdcSlFwxx) {
        this.bdcSlFwxx = bdcSlFwxx;
    }

    public BdcSlXmDO getBdcSlXm() {
        return bdcSlXm;
    }

    public void setBdcSlXm(BdcSlXmDO bdcSlXm) {
        this.bdcSlXm = bdcSlXm;
    }

    public BdcSlJyxxDO getBdcSlJyxx() {
        return bdcSlJyxx;
    }

    public void setBdcSlJyxx(BdcSlJyxxDO bdcSlJyxx) {
        this.bdcSlJyxx = bdcSlJyxx;
    }

    public BdcFdcqDO getBdcFdcqDO() {
        return bdcFdcqDO;
    }

    public void setBdcFdcqDO(BdcFdcqDO bdcFdcqDO) {
        this.bdcFdcqDO = bdcFdcqDO;
    }

    public List<BdcSlSqrDO> getSqrList() {
        return sqrList;
    }

    public void setSqrList(List<BdcSlSqrDO> sqrList) {
        this.sqrList = sqrList;
    }

    public List<TsswDataFjclDTO> getFjclList() {
        return fjclList;
    }

    public void setFjclList(List<TsswDataFjclDTO> fjclList) {
        this.fjclList = fjclList;
    }
}
