package cn.gtmap.realestate.common.core.dto;

/**
 * @author <a href="mailto:zhuyong@gtmap.cn">zhuyong</a>
 * @version 1.0, 2019/5/22
 * @description  Excel导出信息实体定义
 */
public class ExcelExportDTO {
    /**
     * 初始行定位
     */
    private Integer rownum;

    /**
     * 文件名称
     */
    private String fileName;

    /**
     * 工作簿名称
     */
    private String sheetName;

    /**
     * 汇总信息
     */
    private String summaryContent;

    /**
     * 列标题，以英文逗号分隔，例如  序号,名称,备注
     */
    private String cellTitle;

    /**
     * 列对应的key，以英文逗号分隔，内容要与cellTitle定义的标题顺序一致
     */
    private String cellKey;

    /**
     * 列宽，以英文逗号分隔，内容要与cellTitle定义的标题顺序一致
     */
    private String cellWidth;

    /**
     * 要导出的JSON数据，内容要与cellTitle定义的标题顺序一致
     */
    private String data;

    /**
     * 是否合并相同值的列: false(不合并)，true(合并)
     */
    private Boolean mergeSameCell;
    /**
     * 指定需要合并相同值的列
     */
    private String mergeCellKey;


    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public Integer getRownum() {
        return rownum;
    }

    public void setRownum(Integer rownum) {
        this.rownum = rownum;
    }


    public String getSheetName() {
        return sheetName;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    public String getCellTitle() {
        return cellTitle;
    }

    public void setCellTitle(String cellTitle) {
        this.cellTitle = cellTitle;
    }

    public String getData() {
        return data;
    }

    public String getSummaryContent() {
        return summaryContent;
    }

    public void setSummaryContent(String summaryContent) {
        this.summaryContent = summaryContent;
    }

    public void setData(String data) {
        this.data = data;
    }

    public String getCellKey() {
        return cellKey;
    }

    public void setCellKey(String cellKey) {
        this.cellKey = cellKey;
    }

    public String getCellWidth() {
        return cellWidth;
    }

    public void setCellWidth(String cellWidth) {
        this.cellWidth = cellWidth;
    }

    public Boolean getMergeSameCell() {
        return mergeSameCell == null ? false : mergeSameCell;
    }

    public void setMergeSameCell(Boolean mergeSameCell) {
        this.mergeSameCell = mergeSameCell;
    }

    public String getMergeCellKey() {
        return mergeCellKey;
    }

    public void setMergeCellKey(String mergeCellKey) {
        this.mergeCellKey = mergeCellKey;
    }

    @Override
    public String toString() {
        return "ExcelExportDTO{" +
                "rownum=" + rownum +
                ", fileName='" + fileName + '\'' +
                ", sheetName='" + sheetName + '\'' +
                ", summaryContent='" + summaryContent + '\'' +
                ", cellTitle='" + cellTitle + '\'' +
                ", cellKey='" + cellKey + '\'' +
                ", cellWidth='" + cellWidth + '\'' +
                ", data='" + data + '\'' +
                ", mergeSameCell='" + mergeSameCell + '\'' +
                ", mergeCellKey='" + mergeCellKey + '\'' +
                '}';
    }
}
